/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.mission.plan;

import com.l2fprod.common.propertysheet.DefaultProperty;
import java.util.Collection;
import java.util.HashSet;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.params.ConfigurationManager;
import pt.lsts.neptus.params.ManeuverPayloadConfig;
import pt.lsts.neptus.params.SystemProperty;
import pt.lsts.neptus.types.mission.plan.ManeuverNotSupportedException;
import pt.lsts.neptus.types.mission.plan.PayloadNotSupportedException;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;

public class PlanCompability {
    public static boolean isVehicleCompatible(VehicleType vehicle, PlanType plan) {
        try {
            PlanCompability.testCompatibility(vehicle, plan);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void testCompatibility(VehicleType vehicle, PlanType plan) throws PayloadNotSupportedException, ManeuverNotSupportedException {
        Collection<String> mansMissing = PlanCompability.maneuversMissing(vehicle, plan);
        if (!mansMissing.isEmpty()) {
            throw new ManeuverNotSupportedException(mansMissing.iterator().next());
        }
    }

    private static Collection<String> maneuversMissing(VehicleType v, PlanType plan) {
        Maneuver[] mans = plan.getGraph().getAllManeuvers();
        HashSet<String> manNames = new HashSet<String>();
        for (Maneuver m : mans) {
            manNames.add(m.getType());
        }
        HashSet<String> result = new HashSet<String>();
        for (String man : manNames) {
            if (v.getFeasibleManeuvers().containsKey(man)) continue;
            result.add(man);
        }
        return result;
    }

    private static Collection<String> payloadsMissing(VehicleType vehicle, PlanType plan) {
        Maneuver[] mans;
        HashSet<String> needed = new HashSet<String>();
        HashSet<String> missing = new HashSet<String>();
        for (Maneuver m : mans = plan.getGraph().getAllManeuvers()) {
            ManeuverPayloadConfig cfg = new ManeuverPayloadConfig(vehicle.getId(), m, null);
            for (DefaultProperty p : cfg.getProperties()) {
                needed.add(p.getCategory());
            }
        }
        Collection<String> existing = PlanCompability.availablePayloads(vehicle);
        for (String p : needed) {
            if (existing.contains(p)) continue;
            missing.add(p);
        }
        return missing;
    }

    private static Collection<String> availablePayloads(VehicleType vehicle) {
        HashSet<String> existing = new HashSet<String>();
        for (SystemProperty p : ConfigurationManager.getInstance().getClonedProperties(vehicle.getId(), SystemProperty.Visibility.USER, SystemProperty.Scope.MANEUVER)) {
            existing.add(p.getCategory());
        }
        return existing;
    }
}

