/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.mission.plan;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.MissionFileChooser;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.IPlanFileExporter;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

public class PlanToCsvConverter
implements IPlanFileExporter {
    public static void main(String[] args) {
        File mfile = MissionFileChooser.showOpenMissionDialog(new String[]{"nmis", "nmisz"});
        if (mfile == null) {
            System.exit(0);
        }
        try {
            MissionType mt = new MissionType(mfile.getAbsolutePath());
            Vector<String> plans = new Vector<String>();
            for (PlanType plan : mt.getIndividualPlansList().values()) {
                plans.add(plan.getId());
            }
            Object res = JOptionPane.showInputDialog(null, "please choose plan to export", "Select plan", 3, null, plans.toArray(new String[0]), plans.firstElement());
            JFileChooser chooser = new JFileChooser();
            if (chooser.showSaveDialog(null) != 1) {
                NeptusLog.pub().info((Object)("<###>Save " + res + " to " + chooser.getSelectedFile().getAbsolutePath()));
                PlanToCsvConverter.saveAsCsv(mt.getIndividualPlansList().get(res.toString()), chooser.getSelectedFile());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportToFile(PlanType plan, File out, ProgressMonitor monitor) throws Exception {
        PlanToCsvConverter.saveAsCsv(plan, out);
    }

    @Override
    public String getExporterName() {
        return "CSV";
    }

    @Override
    public String[] validExtensions() {
        return new String[]{"csv"};
    }

    public static void saveAsCsv(PlanType plan, File out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("Waypoint Id\tLatitude\tLongitude\tLatDegrees\tLonDegrees\n");
        LocationType lastLocation = null;
        for (Maneuver m : plan.getGraph().getManeuversSequence()) {
            if (m instanceof LocatedManeuver) {
                lastLocation = new LocationType(((LocatedManeuver)((Object)m)).getManeuverLocation());
            }
            if (lastLocation == null) continue;
            bw.write(m.getId() + "\t" + lastLocation.getLatitudeAsPrettyString() + "\t" + lastLocation.getLongitudeAsPrettyString() + "\t" + GuiUtils.getNeptusDecimalFormat(7).format(lastLocation.getAbsoluteLatLonDepth()[0]) + "\t" + GuiUtils.getNeptusDecimalFormat(7).format(lastLocation.getAbsoluteLatLonDepth()[1]) + "\n");
        }
        bw.close();
    }
}

