/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.mission.plan;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.PlanManeuver;
import pt.lsts.imc.PlanSpecification;
import pt.lsts.imc.PlanTransition;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.actions.PlanActions;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.PathProvider;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.params.ManeuverPayloadConfig;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.NameId;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.map.PlanUtil;
import pt.lsts.neptus.types.mission.GraphType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.TransitionType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.NameNormalizer;

public class PlanType
implements XmlOutputMethods,
PropertiesProvider,
NameId {
    public static final int INIT_HOMEREF = 0;
    public static final int INIT_START_WPT = 1;
    public static final int INIT_NONE = 2;
    protected static final String DEFAULT_ROOT_ELEMENT = "plan";
    protected String id = NameNormalizer.getRandomID("pl");
    protected Vector<VehicleType> vehicles = new Vector();
    protected MissionType missionType = null;
    protected GraphType graph = new GraphType();
    protected PlanActions startActions = new PlanActions();
    protected PlanActions endActions = new PlanActions();
    private MapType planMap = new MapType();
    private MapGroup mapGroup = null;
    private int startMode = 1;
    private static final String defaultVehicle = "lauv-xplore-1";

    public PlanType(MissionType mt) {
        this.graph = new GraphType();
        this.setMissionType(mt);
        this.setVehicle("isurus");
        this.mapGroup = MapGroup.getMapGroupInstance(mt);
    }

    public boolean validatePlan() throws Exception {
        for (Maneuver man : this.getGraph().getAllManeuvers()) {
            if (!(man instanceof LocatedManeuver)) continue;
            ManeuverLocation ml = ((LocatedManeuver)((Object)man)).getManeuverLocation();
            if (ml.getZUnits() == ManeuverLocation.Z_UNITS.NONE) {
                throw new Exception(I18n.textf("The maneuver '%maneuver' has Z_UNITS set to NONE", man.getId()));
            }
            if (ml.getZUnits() != ManeuverLocation.Z_UNITS.ALTITUDE || ml.getZ() != 0.0) continue;
            throw new Exception(I18n.textf("The maneuver '%maneuver' has Z_UNITS set to ALTITUDE and value 0!", man.getId()));
        }
        for (Maneuver man : this.getGraph().getAllManeuvers()) {
            if (!this.getGraph().getIncomingTransitions(man).isEmpty() || man.getId().equals(this.getGraph().getInitialManeuverId())) continue;
            throw new Exception(I18n.textf("The maneuver '%maneuver' has no incoming transitions and is not the initial maneuver!", man.getId()));
        }
        return true;
    }

    public PlanType(String xml, MissionType mt) {
        this.load(xml);
        this.setMissionType(mt);
    }

    public boolean load(String xml) {
        try {
            Document doc;
            block10: {
                doc = DocumentHelper.parseText((String)xml);
                this.setId(((Attribute)doc.selectSingleNode("/node()/@id")).getStringValue());
                try {
                    String veh = ((Attribute)doc.selectSingleNode("/node()/@vehicle")).getStringValue();
                    if (veh.contains(",")) {
                        String[] vehs = veh.split(",");
                        this.vehicles.clear();
                        for (String v : vehs) {
                            this.addVehicle(v);
                        }
                    } else {
                        this.setVehicle(veh);
                    }
                }
                catch (Exception e) {
                    if (this.getId() == null) {
                        this.setId(NameNormalizer.getRandomID(DEFAULT_ROOT_ELEMENT));
                        NeptusLog.pub().error((Object)("plan has no valid id, using " + this.getId()), (Throwable)e);
                    }
                    if (this.getVehicle() != null) break block10;
                    this.setVehicle(defaultVehicle);
                    NeptusLog.pub().error((Object)("plan with id " + this.getId() + " has no associated vehicle, using " + this.getVehicle()), (Throwable)e);
                }
            }
            Node nd = doc.selectSingleNode("/node()/graph");
            this.graph = new GraphType(nd.asXML());
            nd = doc.selectSingleNode("/node()/actions/start-actions");
            if (nd != null) {
                this.startActions.load((Element)nd);
            }
            if ((nd = doc.selectSingleNode("/node()/actions/end-actions")) != null) {
                this.endActions.load((Element)nd);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVehicle() {
        if (this.vehicles.isEmpty()) {
            return null;
        }
        return this.getVehicles().firstElement().toString();
    }

    public void addVehicle(String vehicle) {
        VehicleType vt = VehiclesHolder.getVehicleById(vehicle);
        if (vt != null && !this.vehicles.contains(vt)) {
            this.vehicles.add(vt);
        }
    }

    public void setVehicle(String vehicle) {
        VehicleType vt;
        if (vehicle == null) {
            this.setVehicles(new Vector<VehicleType>());
        }
        if ((vt = VehiclesHolder.getVehicleById(vehicle)) != null) {
            this.setVehicleType(vt);
        }
    }

    public void setVehicle(VehicleType vehicle) {
        this.setVehicleType(vehicle);
    }

    public GraphType getGraph() {
        return this.graph;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return this.asDocument(rootElementName).getRootElement();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("id", this.getId());
        if (this.vehicles.size() <= 1) {
            root.addAttribute("vehicle", this.getVehicle());
        } else {
            String str = this.getVehicle().toString();
            for (int i = 1; i < this.vehicles.size(); ++i) {
                str = str + "," + this.vehicles.get(i).toString();
            }
            root.addAttribute("vehicle", str);
        }
        root.add(this.getGraph().asElement());
        Element sActionsElm = this.startActions.asElement("start-actions");
        Element eActionsElm = this.endActions.asElement("end-actions");
        if (sActionsElm.hasContent() || eActionsElm.hasContent()) {
            Element acElm = root.addElement("actions");
            if (sActionsElm.hasContent()) {
                acElm.add(sActionsElm);
            }
            if (eActionsElm.hasContent()) {
                acElm.add(eActionsElm);
            }
        }
        return document;
    }

    public boolean hasMultipleVehiclesAssociated() {
        return this.vehicles.size() > 1;
    }

    public Vector<VehicleType> getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(Vector<VehicleType> vehicles) {
        this.vehicles.clear();
        for (VehicleType v : vehicles) {
            if (this.vehicles.contains(v)) continue;
            this.vehicles.add(v);
        }
    }

    public VehicleType getVehicleType() {
        if (this.vehicles.isEmpty()) {
            return null;
        }
        return this.vehicles.firstElement();
    }

    private void setVehicleType(VehicleType vehicleType) {
        this.vehicles.clear();
        this.vehicles.add(vehicleType);
    }

    public boolean isEmpty() {
        return this.graph.getAllManeuvers().length == 0;
    }

    public boolean hasInitialManeuver() {
        return this.graph.getInitialManeuverId() != null;
    }

    public MissionType getMissionType() {
        return this.missionType;
    }

    public void setMissionType(MissionType missionType) {
        this.missionType = missionType;
    }

    public MapGroup getMapGroup() {
        if (this.mapGroup == null && this.missionType != null) {
            this.mapGroup = MapGroup.getMapGroupInstance(this.missionType);
        }
        return this.mapGroup;
    }

    public void setMapGroup(MapGroup mapGroup) {
        this.mapGroup = mapGroup;
    }

    public MapType getPlanMap() {
        return this.planMap;
    }

    public void setPlanMap(MapType planMap) {
        this.planMap = planMap;
    }

    public PlanType copy(String newID) {
        PlanType copy = new PlanType(this.asXML(), this.getMissionType());
        copy.setId(newID);
        return copy;
    }

    public boolean isSaveGotoSequenceAsTrajectory() {
        return this.getGraph().isSaveGotoSequenceAsTrajectory();
    }

    public void setSaveGotoSequenceAsTrajectory(boolean saveGotoSequenceAsTrajectory) {
        this.getGraph().setSaveGotoSequenceAsTrajectory(saveGotoSequenceAsTrajectory);
    }

    public boolean isSupportedBy(VehicleType vehicle) {
        return this.getVehicleType().getId().equals(vehicle.getId());
    }

    public PlanType clonePlan() {
        PlanType plan = new PlanType(this.missionType);
        plan.setId(this.getId());
        Vector<VehicleType> vehicles = new Vector<VehicleType>();
        vehicles.addAll(this.getVehicles());
        plan.setVehicles(vehicles);
        plan.graph = this.graph.clone();
        plan.startActions = new PlanActions();
        plan.startActions.load(this.startActions.asElement("start-actions"));
        plan.endActions = new PlanActions();
        plan.endActions.load(this.endActions.asElement("end-actions"));
        return plan;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toStringWithVehicles() {
        return this.toStringWithVehicles(false);
    }

    public String toStringWithVehicles(boolean extended) {
        String md5 = extended ? ByteUtil.encodeAsString(this.asIMCPlan(false).payloadMD5()) : "";
        String idStr = this.getId() + (extended ? "[md5:" + md5 + "]" : "");
        if (this.hasMultipleVehiclesAssociated()) {
            String ret = idStr + " [" + this.vehicles.firstElement();
            for (int i = 1; i < this.vehicles.size(); ++i) {
                ret = ret + ", " + this.vehicles.get(i);
            }
            return ret + "]";
        }
        if (this.getVehicle() != null) {
            return idStr + " [" + this.getVehicle() + "]";
        }
        return idStr;
    }

    public String toString() {
        return this.getId();
    }

    public void setStartMode(int startMode) {
        this.startMode = startMode;
    }

    public int getStartMode() {
        return this.startMode;
    }

    public Vector<TransitionType> getExitingTransitions(String maneuverId) {
        return this.getGraph().getExitingTransitions(this.getGraph().getManeuver(maneuverId));
    }

    public void setPayloads() {
        Maneuver[] mans;
        for (Maneuver m : mans = this.getGraph().getAllManeuvers()) {
            new ManeuverPayloadConfig(this.getVehicle(), m, null).getProperties();
        }
    }

    public IMCMessage asIMCPlan() {
        return this.asIMCPlan(false);
    }

    public IMCMessage asIMCPlan(boolean fillInPayloads) {
        if (fillInPayloads) {
            this.setPayloads();
        }
        PlanSpecification plan = new PlanSpecification();
        plan.setPlanId(this.getId());
        plan.setDescription("");
        plan.setStartManId(this.getGraph().getInitialManeuverId());
        ArrayList vars = new ArrayList();
        plan.setVariables(vars);
        IMCMessage[] msgs = this.getStartActions().getAllMessages();
        if (msgs != null) {
            plan.setStartActions(Arrays.asList(msgs));
        }
        if ((msgs = this.getEndActions().getAllMessages()) != null) {
            plan.setEndActions(Arrays.asList(msgs));
        }
        Vector<PlanManeuver> maneuvers = new Vector<PlanManeuver>();
        for (Maneuver man : this.getGraph().getAllManeuvers()) {
            PlanManeuver m;
            if (man instanceof IMCSerialization) {
                m = new PlanManeuver();
                m.setManeuverId(man.getId());
                m.setValue("data", (Object)((IMCSerialization)((Object)man)).serializeToIMC());
                msgs = man.getStartActions().getAllMessages();
                if (msgs != null) {
                    m.setStartActions(Arrays.asList(msgs));
                }
                if ((msgs = man.getEndActions().getAllMessages()) != null) {
                    m.setEndActions(Arrays.asList(msgs));
                }
            } else {
                NeptusLog.pub().error((Object)("Error converting to IMC Plan: the maneuver " + man.getId() + " is not compatible with the IMC Protocol"));
                return null;
            }
            maneuvers.add(m);
        }
        Vector<PlanTransition> transitions = new Vector<PlanTransition>();
        for (TransitionType tt : this.getGraph().getTransitions().values()) {
            PlanTransition pt = new PlanTransition();
            pt.setSourceMan(tt.getSourceManeuver());
            pt.setDestMan(tt.getTargetManeuver());
            pt.setConditions(tt.getCondition().toString());
            transitions.add(pt);
        }
        plan.setManeuvers(maneuvers);
        plan.setTransitions(transitions);
        return plan;
    }

    public String planStatistics() {
        return PlanUtil.getPlanStatisticsAsText(this, "Edited Plan Statistics", false, false);
    }

    public void getAsImage(BufferedImage img) {
        StateRenderer2D r2d = new StateRenderer2D(MapGroup.getMapGroupInstance(this.getMissionType()));
        PlanElement po = new PlanElement(r2d.getMapGroup(), new MapType());
        po.setTransp2d(1.0);
        po.setPlan(this);
        po.setRenderer(r2d);
        po.setColor(new Color(255, 255, 255, 128));
        po.setShowDistances(true);
        po.setShowManNames(true);
        int numLocs = 0;
        double[] offsets = new double[2];
        for (Maneuver m : this.getGraph().getAllManeuvers()) {
            if (!(m instanceof LocatedManeuver)) continue;
            double[] offs = ((LocatedManeuver)((Object)m)).getManeuverLocation().getOffsetFrom(this.getMissionType().getHomeRef());
            offsets[0] = offsets[0] + offs[0];
            offsets[1] = offsets[1] + offs[1];
            ++numLocs;
        }
        if (numLocs > 0) {
            offsets[0] = offsets[0] / (double)numLocs;
            offsets[1] = offsets[1] / (double)numLocs;
            LocationType loc = new LocationType(this.getMissionType().getHomeRef());
            loc.translatePosition(offsets[0], offsets[1], 0.0);
            r2d.setCenter(loc);
        }
        r2d.addPostRenderPainter(po, "Plan Painter");
        r2d.setSize(img.getWidth(), img.getHeight());
        r2d.setBounds(0, 0, img.getWidth(), img.getHeight());
        Graphics2D g = img.createGraphics();
        r2d.update(g);
        g.dispose();
    }

    @Override
    public DefaultProperty[] getProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        DefaultProperty id = PropertiesEditor.getPropertyInstance("ID", "Generic properties", String.class, this.getId(), false);
        id.setShortDescription("The identifier for this plan");
        props.add(id);
        DefaultProperty sAcions = PropertiesEditor.getPropertyInstance("start-actions", "Plan  start actions", PlanActions.class, this.startActions, true);
        props.add(sAcions);
        DefaultProperty eAcions = PropertiesEditor.getPropertyInstance("end-actions", "Plan  end actions", PlanActions.class, this.endActions, true);
        props.add(eAcions);
        return props.toArray(new DefaultProperty[0]);
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            try {
                PlanActions value;
                String pName;
                if (p.getCategory() != null && p.getCategory().equalsIgnoreCase("Plan  start actions")) {
                    pName = p.getName();
                    if (!pName.equalsIgnoreCase("start-actions")) continue;
                    this.startActions = value = (PlanActions)p.getValue();
                    continue;
                }
                if (p.getCategory() == null || !p.getCategory().equalsIgnoreCase("Plan  end actions") || !(pName = p.getName()).equalsIgnoreCase("end-actions")) continue;
                this.endActions = value = (PlanActions)p.getValue();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "'" + this.getId() + "' plan properties";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        Vector errors = new Vector();
        return errors.toArray(new String[0]);
    }

    public PlanActions getStartActions() {
        return this.startActions;
    }

    public PlanActions getEndActions() {
        return this.endActions;
    }

    public static void main(String[] args) throws Exception {
        PlanType plan1 = new PlanType(new MissionType());
        RowsManeuver rows = new RowsManeuver();
        rows.setSpeed(32.0);
        ManeuverLocation loc = new ManeuverLocation();
        loc.setLatitudeStr("41N11'6.139669166224781''");
        loc.setLongitudeStr("8W42'21.723814187086976''");
        rows.setManeuverLocation(loc);
        plan1.getGraph().addManeuver(rows);
        IMCMessage p1 = plan1.asIMCPlan();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IMCOutputStream imcOs = new IMCOutputStream((OutputStream)baos);
        p1.serialize(imcOs);
        ByteUtil.dumpAsHex(baos.toByteArray(), System.out);
        String p1Md5 = ByteUtil.encodeAsString(p1.payloadMD5());
        NeptusLog.pub().info((Object)("<###> " + p1Md5));
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] ba = baos.toByteArray();
        md.update(Arrays.copyOfRange(ba, 20, ba.length - 2));
        String p1Md5Calc = ByteUtil.encodeAsString(md.digest());
        NeptusLog.pub().info((Object)("<###> " + p1Md5Calc));
        IMCMessage p2 = IMCDefinition.getInstance().parseMessage(ba);
        p2.setTimestamp((double)System.currentTimeMillis());
        p2.setSrc(21);
        PlanType plan2 = IMCUtils.parsePlanSpecification(new MissionType(), p2);
        PlanType plan3 = plan2.clonePlan();
        NeptusLog.pub().info((Object)("<###> " + ByteUtil.encodeAsString(p2.payloadMD5())));
        NeptusLog.pub().info((Object)("<###> " + ByteUtil.encodeAsString(plan2.asIMCPlan().payloadMD5())));
        NeptusLog.pub().info((Object)("<###> " + ByteUtil.encodeAsString(plan3.asIMCPlan().payloadMD5())));
        LocationType loc2 = new LocationType();
        loc2.setLatitudeStr("41N11'6.139669166224781''");
        loc2.setLongitudeStr("8W42'21.723814187086976''");
        NeptusLog.pub().info((Object)("<###> " + loc2.getLatitudeDegs() + "  " + loc2.getLongitudeDegs()));
        NeptusLog.pub().info((Object)("<###> " + Long.toHexString(Double.doubleToLongBits(loc2.getLatitudeRads())) + "  " + Long.toHexString(Double.doubleToLongBits(loc2.getLongitudeRads()))));
        NeptusLog.pub().info((Object)("<###> " + Double.longBitsToDouble(4604649725240308121L)));
        NeptusLog.pub().info((Object)("<###> " + Double.longBitsToDouble(4604649725240308127L)));
        double la1r = Double.longBitsToDouble(4604649725240308121L);
        double la2r = Double.longBitsToDouble(4604649725240308127L);
        double la1d = Math.toDegrees(la1r);
        double la2d = Math.toDegrees(la2r);
        NeptusLog.pub().info((Object)("<###> " + la1d));
        NeptusLog.pub().info((Object)("<###> " + la2d));
        double[] absoluteLatLonDepth = loc2.getAbsoluteLatLonDepth();
        double latRad = Math.toRadians(absoluteLatLonDepth[0]);
        Math.toRadians(absoluteLatLonDepth[1]);
        NeptusLog.pub().info((Object)("<###> " + latRad));
        NeptusLog.pub().info((Object)("<###> " + Math.toDegrees(latRad)));
        NeptusLog.pub().info((Object)("<###> " + Long.toHexString(Double.doubleToLongBits(latRad))));
    }

    public Vector<LocationType> planPath() {
        Vector<LocationType> locations = new Vector<LocationType>();
        LinkedList<Maneuver> mans = this.getGraph().getGraphAsManeuversList();
        for (Maneuver man : mans) {
            if (!(man instanceof LocatedManeuver)) continue;
            ManeuverLocation destTo = ((LocatedManeuver)((Object)man)).getManeuverLocation();
            if (man instanceof PathProvider) {
                locations.addAll(((PathProvider)((Object)man)).getPathLocations());
                continue;
            }
            locations.add(destTo);
        }
        return locations;
    }

    public boolean isCompatibleWith(VehicleType vehicle) {
        if (this.getVehicle().equals(vehicle.getName())) {
            return true;
        }
        for (Maneuver m : this.getGraph().getAllManeuvers()) {
            if (vehicle.getFeasibleManeuvers().containsKey(m.getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getIdentification() {
        return this.getId();
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }
}

