/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.texture;

import java.awt.Image;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.ImageUtils;

public class TextureType {
    public static float DEFAULT_SHININNESS = 0.3f;
    private String name = "";
    private String imageFileName = "";
    private Image textureImage = null;
    private float shininess = DEFAULT_SHININNESS;
    protected Document doc;

    public TextureType(String xml) {
        this.load(xml);
        this.loadImage();
    }

    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
            this.name = this.doc.selectSingleNode("/texture/@name").getText();
            this.imageFileName = this.doc.selectSingleNode("/texture/@image-file").getText();
            Node node = this.doc.selectSingleNode("/texture/@shininess");
            this.shininess = node != null ? Float.parseFloat(node.getText()) : DEFAULT_SHININNESS;
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean loadImage() {
        this.textureImage = ImageUtils.getImage("images/textures/" + this.getImageFileName());
        return this.textureImage != null;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public String getName() {
        return this.name;
    }

    public float getShininess() {
        return this.shininess;
    }

    public Image getTextureImage() {
        return this.textureImage;
    }
}

