/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.texture;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JPanel;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.TextureComboChooser;
import pt.lsts.neptus.types.texture.TextureType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.StreamUtil;

public class TexturesHolder {
    private static final String TEXTURES_FILE_NAME = "/images/textures/textures.xml";
    private static LinkedHashMap<String, TextureType> texturesList = new LinkedHashMap();
    private static boolean isLoaded = false;
    protected static Document doc;

    public static boolean load() {
        String xml = null;
        InputStream ist = TexturesHolder.class.getResourceAsStream(TEXTURES_FILE_NAME);
        xml = StreamUtil.copyStreamToString(ist);
        isLoaded = TexturesHolder.load(xml);
        return isLoaded;
    }

    public static boolean load(String xml) {
        try {
            doc = DocumentHelper.parseText((String)xml);
            List lst = doc.selectNodes("//texture");
            for (Node nd : lst) {
                TextureType texture = new TextureType(nd.asXML());
                if (texture == null) continue;
                texturesList.put(texture.getName().toLowerCase(), texture);
            }
            isLoaded = true;
        }
        catch (DocumentException e) {
            NeptusLog.pub().error(TexturesHolder.class, (Throwable)e);
            isLoaded = false;
        }
        return isLoaded;
    }

    public static int size() {
        if (!isLoaded) {
            TexturesHolder.load();
        }
        return texturesList.size();
    }

    public static LinkedHashMap<String, TextureType> getTexturesList() {
        if (!isLoaded) {
            TexturesHolder.load();
        }
        return texturesList;
    }

    public static TextureType getTextureByName(String name) {
        if (!isLoaded) {
            TexturesHolder.load();
        }
        TextureType texture = texturesList.get(name);
        return texture;
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static TextureComboChooser getTextureListChooser() {
        TextureComboChooser tch = TextureComboChooser.createTextureComboChooser();
        return tch;
    }

    public static void main(String[] args) {
        boolean ret = TexturesHolder.load();
        System.err.println("Load: " + (ret ? "ok" : "not ok") + ".");
        System.err.println("Size: " + TexturesHolder.size() + ".");
        TextureComboChooser tch = TextureComboChooser.createTextureComboChooser();
        JPanel jp = new JPanel();
        jp.add(tch);
        GuiUtils.testFrame(jp, "test");
    }
}

