/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.vehicle;

import java.util.LinkedHashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.misc.FileType;
import pt.lsts.neptus.util.FileUtil;

public class TemplateFileVehicle
extends FileType {
    protected String parametersToPass = "";
    protected String outputFileName = "";
    protected LinkedHashMap<String, String> parametersToPassList = new LinkedHashMap();

    public TemplateFileVehicle() {
        this.setType("xslt");
    }

    public TemplateFileVehicle(String xml) {
        this.load(xml);
        this.setType("xslt");
    }

    @Override
    public boolean load(String xml) {
        if (!super.load(xml)) {
            return false;
        }
        try {
            Node nd = this.doc.selectSingleNode("/file/parameters-to-pass");
            if (nd != null) {
                this.setParametersToPass("");
                List paramNodesList = nd.selectNodes("./param");
                for (Node param : paramNodesList) {
                    String name = param.selectSingleNode("name").getText();
                    String value = param.selectSingleNode("value").getText();
                    this.parametersToPassList.put(name, value);
                    this.setParametersToPass(this.getParametersToPass() + " " + name + "=" + value);
                }
            }
            this.setOutputFileName(this.doc.selectSingleNode("/file/output-file-name").getText());
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }

    public String getParametersToPass() {
        return this.parametersToPass;
    }

    public void setParametersToPass(String parametersToPass) {
        this.parametersToPass = parametersToPass;
    }

    public LinkedHashMap<String, String> getParametersToPassList() {
        return this.parametersToPassList;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @Override
    public String asXML() {
        String rootElementName = "file";
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = super.asDocument(rootElementName);
        Element root = document.getRootElement();
        if (!this.parametersToPass.equalsIgnoreCase("")) {
            Element paramToPass = root.addElement("parameters-to-pass");
            for (String key : this.getParametersToPassList().keySet()) {
                String value = this.getParametersToPassList().get(key);
                Element paramT = paramToPass.addElement("param");
                paramT.addElement("name").addText(key);
                paramT.addElement("value").addText(value);
            }
        }
        if ("".equals(this.originalFilePath)) {
            root.addElement("output-file-name").addText(this.getOutputFileName());
        } else {
            root.addElement("output-file-name").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, this.getOutputFileName()));
        }
        return document;
    }
}

