/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.vehicle;

import java.awt.Color;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverFactory;
import pt.lsts.neptus.types.XmlInputMethods;
import pt.lsts.neptus.types.XmlInputMethodsFromFile;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.AdjustTimeShellArgs;
import pt.lsts.neptus.types.comm.protocol.FTPArgs;
import pt.lsts.neptus.types.comm.protocol.GsmArgs;
import pt.lsts.neptus.types.comm.protocol.IMCArgs;
import pt.lsts.neptus.types.comm.protocol.IridiumArgs;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.misc.FileType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.TemplateFileVehicle;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.Dom4JUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.XMLValidator;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class VehicleType
implements XmlOutputMethods,
XmlInputMethods,
XmlInputMethodsFromFile {
    protected static final String DEFAULT_ROOT_ELEMENT_DEPREC = "vehicle";
    protected static final String DEFAULT_ROOT_ELEMENT = "system";
    public static final Color DEFAULT_ICON_COLOR = Color.RED;
    private String id = "";
    private String name = "";
    private String type = "";
    private String model = "";
    private boolean operationalActive = true;
    private float xSize = 0.0f;
    private float ySize = 0.0f;
    private float zSize = 0.0f;
    private String topImageHref = "";
    private String sideImageHref = "";
    private String backImageHref = "";
    private String presentationImageHref = "";
    private String model3dHref = "";
    private Color iconColor = DEFAULT_ICON_COLOR;
    private LinkedHashMap<String, TemplateFileVehicle> transformationXSLTTemplates = new LinkedHashMap();
    private FileType maneuverAdditionalFile = null;
    private LinkedHashMap<String, FileType> miscConfigurationFiles = new LinkedHashMap();
    private String coordinateSystemLabel = null;
    private CoordinateSystem coordinateSystem = null;
    private Document doc = null;
    protected boolean isLoadOk = true;
    private String originalFilePath = "";
    private LinkedHashMap<String, String> feasibleManeuvers = new LinkedHashMap();
    private Element xmlFeasibleManeuvers = null;
    private LinkedHashMap<String, CommMean> communicationMeans = new LinkedHashMap();
    protected LinkedList<String> protocols = new LinkedList();
    protected LinkedHashMap<String, ProtocolArgs> protocolsArgs = new LinkedHashMap();
    private LinkedHashMap<String, String> consoles = new LinkedHashMap();
    private LinkedHashMap<String, String> consolesType = new LinkedHashMap();
    private ManeuverFactory manFactory = null;
    protected ImageIcon icon = null;

    public VehicleType() {
    }

    public VehicleType(String url) {
        this.loadFile(url);
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    @Override
    public boolean loadFile(String url) {
        this.originalFilePath = new File(url).getAbsolutePath();
        String fileAsString = FileUtil.getFileAsString(url);
        if (fileAsString == null) {
            JOptionPane.showMessageDialog(ConfigFetch.getSuperParentFrame(), "<html>File " + url + " was not loaded.<br>The file was not found.</html>");
            return false;
        }
        return this.load(fileAsString);
    }

    @Override
    public boolean loadFile(File file) {
        return this.loadFile(file.getAbsolutePath());
    }

    @Override
    public boolean load(Element elem) {
        this.doc = Dom4JUtil.elementToDocument(elem);
        if (this.doc == null) {
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)e.getMessage());
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    private boolean load() {
        long initTime = System.currentTimeMillis();
        try {
            String rootElemName = DEFAULT_ROOT_ELEMENT;
            if (this.doc.selectSingleNode("/system") != null) {
                rootElemName = DEFAULT_ROOT_ELEMENT;
            } else if (this.doc.selectSingleNode("/vehicle") != null) {
                rootElemName = DEFAULT_ROOT_ELEMENT_DEPREC;
            }
            try {
                this.xmlFeasibleManeuvers = (Element)this.doc.selectSingleNode("/" + rootElemName + "/feasibleManeuvers");
                this.xmlFeasibleManeuvers = (Element)this.xmlFeasibleManeuvers.createCopy().detach();
                List maneuvers = this.doc.selectNodes("/" + rootElemName + "/feasibleManeuvers/maneuver/*/annotation/implementation-class");
                for (int i = 0; i < maneuvers.size(); ++i) {
                    Node tmpMan = (Node)maneuvers.get(i);
                    String manName = tmpMan.getParent().getParent().getName();
                    this.feasibleManeuvers.put(manName, tmpMan.getText());
                }
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)e.getMessage());
                NeptusLog.pub().warn((Object)("No maneuvers found for system " + this.id + "!!"));
            }
            this.setId(this.doc.selectSingleNode("/" + rootElemName + "/properties/id").getText());
            this.setName(this.doc.selectSingleNode("/" + rootElemName + "/properties/name").getText());
            this.setType(this.doc.selectSingleNode("/" + rootElemName + "/properties/type").getText());
            Node nd = this.doc.selectSingleNode("/" + rootElemName + "/properties/model");
            if (nd != null) {
                this.setModel(nd.getText());
            } else {
                this.setModel("");
            }
            nd = this.doc.selectSingleNode("/" + rootElemName + "/properties/operational-active");
            if (nd != null) {
                try {
                    this.operationalActive = Boolean.parseBoolean(nd.getText());
                }
                catch (Exception e) {
                    NeptusLog.pub().debug((Object)e.getMessage());
                    this.operationalActive = true;
                }
            } else {
                this.operationalActive = true;
            }
            this.setXSize(new Float(this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/x-size").getText()).floatValue());
            this.setYSize(new Float(this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/y-size").getText()).floatValue());
            this.setZSize(new Float(this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/z-size").getText()).floatValue());
            this.setTopImageHref(this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/top-image-2D").getText());
            this.setSideImageHref(this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/side-image-2D").getText());
            nd = this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/presentation-image-2D");
            if (nd != null) {
                this.setPresentationImageHref(nd.getText());
            } else {
                this.setPresentationImageHref("");
            }
            nd = this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/back-image-2D");
            if (nd != null) {
                this.setBackImageHref(nd.getText());
            } else {
                this.setBackImageHref("");
            }
            this.setModel3DHref(this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/model-3D").getText());
            this.setTopImageHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, this.getTopImageHref()));
            this.setSideImageHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, this.getSideImageHref()));
            if (!this.getPresentationImageHref().equalsIgnoreCase("")) {
                this.setPresentationImageHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, this.getPresentationImageHref()));
            }
            if (!this.getBackImageHref().equalsIgnoreCase("")) {
                this.setBackImageHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, this.getBackImageHref()));
            }
            this.setModel3DHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, this.getModel3DHref()));
            nd = this.doc.selectSingleNode("/" + rootElemName + "/properties/appearance/icon-color");
            if (nd != null) {
                String rS = nd.selectSingleNode("r").getText();
                String gS = nd.selectSingleNode("g").getText();
                String bS = nd.selectSingleNode("b").getText();
                int rr = Integer.parseInt(rS);
                int gg = Integer.parseInt(gS);
                int bb = Integer.parseInt(bS);
                this.setIconColor(new Color(rr, gg, bb));
            }
            if ((nd = this.doc.selectSingleNode("/" + rootElemName + "/properties/coordinate-system-label")) != null) {
                this.setCoordinateSystemLabel(nd.getText());
            } else {
                nd = this.doc.selectSingleNode("/" + rootElemName + "/properties/coordinate-system-def");
                if (nd != null) {
                    String xml1 = nd.asXML();
                    CoordinateSystem cs = new CoordinateSystem(xml1);
                    this.setCoordinateSystem(cs);
                } else {
                    CoordinateSystem cs = new CoordinateSystem();
                    this.setCoordinateSystem(cs);
                }
            }
            nd = this.doc.selectSingleNode("/" + rootElemName + "/protocols-supported/protocols");
            this.protocols.clear();
            if (nd != null) {
                String protocolsStr = nd.getText();
                StringTokenizer strt = new StringTokenizer(protocolsStr, " ");
                while (strt.hasMoreTokens()) {
                    this.protocols.add(strt.nextToken());
                }
            }
            List lt = this.doc.selectNodes("/" + rootElemName + "/protocols-supported/protocols-args/*");
            Iterator it = lt.iterator();
            this.protocolsArgs.clear();
            while (it.hasNext()) {
                Node ndP = (Node)it.next();
                String nodeName = ndP.getName();
                if (nodeName.equalsIgnoreCase("ftp")) {
                    FTPArgs ftpA = new FTPArgs(ndP.asXML());
                    this.protocolsArgs.put("ftp", ftpA);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("imc")) {
                    IMCArgs imcA = new IMCArgs(ndP.asXML());
                    this.protocolsArgs.put("imc", imcA);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("time-shell")) {
                    AdjustTimeShellArgs adjTimeParam = new AdjustTimeShellArgs(ndP.asXML());
                    this.protocolsArgs.put("time-shell", adjTimeParam);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("gsm")) {
                    GsmArgs gsmArgs = new GsmArgs();
                    gsmArgs.load(ndP.asXML());
                    this.protocolsArgs.put("gsm", gsmArgs);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("iridium")) continue;
                IridiumArgs iridiumArgs = new IridiumArgs();
                iridiumArgs.load(ndP.asXML());
                this.protocolsArgs.put("iridium", iridiumArgs);
            }
            List lst = this.doc.selectNodes("/" + rootElemName + "/transformation-xslt-templates/file");
            ListIterator lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                Element elem = (Element)lstIt.next();
                TemplateFileVehicle tfile = new TemplateFileVehicle(elem.asXML());
                this.transformationXSLTTemplates.put(tfile.getId(), tfile);
                tfile.setOriginalFilePath(this.originalFilePath);
                tfile.setHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, tfile.getHref()));
                tfile.setOutputFileName(ConfigFetch.resolvePathWithParent(this.originalFilePath, tfile.getOutputFileName()));
            }
            nd = this.doc.selectSingleNode("/" + rootElemName + "/configuration-files/maneuver-additional/file");
            if (nd != null) {
                FileType tfile = new FileType(nd.asXML());
                this.setManeuverAdditionalFile(tfile);
                tfile.setOriginalFilePath(this.originalFilePath);
                tfile.setHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, tfile.getHref()));
            }
            lst = this.doc.selectNodes("/" + rootElemName + "/configuration-files/misc/file");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                Element elem = (Element)lstIt.next();
                FileType tfile = new FileType(elem.asXML());
                this.miscConfigurationFiles.put(tfile.getId(), tfile);
                tfile.setOriginalFilePath(this.originalFilePath);
                tfile.setHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, tfile.getHref()));
            }
            nd = this.doc.selectSingleNode("/" + rootElemName + "/communication-means");
            if (nd != null) {
                lst = nd.selectNodes("comm-mean");
                lstIt = lst.listIterator();
                while (lstIt.hasNext()) {
                    Element elem = (Element)lstIt.next();
                    CommMean cm = new CommMean(elem.asXML());
                    this.communicationMeans.put(cm.getType(), cm);
                }
            }
            List list = this.doc.selectNodes("/" + rootElemName + "/consoles/console");
            lstIt = list.listIterator();
            while (lstIt.hasNext()) {
                Element elem = (Element)lstIt.next();
                Node cls = elem.selectSingleNode("classname");
                if (cls == null) {
                    cls = elem.selectSingleNode("xml-file");
                }
                if (cls == null) continue;
                String typeName = cls.getName();
                String typeNameValue = cls.getText();
                if (typeName.equals("xml-file") && !"".equalsIgnoreCase(this.originalFilePath)) {
                    typeNameValue = ConfigFetch.resolvePathWithParent(this.originalFilePath, typeNameValue);
                }
                this.consoles.put(elem.attributeValue("name"), typeNameValue);
                this.consolesType.put(elem.attributeValue("name"), typeName);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            long totalTime = System.currentTimeMillis() - initTime;
            NeptusLog.pub().info((Object)(this + ": Total vehicle load time: " + totalTime + " ms."));
            this.isLoadOk = false;
            return false;
        }
        long totalTime = System.currentTimeMillis() - initTime;
        NeptusLog.pub().debug((Object)(this + ": Total vehicle load time: " + totalTime + " ms."));
        this.isLoadOk = true;
        return true;
    }

    public static boolean validate(Document doc) {
        try {
            String sLoc = new File(ConfigFetch.getVehicleSchemaLocation()).getAbsoluteFile().toURI().toASCIIString();
            XMLValidator xmlVal = new XMLValidator(doc, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e1) {
            NeptusLog.pub().error((Object)"Vehicle:validate", (Throwable)e1);
            return false;
        }
    }

    public static boolean validate(String xml) {
        try {
            String sLoc = new File(ConfigFetch.getVehicleSchemaLocation()).getAbsoluteFile().toURI().toASCIIString();
            XMLValidator xmlVal = new XMLValidator(xml, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e1) {
            NeptusLog.pub().error((Object)"Vehicle:validate", (Throwable)e1);
            return false;
        }
    }

    public static boolean validate(File file) {
        try {
            String xml = FileUtil.getFileAsString(file);
            return VehicleType.validate(xml);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"Vehicle:validate", (Throwable)e);
            return false;
        }
    }

    public LinkedHashMap<String, String> getFeasibleManeuvers() {
        return this.feasibleManeuvers;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean isOperationalActive() {
        return this.operationalActive;
    }

    public void setOperationalActive(boolean operationalActive) {
        this.operationalActive = operationalActive;
    }

    public float getXSize() {
        return this.xSize;
    }

    public void setXSize(float size) {
        this.xSize = size;
    }

    public float getYSize() {
        return this.ySize;
    }

    public void setYSize(float size) {
        this.ySize = size;
    }

    public float getZSize() {
        return this.zSize;
    }

    public void setZSize(float size) {
        this.zSize = size;
    }

    public LinkedHashMap<String, TemplateFileVehicle> getTransformationXSLTTemplates() {
        return this.transformationXSLTTemplates;
    }

    public FileType getManeuverAdditionalFile() {
        return this.maneuverAdditionalFile;
    }

    public void setManeuverAdditionalFile(FileType maneuverAdditionalFile) {
        this.maneuverAdditionalFile = maneuverAdditionalFile;
    }

    public LinkedHashMap<String, FileType> getMiscConfigurationFiles() {
        return this.miscConfigurationFiles;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    public String getCoordinateSystemLabel() {
        return this.coordinateSystemLabel;
    }

    public void setCoordinateSystemLabel(String coordinateSystemLabel) {
        this.coordinateSystemLabel = coordinateSystemLabel;
    }

    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.originalFilePath = originalFilePath;
    }

    public String getSideImageHref() {
        return this.sideImageHref;
    }

    public void setSideImageHref(String sideImageHref) {
        this.sideImageHref = sideImageHref;
    }

    public String getTopImageHref() {
        return this.topImageHref;
    }

    public void setTopImageHref(String topImageHref) {
        this.topImageHref = topImageHref;
    }

    public String getBackImageHref() {
        return this.backImageHref;
    }

    public void setBackImageHref(String backImageHref) {
        this.backImageHref = backImageHref;
    }

    public String getPresentationImageHref() {
        return this.presentationImageHref;
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ImageUtils.getImage(this.presentationImageHref).getScaledInstance(40, -1, 4));
        }
        return this.icon;
    }

    public void setPresentationImageHref(String presentationImageHref) {
        this.presentationImageHref = presentationImageHref;
    }

    public String getModel3DHref() {
        return this.model3dHref;
    }

    public void setModel3DHref(String model3dHref) {
        this.model3dHref = model3dHref;
    }

    public Color getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(Color iconColor) {
        this.iconColor = iconColor;
    }

    public LinkedHashMap<String, CommMean> getCommunicationMeans() {
        return this.communicationMeans;
    }

    public LinkedList<String> getProtocols() {
        return this.protocols;
    }

    public LinkedHashMap<String, ProtocolArgs> getProtocolsArgs() {
        return this.protocolsArgs;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Element configurationFiles;
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addComment(ConfigFetch.getSaveAsCommentForXML());
        Element properties = root.addElement("properties");
        properties.addElement("id").addText(this.getId());
        properties.addElement("name").addText(this.getName());
        properties.addElement("type").addText(this.getType());
        if (!"".equalsIgnoreCase(this.getModel())) {
            properties.addElement("model").addText(this.getModel());
        }
        if (!this.operationalActive) {
            properties.addElement("operational-active").addText("false");
        }
        Element appearence = properties.addElement("appearance");
        appearence.addElement("x-size").addText(Float.toString(this.getXSize()));
        appearence.addElement("y-size").addText(Float.toString(this.getYSize()));
        appearence.addElement("z-size").addText(Float.toString(this.getZSize()));
        if ("".equals(this.originalFilePath)) {
            appearence.addElement("top-image-2D").addText(this.getTopImageHref());
        } else {
            appearence.addElement("top-image-2D").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, this.getTopImageHref()));
        }
        if ("".equals(this.originalFilePath)) {
            appearence.addElement("side-image-2D").addText(this.getSideImageHref());
        } else {
            appearence.addElement("side-image-2D").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, this.getSideImageHref()));
        }
        if (!this.getBackImageHref().equalsIgnoreCase("")) {
            if ("".equals(this.originalFilePath)) {
                appearence.addElement("back-image-2D").addText(this.getBackImageHref());
            } else {
                appearence.addElement("back-image-2D").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, this.getBackImageHref()));
            }
        }
        if (!this.getPresentationImageHref().equalsIgnoreCase("")) {
            if ("".equals(this.originalFilePath)) {
                appearence.addElement("presentation-image-2D").addText(this.getPresentationImageHref());
            } else {
                appearence.addElement("presentation-image-2D").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, this.getPresentationImageHref()));
            }
        }
        if ("".equals(this.originalFilePath)) {
            appearence.addElement("model-3D").addText(this.getModel3DHref());
        } else {
            appearence.addElement("model-3D").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, this.getModel3DHref()));
        }
        if (this.getIconColor() != DEFAULT_ICON_COLOR) {
            Element colorE = appearence.addElement("icon-color");
            colorE.addElement("r").setText(Integer.toString(this.getIconColor().getRed()));
            colorE.addElement("g").setText(Integer.toString(this.getIconColor().getGreen()));
            colorE.addElement("b").setText(Integer.toString(this.getIconColor().getBlue()));
        }
        if ("".equals(this.coordinateSystemLabel)) {
            properties.add(this.coordinateSystem.asElement());
        } else {
            properties.addElement("coordinate-system-label").addText(this.coordinateSystemLabel);
        }
        try {
            Document docX = Dom4JUtil.elementToDocumentCleanFormating((Element)this.xmlFeasibleManeuvers.detach());
            root.add(docX.getRootElement().detach());
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)e.getMessage());
            NeptusLog.pub().warn((Object)("No maneuvers found for system " + this.id + "!!"));
        }
        String protocolsStr = "";
        for (String pt : this.protocols) {
            protocolsStr = protocolsStr + " " + pt;
        }
        if (!"".equalsIgnoreCase(protocolsStr)) {
            Element protoSupport = root.addElement("protocols-supported");
            protoSupport.addElement("protocols").setText(protocolsStr);
            if (this.protocolsArgs.size() > 0) {
                Element protoArgs = protoSupport.addElement("protocols-args");
                Iterator<Object> it = this.protocolsArgs.values().iterator();
                if (this.protocolsArgs.size() > 0) {
                    while (it.hasNext()) {
                        Element elem = ((ProtocolArgs)it.next()).asElement();
                        protoArgs.add(elem);
                    }
                }
            }
        }
        if (this.communicationMeans.size() > 0) {
            configurationFiles = root.addElement("communication-means");
            for (CommMean cm : this.communicationMeans.values()) {
                Element cmean = cm.asElement();
                configurationFiles.add(cmean);
            }
        }
        if (this.transformationXSLTTemplates.size() != 0) {
            Element transformationXsltTemplates = root.addElement("transformation-xslt-templates");
            for (TemplateFileVehicle tmplt : this.transformationXSLTTemplates.values()) {
                transformationXsltTemplates.add(tmplt.asElement());
            }
        }
        if (this.maneuverAdditionalFile != null | this.miscConfigurationFiles.size() != 0) {
            configurationFiles = root.addElement("configuration-files");
            if (this.maneuverAdditionalFile != null) {
                configurationFiles.add(this.maneuverAdditionalFile.asElement());
            }
            if (this.miscConfigurationFiles.size() != 0) {
                Element miscConf = configurationFiles.addElement("misc");
                for (FileType ft : this.miscConfigurationFiles.values()) {
                    miscConf.add(ft.asElement());
                }
            }
        }
        if (!this.consoles.isEmpty()) {
            Element consolesFiles = root.addElement("consoles");
            for (String conName : this.consoles.keySet()) {
                String file = this.consoles.get(conName);
                String type = this.consolesType.get(conName);
                if (file == null || type == null) continue;
                if (type.equals("xml-file") && !"".equals(this.originalFilePath)) {
                    file = FileUtil.relativizeFilePathAsURI(this.originalFilePath, file);
                }
                Element consElem = consolesFiles.addElement("console");
                consElem.addAttribute("name", conName);
                consElem.addElement(type).addText(file);
            }
        }
        return document;
    }

    public static VehicleType valueOf(String value) {
        return VehiclesHolder.getVehicleById(value);
    }

    public String toString() {
        return this.getId();
    }

    public LinkedHashMap<String, String> getConsoles() {
        return this.consoles;
    }

    public LinkedHashMap<String, String> getConsolesTypes() {
        return this.consolesType;
    }

    public ImcId16 getImcId() {
        for (CommMean cm : this.getCommunicationMeans().values()) {
            ProtocolArgs args = cm.getProtocolsArgs().get("imc");
            if (args == null) continue;
            IMCArgs imcArgs = (IMCArgs)args;
            return imcArgs.getImc3Id() == null ? ImcId16.NULL_ID : imcArgs.getImc3Id();
        }
        return ImcId16.NULL_ID;
    }

    public PlanType[] getFeasiblePlans(MissionType mission) {
        Vector<PlanType> plans = new Vector<PlanType>();
        if (mission == null || mission == null) {
            return new PlanType[0];
        }
        for (PlanType p : mission.getIndividualPlansList().values()) {
            if (!p.isSupportedBy(this)) continue;
            plans.add(p);
        }
        return plans.toArray(new PlanType[0]);
    }

    public ManeuverFactory getManeuverFactory() {
        if (this.manFactory == null) {
            this.manFactory = new ManeuverFactory(this);
            List maneuvers = this.xmlFeasibleManeuvers.selectNodes("maneuver/*[name()!='minTime' and name()!='maxTime' and name()!='custom-settings']");
            for (Object o : maneuvers) {
                Element el = (Element)o;
                Maneuver man = this.manFactory.getManeuver(el.getName());
                if (man == null) continue;
                NeptusLog.pub().debug((Object)("loading maneuver '" + el.getName() + "' default values for vehicle '" + this.getId() + "'"));
                man.loadFromXML(el.asXML());
                man.loadFromXMLExtraParameters(el.getParent());
                this.manFactory.putManeuver(man);
            }
        }
        return this.manFactory;
    }

    public static enum VehicleTypeEnum {
        UNKNOWN,
        UUV,
        USV,
        UGV,
        UAV,
        ALL;

    }

    public static enum SystemTypeEnum {
        UNKNOWN,
        VEHICLE,
        CCU,
        STATICSENSOR,
        MOBILESENSOR,
        ALL;

    }
}

