/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.vehicle;

import foxtrot.AsyncTask;
import foxtrot.AsyncWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.CoordinateSystemsHolder;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class VehiclesHolder {
    private static LinkedHashMap<String, VehicleType> vehiclesList = new LinkedHashMap();
    private static boolean vehiclesLoaded = false;
    private static LinkedHashMap<String, Hashtable<String, ConsoleLayout>> openConsolesByVehicle = new LinkedHashMap();
    public static String CONSOLE_CLASS = "classname";
    public static String CONSOLE_XML = "xml-file";

    public VehiclesHolder() {
        VehiclesHolder.loadVehicles();
    }

    public static boolean addVehicle(VehicleType vehicle) {
        return vehiclesList.put(vehicle.getId(), vehicle) != null;
    }

    public static int size() {
        if (!vehiclesLoaded) {
            vehiclesLoaded = true;
            VehiclesHolder.loadVehicles();
        }
        return vehiclesList.size();
    }

    public static LinkedHashMap<String, VehicleType> getVehiclesList() {
        if (!vehiclesLoaded) {
            VehiclesHolder.loadVehicles();
        }
        return vehiclesList;
    }

    public static String[] getVehiclesArray() {
        if (!vehiclesLoaded) {
            VehiclesHolder.loadVehicles();
        }
        String[] list = new String[vehiclesList.values().size()];
        int i = 0;
        for (VehicleType v : vehiclesList.values()) {
            list[i] = v.getId();
            ++i;
        }
        return list;
    }

    public static VehicleType getVehicleById(String id) {
        VehicleType obj = VehiclesHolder.getVehiclesList().get(id);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public static List<VehicleType> getVehicleWithProtocol(String protocol) {
        LinkedList<VehicleType> list = new LinkedList<VehicleType>();
        LinkedHashMap<String, VehicleType> vehList = VehiclesHolder.getVehiclesList();
        for (VehicleType veh : vehList.values()) {
            LinkedHashMap<String, CommMean> comms = veh.getCommunicationMeans();
            block1: for (CommMean commMean : comms.values()) {
                for (String prot : commMean.getProtocols()) {
                    if (prot.indexOf(protocol) == -1) continue;
                    list.add(veh);
                    continue block1;
                }
            }
        }
        return list;
    }

    public static List<VehicleType> getVehicleWithImc() {
        LinkedList<VehicleType> list = new LinkedList<VehicleType>();
        List<VehicleType> vehList = VehiclesHolder.getVehicleWithProtocol("imc");
        for (VehicleType veh : vehList) {
            ImcId16 imcId = veh.getImcId();
            if (imcId == ImcId16.NULL_ID) continue;
            list.add(veh);
        }
        return list;
    }

    public static VehicleType getVehicleWithImc(ImcId16 imcId) {
        List<VehicleType> vehList = VehiclesHolder.getVehicleWithImc();
        for (VehicleType veh : vehList) {
            ImcId16 imcIdTmp = veh.getImcId();
            if (imcIdTmp == null) {
                return null;
            }
            if (!imcIdTmp.equals(imcId)) continue;
            return veh;
        }
        return null;
    }

    public static boolean loadVehicles() {
        if (vehiclesLoaded) {
            return true;
        }
        CoordinateSystemsHolder csh = new CoordinateSystemsHolder(ConfigFetch.getCoordinateSystemsConfigLocation());
        NeptusLog.pub().debug((Object)("CoordinateSystems #: " + csh.size()));
        LinkedList<String> vehicleList = ConfigFetch.getVehiclesList();
        for (String hr : vehicleList) {
            CoordinateSystem cs;
            VehicleType v = new VehicleType(ConfigFetch.resolvePath(hr));
            if (!v.isLoadOk()) continue;
            if (v.getCoordinateSystem() == null && (cs = csh.getCoordinateSystemList().get(v.getCoordinateSystemLabel())) != null) {
                v.setCoordinateSystem(cs);
            }
            VehiclesHolder.addVehicle(v);
        }
        vehiclesLoaded = true;
        NeptusLog.pub().debug((Object)("Vehicles #: " + VehiclesHolder.size()));
        return vehiclesLoaded;
    }

    public static boolean addOpenConsole(String vehicleId, String consoleID, ConsoleLayout console) {
        Hashtable<String, ConsoleLayout> consolesTable = openConsolesByVehicle.get(vehicleId);
        if (consolesTable != null) {
            for (String name : consolesTable.keySet()) {
                if (!name.equals(consoleID)) continue;
                return false;
            }
        } else {
            consolesTable = new Hashtable();
            openConsolesByVehicle.put(vehicleId, consolesTable);
        }
        consolesTable.put(consoleID, console);
        return true;
    }

    public static boolean removeOpenConsole(String vehicleId, String consoleId) {
        Hashtable<String, ConsoleLayout> consolesTable = openConsolesByVehicle.get(vehicleId);
        if (consolesTable == null) {
            return false;
        }
        return consolesTable.remove(consoleId) != null;
    }

    public static boolean existsOpenConsole(String vehicleId, String consoleId) {
        Hashtable<String, ConsoleLayout> consolesTable = openConsolesByVehicle.get(vehicleId);
        if (consolesTable == null) {
            return false;
        }
        for (String name : consolesTable.keySet()) {
            if (!name.equals(consoleId)) continue;
            return true;
        }
        return false;
    }

    public static ConsoleLayout getOpenConsole(String vehicleId, String consoleId) {
        Hashtable<String, ConsoleLayout> consolesTable = openConsolesByVehicle.get(vehicleId);
        if (consolesTable == null) {
            return null;
        }
        return consolesTable.get(consoleId);
    }

    public static void showConsole(VehicleType vehicle, Component callerComponent) {
        final VehicleType vt = vehicle;
        final Component caller = callerComponent;
        AsyncWorker.post((AsyncTask)new AsyncTask(){

            public Object run() throws Exception {
                caller.setCursor(new Cursor(3));
                VehiclesHolder.showConsole(vt, null, null, caller);
                return null;
            }

            public void finish() {
                try {
                    this.getResultOrThrow();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                caller.setCursor(new Cursor(0));
            }
        });
    }

    public static void showConsole(PlanType plan, MissionType mission, Component callerComponent) {
        final PlanType finalPlan = plan;
        final MissionType finalMission = mission;
        final Component finalCaller = callerComponent;
        AsyncWorker.post((AsyncTask)new AsyncTask(){

            public Object run() throws Exception {
                finalCaller.setCursor(new Cursor(3));
                VehiclesHolder.showConsole(finalPlan.getVehicleType(), finalPlan, finalMission, finalCaller);
                return null;
            }

            public void finish() {
                finalCaller.setCursor(new Cursor(0));
            }
        });
    }

    public static void showConsole(final VehicleType vehicle, MissionType mission, Component callerComponent) {
        final MissionType finalMission = mission;
        final Component finalCaller = callerComponent;
        AsyncWorker.post((AsyncTask)new AsyncTask(){

            public Object run() throws Exception {
                finalCaller.setCursor(new Cursor(3));
                VehiclesHolder.showConsole(vehicle, null, finalMission, finalCaller);
                return null;
            }

            public void finish() {
                finalCaller.setCursor(new Cursor(0));
            }
        });
    }

    private static void showConsole(final VehicleType vehicle, PlanType plan, MissionType mission, Component callerComponent) {
        Object console;
        Object consoleID = null;
        String className = null;
        String classType = null;
        if (vehicle.getConsoles().size() > 1) {
            String[] consoles = vehicle.getConsoles().keySet().toArray(new String[0]);
            LinkedList<String> filteredCons = new LinkedList<String>();
            for (String cons : consoles) {
                filteredCons.add(cons);
            }
            if (filteredCons.size() == 0) {
                GuiUtils.errorMessage(callerComponent, "Warning", "All operational consoles are already open for this vehicle.");
                return;
            }
            if (filteredCons.size() > 1) {
                console = (String)JOptionPane.showInputDialog(callerComponent, "Choose one of the available consoles", "Select console", 3, new ImageIcon(), filteredCons.toArray(new String[0]), filteredCons.iterator().next());
                if (console != null) {
                    consoleID = console;
                    className = vehicle.getConsoles().get(console);
                    classType = vehicle.getConsolesTypes().get(console);
                }
            } else {
                consoleID = console = (String)filteredCons.iterator().next();
                className = vehicle.getConsoles().get(console);
                classType = vehicle.getConsolesTypes().get(console);
            }
        } else {
            try {
                String vehCon = vehicle.getConsoles().keySet().iterator().next();
                consoleID = vehCon;
                className = vehicle.getConsoles().get(vehCon);
                classType = vehicle.getConsolesTypes().get(vehCon);
            }
            catch (Exception e) {
                className = null;
                NeptusLog.pub().debug((Object)e.getMessage());
                GuiUtils.errorMessage(callerComponent, "Warning", "No operational console(s) configured for this vehicle.\n");
            }
        }
        if (className != null) {
            if (VehiclesHolder.existsOpenConsole(vehicle.getId(), (String)consoleID)) {
                GuiUtils.errorMessage(callerComponent, "Warning", "This operational console is already open for this vehicle.\n[" + className + "]");
                ConsoleLayout openConsole = VehiclesHolder.getOpenConsole(vehicle.getId(), (String)consoleID);
                openConsole.setVisible(true);
                openConsole.requestFocus();
                return;
            }
            if (classType.equals(CONSOLE_CLASS)) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> cons = null;
                    console = null;
                    if (mission != null && plan != null) {
                        cons = clazz.getConstructor(MissionType.class, PlanType.class);
                        if (cons != null) {
                            console = (ConsoleLayout)cons.newInstance(mission, plan);
                        }
                    } else {
                        cons = clazz.getConstructor(new Class[0]);
                        if (cons != null) {
                            console = (ConsoleLayout)cons.newInstance(new Object[0]);
                        }
                    }
                    if (cons != null) {
                        final String consoleId = consoleID;
                        ((Window)console).addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                super.windowClosing(e);
                                VehiclesHolder.removeOpenConsole(vehicle.getId(), consoleId);
                            }
                        });
                        VehiclesHolder.addOpenConsole(vehicle.getId(), (String)consoleID, (ConsoleLayout)console);
                    }
                }
                catch (Exception e) {
                    GuiUtils.errorMessage(callerComponent, e);
                    NeptusLog.pub().error((Object)callerComponent, (Throwable)e);
                }
            } else if (classType.equals(CONSOLE_XML)) {
                if (!new File(className).exists()) {
                    GuiUtils.errorMessage(callerComponent, I18n.text("Opening Console"), I18n.textf("Console '%consoleFile' does not exist!", className));
                    NeptusLog.pub().error((Object)(callerComponent + ": Console '" + className + "' does not exist for vehicle '" + vehicle + "'!"));
                }
                ConsoleLayout console2 = ConsoleParse.consoleLayoutLoader(ConfigFetch.resolvePath(className));
                final String consoleId = consoleID;
                console2.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        super.windowClosing(e);
                        VehiclesHolder.removeOpenConsole(vehicle.getId(), consoleId);
                    }
                });
                if (mission != null) {
                    console2.setMission(mission);
                }
                if (plan != null) {
                    console2.setMainSystem(plan.getVehicle());
                    console2.setPlan(plan);
                } else {
                    console2.setMainSystem(vehicle.getId());
                }
                VehiclesHolder.addOpenConsole(vehicle.getId(), (String)consoleID, console2);
            }
        }
    }

    public boolean isOnlyOneVehicleAvailable() {
        if (!vehiclesLoaded) {
            VehiclesHolder.loadVehicles();
        }
        return vehiclesList.size() == 1;
    }
}

