/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.awt.geom.Point2D;
import java.util.Vector;
import javax.vecmath.Vector2d;
import pt.lsts.neptus.NeptusLog;

public class AngleCalc {
    public static final double TWO_PI_RADS = Math.PI * 2;

    public static Vector<Point2D> linearizePoint2d(Vector<Point2D> points, double angleTolerance) {
        Point2D[] aux = points.toArray(new Point2D[0]);
        Vector<Point2D> aux2 = new Vector<Point2D>();
        Boolean reduce = true;
        while (reduce.booleanValue()) {
            int i;
            aux2 = null;
            aux2 = new Vector();
            reduce = false;
            int nPointsProcess = aux.length;
            if ((double)nPointsProcess % 3.0 != 0.0 && (double)(--nPointsProcess) % 3.0 != 0.0) {
                --nPointsProcess;
            }
            for (i = 0; i < nPointsProcess; i += 3) {
                Vector2d a = new Vector2d();
                Vector2d b = new Vector2d();
                a.x = aux[i + 1].getX() - aux[i].getX();
                a.y = aux[i + 1].getY() - aux[i].getY();
                b.x = aux[i + 2].getX() - aux[i + 1].getX();
                b.y = aux[i + 2].getY() - aux[i + 1].getY();
                if (a.angle(b) > angleTolerance) {
                    aux2.add(aux[i]);
                    aux2.add(aux[i + 1]);
                    aux2.add(aux[i + 2]);
                    continue;
                }
                aux2.add(aux[i]);
                aux2.add(aux[i + 2]);
                reduce = true;
            }
            while (i < aux.length) {
                aux2.add(aux[i]);
                ++i;
            }
            aux = aux2.toArray(new Point2D[0]);
        }
        if (aux2.size() > 3) {
            aux = aux2.toArray(new Point2D[0]);
            aux2 = null;
            aux2 = new Vector();
            aux2.add(aux[0]);
            for (int i = 1; i < aux.length - 1; ++i) {
                Vector2d a = new Vector2d();
                Vector2d b = new Vector2d();
                a.x = aux[i].getX() - aux[i - 1].getX();
                a.y = aux[i].getY() - aux[i - 1].getY();
                b.x = aux[i + 1].getX() - aux[i].getX();
                b.y = aux[i + 1].getY() - aux[i].getY();
                if (!(a.angle(b) > angleTolerance)) continue;
                aux2.add(aux[i]);
            }
            aux2.add(aux[aux.length - 1]);
        }
        return aux2;
    }

    public static double calcAngle(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = 0.0;
        angle = dx == 0.0 ? (dy == 0.0 ? 0.0 : (dy > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : (dy == 0.0 ? (dx > 0.0 ? 0.0 : Math.PI) : (dx < 0.0 ? Math.atan(dy / dx) + Math.PI : (dy < 0.0 ? Math.atan(dy / dx) + Math.PI * 2 : Math.atan(dy / dx))));
        return -1.0 * (angle - 1.5707963267948966);
    }

    public static double nomalizeAngleRads2Pi(double angle) {
        double ret = angle;
        if ((ret %= Math.PI * 2) < 0.0) {
            ret += Math.PI * 2;
        }
        return ret;
    }

    public static double nomalizeAngleRadsPi(double angle) {
        double ret;
        for (ret = angle; ret > Math.PI; ret -= Math.PI * 2) {
        }
        while (ret < -Math.PI) {
            ret += Math.PI * 2;
        }
        return ret;
    }

    public static double nomalizeAngleDegrees360(double angle) {
        double ret = angle;
        if ((ret %= 360.0) < 0.0) {
            ret += 360.0;
        }
        return ret;
    }

    public static double nomalizeAngleDegrees180(double angle) {
        double ret;
        for (ret = angle; ret > 180.0; ret -= 360.0) {
        }
        while (ret < -180.0) {
            ret += 360.0;
        }
        return ret;
    }

    public static double[] rotate(double angleRadians, double x, double y, boolean clockwiseRotation) {
        double sina = Math.sin(angleRadians);
        double cosa = Math.cos(angleRadians);
        double[] xy = new double[]{0.0, 0.0};
        if (clockwiseRotation) {
            xy[0] = x * cosa + y * sina;
            xy[1] = -x * sina + y * cosa;
        } else {
            xy[0] = x * cosa - y * sina;
            xy[1] = x * sina + y * cosa;
        }
        return xy;
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + Math.toDegrees(AngleCalc.nomalizeAngleRads2Pi(Math.toRadians(480.0)))));
        NeptusLog.pub().info((Object)("<###> " + Math.toDegrees(AngleCalc.nomalizeAngleRads2Pi(Math.toRadians(-120.0)))));
        NeptusLog.pub().info((Object)("<###> " + Math.toDegrees(AngleCalc.nomalizeAngleRads2Pi(13.194689145077131))));
        NeptusLog.pub().info((Object)("<###> " + Math.toDegrees(AngleCalc.nomalizeAngleRads2Pi(Math.PI * 3))));
        NeptusLog.pub().info((Object)("<###> " + Math.toDegrees(AngleCalc.calcAngle(0.0, 0.0, 1.0, 0.0))));
        NeptusLog.pub().info((Object)("<###> " + Math.toDegrees(AngleCalc.calcAngle(0.0, 0.0, 1.0, 0.2))));
        double[] xy = AngleCalc.rotate(0.7853981633974483, 1.0, 0.2, true);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(0.7853981633974483, 1.0, 0.2, false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), 8233.212457347916, 3936.711000673984, false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), xy[0], xy[1], false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), xy[0], xy[1], false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), xy[0], xy[1], false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), xy[0], xy[1], false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), xy[0], xy[1], false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), xy[0], xy[1], false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
        xy = AngleCalc.rotate(Math.toRadians(-2.0), xy[0], xy[1], false);
        NeptusLog.pub().info((Object)("<###>[" + xy[0] + ", " + xy[1] + "]"));
    }
}

