/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import pt.lsts.neptus.NeptusLog;

public class BarCodesUtil {
    private static BitMatrix createBarCodeBitMatrix(String contents, BarcodeFormat format, int width, int height, Hashtable<DecodeHintType, String> hints) throws WriterException, Exception {
        MultiFormatWriter writer = new MultiFormatWriter();
        BitMatrix matrix = writer.encode(contents, format, width, height, hints);
        return matrix;
    }

    public static BufferedImage createBarCodeImage(String contents, BarcodeFormat format, int width, int height, Hashtable<DecodeHintType, String> hints) throws WriterException, Exception {
        BitMatrix matrix = BarCodesUtil.createBarCodeBitMatrix(contents, format, width, height, hints);
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        return image;
    }

    public static BufferedImage createBarCodeImage(String contents, BarcodeFormat format, int width, int height) throws WriterException, Exception {
        return BarCodesUtil.createBarCodeImage(contents, format, width, height, null);
    }

    public static BufferedImage createQRCodeImage(String contents, int width, int height) throws WriterException, Exception {
        return BarCodesUtil.createBarCodeImage(contents, BarcodeFormat.QR_CODE, width, height, null);
    }

    public static boolean createBarCodeImageToFile(String contents, BarcodeFormat format, int width, int height, Hashtable<DecodeHintType, String> hints, String imageFormat, File file) throws WriterException, Exception {
        BitMatrix matrix = BarCodesUtil.createBarCodeBitMatrix(contents, format, width, height, hints);
        MatrixToImageWriter.writeToFile((BitMatrix)matrix, (String)imageFormat, (File)file);
        return true;
    }

    public static boolean createBarCodeImageToFile(String contents, BarcodeFormat format, int width, int height, String imageFormat, File file) throws WriterException, Exception {
        return BarCodesUtil.createBarCodeImageToFile(contents, format, width, height, null, imageFormat, file);
    }

    public static boolean createQRCodeImageToFile(String contents, int width, int height, String imageFormat, File file) throws WriterException, Exception {
        return BarCodesUtil.createBarCodeImageToFile(contents, BarcodeFormat.QR_CODE, width, height, null, imageFormat, file);
    }

    public static boolean createBarCodeImageToStream(String contents, BarcodeFormat format, int width, int height, Hashtable<DecodeHintType, String> hints, String imageFormat, OutputStream stream) throws WriterException, Exception {
        BitMatrix matrix = BarCodesUtil.createBarCodeBitMatrix(contents, format, width, height, hints);
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)imageFormat, (OutputStream)stream);
        return true;
    }

    public static boolean createBarCodeImageToStream(String contents, BarcodeFormat format, int width, int height, String imageFormat, OutputStream stream) throws WriterException, Exception {
        return BarCodesUtil.createBarCodeImageToStream(contents, format, width, height, null, imageFormat, stream);
    }

    public static boolean createQRCodeImageToStream(String contents, int width, int height, String imageFormat, OutputStream stream) throws WriterException, Exception {
        return BarCodesUtil.createBarCodeImageToStream(contents, BarcodeFormat.QR_CODE, width, height, null, imageFormat, stream);
    }

    public static Result decodeBarCode(BufferedImage image, Hashtable<DecodeHintType, String> hints) throws NotFoundException {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        MultiFormatReader reader = new MultiFormatReader();
        Result result = reader.decode(bitmap, hints);
        return result;
    }

    public static Result decodeBarCode(BufferedImage image) throws NotFoundException {
        return BarCodesUtil.decodeBarCode(image, null);
    }

    public static void main(String[] args) throws Exception {
        BarcodeFormat[] formats = new BarcodeFormat[]{BarcodeFormat.QR_CODE, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.CODE_39, BarcodeFormat.CODE_128, BarcodeFormat.ITF};
        String data = "http://whale.fe.up.pt/neptus/";
        for (BarcodeFormat format : formats) {
            String dx = data;
            if (format == BarcodeFormat.EAN_8) {
                dx = "12345678";
            } else if (format == BarcodeFormat.EAN_13) {
                dx = "1234567890123";
            } else if (format == BarcodeFormat.CODE_39) {
                dx = "123456789012345678901234567890123456789";
            }
            try {
                System.out.print(format + ": ");
                File fx = new File("test-" + format + ".png");
                BarCodesUtil.createBarCodeImageToFile(dx, format, 200, 200, "png", fx);
                Result result = BarCodesUtil.decodeBarCode(ImageIO.read(fx));
                NeptusLog.pub().info((Object)("<###> " + result.getText()));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

