/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.FileUtil;

public class ByteUtil {
    private ByteUtil() {
    }

    public static boolean equal(byte[] buffer1, byte[] buffer2) {
        if (buffer1.length != buffer2.length) {
            return false;
        }
        for (int i = 0; i < buffer1.length; ++i) {
            if (buffer1[i] == buffer2[i]) continue;
            return false;
        }
        return true;
    }

    public static void dumpAsHex(byte[] buffer, PrintStream pStream) {
        ByteUtil.dumpAsHex(null, buffer, pStream);
    }

    public static void dumpAsHex(String title, byte[] buffer, PrintStream pStream) {
        String txt = "";
        if (!"".equalsIgnoreCase(title) && title != null) {
            txt = title + "  ";
        }
        txt = buffer == null ? txt + "NULL" : txt + "[size: " + buffer.length + " bytes]";
        pStream.println("----------------------------------------------------------  ----------------");
        pStream.println(txt);
        pStream.println("----------------------------------------------------------  ----------------");
        if (buffer == null) {
            return;
        }
        char[] chars = Hex.encodeHex((byte[])buffer);
        int charCount = 0;
        StringBuffer lineChars = new StringBuffer(16);
        int byteCount = 0;
        int halfByteCount = 0;
        int lineCount = 0;
        String regex = "[\\s\\e\\a\\x1f\u0000]";
        String replacement = " ";
        for (char ch : chars) {
            if (byteCount == 0 && halfByteCount == 0) {
                pStream.printf("%8X: ", lineCount * 16);
            }
            pStream.print(ch);
            if (halfByteCount == 1) {
                pStream.print(' ');
                lineChars.append(new String(new byte[]{buffer[charCount]}).charAt(0));
                ++charCount;
            }
            if (halfByteCount == 1) {
                ++byteCount;
                byteCount %= 16;
            }
            if (byteCount == 8 && halfByteCount == 1) {
                pStream.print(' ');
            }
            if (byteCount == 0 && halfByteCount == 1) {
                if (charCount % 16 != 0) {
                    for (int i = 0; i < 16 - charCount % 16; ++i) {
                        pStream.print("   ");
                    }
                    if (charCount % 16 < 8) {
                        pStream.print(' ');
                    }
                }
                pStream.print(" " + lineChars.toString().replaceAll(regex, replacement));
                lineChars = new StringBuffer(16);
                pStream.print('\n');
                ++lineCount;
            }
            ++halfByteCount;
            halfByteCount %= 2;
        }
        if (byteCount != 0) {
            if (charCount % 16 != 0) {
                for (int i = 0; i < 16 - charCount % 16; ++i) {
                    pStream.print("   ");
                }
                if (charCount % 16 < 8) {
                    pStream.print(' ');
                }
            }
            pStream.print(" " + lineChars.toString().replaceAll(regex, replacement));
            lineChars = new StringBuffer(16);
            pStream.print('\n');
        }
        pStream.println("----------------------------------------------------------  ----------------");
    }

    public static String encodeToHex(byte[] buffer) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(String.format("%02x", buffer[i]));
        }
        return sb.toString();
    }

    public static String dumpAsHexToString(byte[] buffer) {
        return ByteUtil.dumpAsHexToString(null, buffer);
    }

    public static String dumpAsHexToString(String title, byte[] buffer) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream pst = new PrintStream(baos);
            ByteUtil.dumpAsHex(title, buffer, pst);
            String addStr = baos.toString();
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return addStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String encodeAsString(byte[] source) {
        return new String(Hex.encodeHex((byte[])source));
    }

    public static byte[] decodeHexString(String hexString) throws DecoderException {
        return Hex.decodeHex((char[])hexString.toCharArray());
    }

    public static byte[] decodeHexString(char[] sourceChars) throws DecoderException {
        return Hex.decodeHex((char[])sourceChars);
    }

    public static byte[] encodeAsBase64(byte[] source, boolean chunked) {
        if (chunked) {
            return Base64.encodeBase64Chunked((byte[])source);
        }
        return Base64.encodeBase64((byte[])source);
    }

    public static byte[] encodeAsBase64(byte[] source) {
        return ByteUtil.encodeAsBase64(source, true);
    }

    public static byte[] decodeBase64(byte[] source) {
        return Base64.decodeBase64((byte[])source);
    }

    public static void main(String[] args) {
        ByteUtil.dumpAsHex("Teste", "Isto \u00e9 de facto \u0000 um teste para ver se imprime bem Hex!".getBytes(), System.out);
        ByteUtil.dumpAsHex(FileUtil.getFileAsString("legal/Neptus-LICENSE.txt").getBytes(), System.out);
        ByteUtil.dumpAsHex(FileUtil.getFileAsString("src/images/auto-pilot.png").getBytes(), System.out);
        String tt = "\u0000\u0001Isto \u00e9 de facto um teste para ver se imprime bem Hex!";
        tt = FileUtil.getFileAsString("legal/Neptus-LICENSE.txt");
        NeptusLog.pub().info((Object)("<###> " + new String(Base64.encodeBase64Chunked((byte[])tt.getBytes()))));
        NeptusLog.pub().info((Object)("<###> " + new String(Base64.decodeBase64((byte[])Base64.encodeBase64Chunked((byte[])tt.getBytes())))));
        System.err.println(ByteUtil.dumpAsHexToString(FileUtil.getFileAsString("legal/Neptus-LICENSE.txt").getBytes()));
    }
}

