/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.IConsoleInteraction;
import pt.lsts.neptus.console.IConsoleLayer;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.loader.FileHandler;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.XMLValidator;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ConsoleParse
implements FileHandler {
    public static ConsoleLayout consoleLayoutLoader(String consoleURL) {
        ConsoleLayout console = new ConsoleLayout();
        ConsoleParse.parseFile(consoleURL, console);
        console.setConsoleChanged(false);
        Rectangle screen = MouseInfo.getPointerInfo().getDevice().getDefaultConfiguration().getBounds();
        console.setLocation(screen.x, screen.y);
        console.imcOn();
        console.setVisible(true);
        return console;
    }

    @Override
    public String getName() {
        return "Console";
    }

    public static Document initparse(String consoleURL) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(consoleURL);
        return doc;
    }

    public static void parseString(String str, ConsoleLayout console, String consoleURL) {
        try {
            boolean valid = ConsoleParse.validate(str);
            if (!valid) {
                NeptusLog.pub().error((Object)" Console Base parse XML not valid!!");
            }
            Document document = DocumentHelper.parseText((String)str);
            ConsoleParse.parseDocument(document, console, consoleURL);
        }
        catch (DocumentException e) {
            GuiUtils.errorMessage(null, (Exception)((Object)e));
            NeptusLog.pub().error((Object)" Console Base parse XML string", (Throwable)e);
            return;
        }
    }

    public static void parseElement(Element rootconsole, ConsoleLayout console, String consoleUrl) {
        List list = rootconsole.selectNodes("@*");
        for (Attribute attribute : list) {
            if ("name".equals(attribute.getName())) {
                console.setName(attribute.getValue());
            }
            if ("mission-file".equals(attribute.getName())) {
                String missionFile = null;
                missionFile = consoleUrl != null || !"".equalsIgnoreCase(consoleUrl) ? ConfigFetch.resolvePathWithParent(consoleUrl, attribute.getText()) : attribute.getText();
                if (!new File(missionFile).canRead()) {
                    GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), "Console loading", "Error setting main mission: File not found");
                } else {
                    console.setMission(new MissionType(missionFile));
                }
            }
            if ("main-vehicle".equals(attribute.getName())) {
                console.addSystem(attribute.getValue());
                console.setMainSystem(attribute.getValue());
            }
            if ("width".equals(attribute.getName())) {
                console.setSize(Integer.parseInt(attribute.getValue()), console.getHeight());
                console.repaint();
            }
            if ("height".equals(attribute.getName())) {
                console.setSize(console.getWidth(), Integer.parseInt(attribute.getValue()));
                console.repaint();
            }
            if (!"resizable".equals(attribute.getName())) continue;
            boolean resizable = attribute.getValue().equals("true");
            if (resizable) {
                console.setResizableConsole(true);
                console.setResizable(true);
                console.repaint();
                continue;
            }
            console.setResizableConsole(false);
            console.setResizable(false);
        }
        list = rootconsole.selectNodes("/console/*");
        AbstractList layers = new ArrayList();
        AbstractList interactions = new ArrayList();
        for (Element element : list) {
            if ("mainpanel".equals(element.getName())) {
                Attribute attribute = (Attribute)element.selectSingleNode("@name");
                if (!"console main panel".equals(attribute.getValue())) continue;
                ConfigFetch.mark("main panel");
                ConsoleParse.parseConsoleMainPanel((Node)element, console);
                ConfigFetch.benchmark("main panel");
                continue;
            }
            if ("layers".equals(element.getName())) {
                ConfigFetch.mark("load layers");
                layers = ConsoleParse.parseConsoleLayers((Node)element, console);
                ConfigFetch.benchmark("load layers");
                continue;
            }
            if (!"interactions".equals(element.getName())) continue;
            ConfigFetch.mark("load interactions");
            interactions = ConsoleParse.parseConsoleInteractions((Node)element, console);
            ConfigFetch.benchmark("load interactions");
        }
        ConfigFetch.mark("reinit");
        console.initSubPanels();
        ConfigFetch.benchmark("reinit");
        Vector<MapPanel> maps = console.getSubPanelsOfClass(MapPanel.class);
        if (maps.isEmpty() && !layers.isEmpty()) {
            NeptusLog.pub().error((Object)("Cannot add " + layers.size() + " layers because there is no MapPanel"));
        }
        if (maps.isEmpty() && !interactions.isEmpty()) {
            NeptusLog.pub().error((Object)("Cannot add " + interactions.size() + " interactions because there is no MapPanel"));
        } else {
            for (IConsoleLayer layer : layers) {
                console.addMapLayer(layer);
            }
            for (IConsoleInteraction inter : interactions) {
                console.addInteraction(inter);
            }
        }
    }

    public static void parseDocument(Document doc, ConsoleLayout console, String consoleURL) {
        ConsoleParse.parseElement((Element)doc.selectSingleNode("//console"), console, consoleURL);
    }

    public static void parseFile(String consoleURL, ConsoleLayout console) {
        Document doc = null;
        try {
            File fx = new File(consoleURL);
            URL url = fx.toURI().toURL();
            SAXReader reader = new SAXReader();
            doc = reader.read(url);
            Element rootconsole = (Element)doc.selectSingleNode("//console");
            ConsoleParse.parseElement(rootconsole, console, consoleURL);
            console.setXmlDoc(doc);
            console.setFileName(new File(consoleURL));
            console.setConsoleChanged(false);
        }
        catch (Exception e) {
            GuiUtils.errorMessage(null, e);
            NeptusLog.pub().error((Object)(" Console Base open file " + consoleURL + " error [" + e.getStackTrace() + "]"), (Throwable)e);
        }
    }

    private static Vector<IConsoleLayer> parseConsoleLayers(Node node, ConsoleLayout console) {
        List list = node.selectNodes("*");
        Vector<IConsoleLayer> ret = new Vector<IConsoleLayer>();
        for (Element element : list) {
            try {
                String className = element.attribute("class").getValue();
                IConsoleLayer cp = (IConsoleLayer)Class.forName(className).newInstance();
                cp.parseXmlElement(element);
                ret.add(cp);
            }
            catch (Exception e) {
                e.printStackTrace();
                NeptusLog.pub().error((Object)("Error parsing " + element.asXML()));
            }
        }
        Collections.sort(ret, (Comparator)new Comparator<IConsoleLayer>(){

            @Override
            public int compare(IConsoleLayer o1, IConsoleLayer o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return ret;
    }

    private static Vector<IConsoleInteraction> parseConsoleInteractions(Node node, ConsoleLayout console) {
        List list = node.selectNodes("*");
        Vector<IConsoleInteraction> ret = new Vector<IConsoleInteraction>();
        for (Element element : list) {
            try {
                String className = element.attribute("class").getValue();
                IConsoleInteraction cp = (IConsoleInteraction)Class.forName(className).newInstance();
                cp.parseXmlElement(element);
                ret.add(cp);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error parsing " + element.asXML()));
            }
        }
        Collections.sort(ret, (Comparator)new Comparator<IConsoleInteraction>(){

            @Override
            public int compare(IConsoleInteraction o1, IConsoleInteraction o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return ret;
    }

    private static Vector<ConsolePanel> parseConsoleMainPanel(Node node, ConsoleLayout console) {
        List list = node.selectNodes("*");
        Vector<ConsolePanel> panels = new Vector<ConsolePanel>();
        ConfigFetch.mark("construct container");
        for (Element element : list) {
            ConsolePanel subpanel = null;
            switch (element.getName()) {
                case "subpanel": 
                case "panel": 
                case "widget": {
                    Attribute attribute = element.attribute("class");
                    try {
                        Class<?> clazz = Class.forName(attribute.getValue());
                        try {
                            subpanel = (ConsolePanel)clazz.getConstructor(ConsoleLayout.class).newInstance(console);
                            console.getMainPanel().addSubPanel(subpanel);
                            panels.add(subpanel);
                            ConfigFetch.benchmark("construct container");
                            ConfigFetch.mark("in element of container");
                            subpanel.inElement(element);
                            ConfigFetch.benchmark("in element of container");
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)"creating subpanel new instance ", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)("Error parsing " + attribute.getValue()), (Throwable)e);
                    }
                    break;
                }
                default: {
                    NeptusLog.pub().error((Object)("Unrecognized console component: " + element.getName()));
                }
            }
        }
        return panels;
    }

    public static void parseCommunications(Node node, ConsoleLayout console) {
        List list = node.selectNodes("*");
        for (Element element : list) {
            if (!"neptus-communitation".equals(element.getName())) continue;
            Attribute active = element.attribute("active");
            Attribute system = element.attribute("system");
            if (active != null && system != null) continue;
            NeptusLog.pub().error((Object)" Console Base open file error XML seaware config");
            return;
        }
    }

    public static boolean validate(String xml) {
        try {
            String sLoc = new File(ConfigFetch.getConsoleSchemaLocation()).getAbsoluteFile().toURI().toString();
            XMLValidator xmlVal = new XMLValidator(xml, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e) {
            GuiUtils.errorMessage(null, e);
            NeptusLog.pub().error((Object)"Console:validate", (Throwable)e);
            return false;
        }
    }

    public static boolean validate(File file) {
        try {
            String xml = FileUtil.getFileAsString(file);
            return ConsoleParse.validate(xml);
        }
        catch (Exception e) {
            GuiUtils.errorMessage(null, e);
            NeptusLog.pub().error((Object)"Console:validate", (Throwable)e);
            return false;
        }
    }

    @Override
    public void handleFile(File f) {
        ConsoleLayout.forge(f.getAbsolutePath());
    }

    public static ConsoleLayout testSubPanel(Class<?> subPanelClass) {
        return ConsoleParse.testSubPanel(subPanelClass, null);
    }

    public static ConsoleLayout testSubPanel(Class<?> subPanelClass, PlanType plan) {
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        ConsoleLayout cl = new ConsoleLayout();
        cl.setVisible(true);
        cl.setDefaultCloseOperation(3);
        if (plan != null) {
            cl.setMission(plan.getMissionType());
            cl.setMainSystem(plan.getVehicle());
            cl.setPlan(plan);
        }
        try {
            ConsolePanel panel = (ConsolePanel)subPanelClass.getConstructor(ConsoleLayout.class).newInstance(cl);
            panel.setBounds(5, 5, cl.getMainPanel().getWidth() - 10, cl.getMainPanel().getHeight() - 10);
            panel.setBounds(10, 10, (int)panel.getPreferredSize().getWidth(), (int)panel.getPreferredSize().getHeight());
            cl.getMainPanel().addSubPanel(panel, 10, 10);
            return cl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ConsoleLayout dummyConsole(ConsolePanel ... panelsToTest) {
        ConfigFetch.initialize();
        ConsoleLayout layout = new ConsoleLayout();
        layout.setSize(800, 600);
        layout.setMainSystem("lauv-seacon-1");
        int curX = 0;
        for (int i = 0; i < panelsToTest.length; ++i) {
            layout.getMainPanel().addSubPanel(panelsToTest[i], curX, 0);
            curX += panelsToTest[i].getWidth();
        }
        layout.setVisible(true);
        GuiUtils.centerOnScreen(layout);
        layout.setDefaultCloseOperation(3);
        return layout;
    }
}

