/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;

public class DateTimeUtil {
    public static final long DAY = 86400000L;
    public static final long HOUR = 3600000L;
    public static final long MINUTE = 60000L;
    public static final long SECOND = 1000L;
    public static final int DAYS_SINCE_YEAR_0_TILL_1970 = 719530;
    public static final SimpleDateFormat dateFormaterXMLUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'.0Z'"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat dateFormaterXMLNoMillisUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat dateFormaterUTC = new SimpleDateFormat("yyyy-MM-dd"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat dateFormaterNoSpaces = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat timeFormater = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final SimpleDateFormat timeFormaterUTC = new SimpleDateFormat("HH:mm:ss.SSS"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat timeFormaterNoMillis = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat timeFormaterNoMillis2 = new SimpleDateFormat("HH'h'mm'm'ss's'");
    public static final SimpleDateFormat timeFormaterNoMillis2UTC = new SimpleDateFormat("HH'h'mm'm'ss's'"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat timeFormaterNoSegs = new SimpleDateFormat("HH:mm");
    public static final SimpleDateFormat timeFormaterNoSegs2 = new SimpleDateFormat("HH'h'mm'm'");
    public static final SimpleDateFormat timeUTCFormaterNoSegs2 = new SimpleDateFormat("HH'h'mm'm'"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat timeUTCFormaterNoSegs3 = new SimpleDateFormat("HH':'mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat dateTimeFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final SimpleDateFormat dateTimeFormaterUTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat dateTimeFormaterNoMillis = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat dateTimeFormaterNoSegs = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat dateTimeFormater2UTC = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", new Locale("en")){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final SimpleDateFormat dateTimeFileNameFormater = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'");
    public static final SimpleDateFormat dateTimeFileNameFormaterMillis = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss.SSS's'");
    private static long initialTimeMillis = System.currentTimeMillis();
    private static long initialTimeNanos = System.nanoTime();

    public static long formatedStringToMillis(String formatedTime) {
        String time = formatedTime.replaceAll(" ", "");
        String val = "";
        long total = 0L;
        block6: for (int i = 0; i < time.length(); ++i) {
            char c = time.charAt(i);
            if (Character.isDigit(c)) {
                val = val + c;
                continue;
            }
            switch (c) {
                case 's': {
                    total += (long)(Integer.parseInt(val) * 1000);
                    val = "";
                    continue block6;
                }
                case 'm': {
                    total += (long)(Integer.parseInt(val) * 1000 * 60);
                    val = "";
                    continue block6;
                }
                case 'h': {
                    total += (long)(Integer.parseInt(val) * 1000 * 60 * 60);
                    val = "";
                    continue block6;
                }
                case 'd': {
                    total += (long)(Integer.parseInt(val) * 1000 * 60 * 60 * 24);
                    val = "";
                    continue block6;
                }
                default: {
                    val = "";
                }
            }
        }
        return total;
    }

    public static final String milliSecondsToFormatedString(long timeMillis) {
        double time = (double)timeMillis / 1000.0;
        String tt = "";
        if (time < 60.0) {
            tt = new Double(time) + " s";
        } else if (time / 60.0 < 60.0) {
            long mi = (long)(time / 60.0);
            long sec = (long)(time % 60.0);
            tt = mi + "m " + (sec < 10L ? "0" : "") + sec + "s";
        } else if (time / 60.0 / 60.0 < 24.0) {
            long hr = (long)(time / 60.0 / 60.0);
            long mi = (long)(time / 60.0 % 60.0);
            tt = hr + "h " + (mi < 10L ? "0" : "") + mi + "m";
        } else {
            long dy = (long)(time / 60.0 / 60.0 / 24.0);
            long hr = (long)(time / 60.0 / 60.0 % 24.0);
            long mi = (long)(time / 60.0 % 60.0);
            tt = dy + "d " + (hr < 10L ? "0" : "") + hr + "h " + (mi < 10L ? "0" : "") + mi + "m";
        }
        return tt;
    }

    public static double timeStampSeconds() {
        return (double)System.currentTimeMillis() * 0.001;
    }

    public static String getUID() {
        return "" + (initialTimeMillis * 1000000L + initialTimeNanos % 1000000L);
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + DateTimeUtil.getUID()));
        NeptusLog.pub().info((Object)("<###> " + dateTimeFileNameFormater.format(new Date(System.currentTimeMillis()))));
        NeptusLog.pub().info((Object)("<###> " + DateTimeUtil.milliSecondsToFormatedString(86400000L)));
        NeptusLog.pub().info((Object)("<###> " + DateTimeUtil.milliSecondsToFormatedString(131400000L)));
        NeptusLog.pub().info((Object)("<###> " + DateTimeUtil.milliSecondsToFormatedString(6870600000L)));
        int i = 0;
        while (i++ < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            double m = System.currentTimeMillis();
            double n = DateTimeUtil.timeStampSeconds();
            double nn = System.nanoTime();
            System.out.printf("" + (m *= 0.001) + "  " + n + "  " + nn + "  " + (m - n) + "\n", new Object[0]);
        }
        NeptusLog.pub().info((Object)("<###> " + dateTimeFormater2UTC.format(new Date())));
        NeptusLog.pub().info((Object)("<###> " + new Date()));
        String clockStr = timeUTCFormaterNoSegs3.format(new Date(System.currentTimeMillis())) + " " + I18n.text("UTC");
        System.out.println(clockStr);
    }
}

