/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.llf.LsfReport;

public class Dom4JUtil {
    public static Document elementToDocument(Element elem) {
        if (elem == null) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        doc.setRootElement(elem.createCopy());
        return doc;
    }

    public static Document elementToDocumentCleanFormating(Element elem) {
        Document doc;
        if (elem == null) {
            return null;
        }
        try {
            doc = DocumentHelper.parseText((String)FileUtil.getAsCompactFormatedXMLString(elem.asXML()));
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)"Dom4JUtil.elementToDocumentCleanFormating error!");
            doc = null;
        }
        return doc;
    }

    public static Document documentToDocumentCleanFormating(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            doc = DocumentHelper.parseText((String)FileUtil.getAsCompactFormatedXMLString(doc.asXML()));
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)"Dom4JUtil.documentToDocumentCleanFormating error!");
            doc = null;
        }
        return doc;
    }

    public static org.w3c.dom.Document createEmptyDOMDocument() {
        try {
            return new DOMWriter().write(DocumentHelper.createDocument());
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document convertDOMtoDOM4J(org.w3c.dom.Document docDOM) {
        return new DOMReader().read(docDOM);
    }

    public static org.w3c.dom.Document convertDOM4JtoDOM(Document docDOM4J) {
        try {
            return new DOMWriter().write(docDOM4J);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        LsfReport.getLogoDoc();
    }
}

