/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class FileUtil {
    public static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF16LE = new byte[]{-1, -2};
    public static final byte[] BOM_UTF16BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF32LE = new byte[]{0, 0, -1, -2};
    public static final byte[] BOM_UTF32BE = new byte[]{0, 0, -2, -1};
    public static final String FILE_TYPE_MISSION = "nmis";
    public static final String FILE_TYPE_MISSION_COMPRESSED = "nmisz";
    public static final String FILE_TYPE_MAP = "nmap";
    public static final String FILE_TYPE_CONSOLE = "ncon";
    public static final String FILE_TYPE_CONFIG = "ncfg";
    public static final String FILE_TYPE_VEHICLE = "nvcl";
    public static final String FILE_TYPE_CHECKLIST = "nchk";
    public static final String FILE_TYPE_WSN = "nwsn";
    public static final String FILE_TYPE_INI = "ini";
    public static final String FILE_TYPE_RMF = "rmf";
    public static final String FILE_TYPE_XML = "xml";
    public static final String FILE_TYPE_LSF = "lsf";
    public static final String FILE_TYPE_LSF_COMPRESSED = "lsf.gz";
    public static final String FILE_TYPE_LSF_COMPRESSED_BZIP2 = "lsf.bz2";

    private FileUtil() {
    }

    public static String getFileExtension(File fx) {
        String path = null;
        try {
            path = fx.getCanonicalPath();
        }
        catch (IOException e1) {
            path = fx.getAbsolutePath();
        }
        return FileUtil.getFileExtension(path);
    }

    public static String getFileExtension(String path) {
        int lastDotPostion = path.lastIndexOf(46);
        return lastDotPostion != -1 ? path.substring(lastDotPostion + 1) : "";
    }

    public static String getFileNameWithoutExtension(File fx) {
        String path = null;
        try {
            path = fx.getCanonicalPath();
        }
        catch (IOException e1) {
            path = fx.getAbsolutePath();
        }
        return FileUtil.getFileNameWithoutExtension(path);
    }

    public static String getFileNameWithoutExtension(String path) {
        File f = new File(path);
        String fname = f.getName();
        int lastDotPostion = fname.lastIndexOf(46);
        String ret = lastDotPostion != -1 ? fname.substring(0, lastDotPostion) : fname;
        return ret;
    }

    public static String replaceFileExtension(File fx, String newExtension) {
        String path = null;
        try {
            path = fx.getCanonicalPath();
        }
        catch (IOException e1) {
            path = fx.getAbsolutePath();
        }
        return FileUtil.replaceFileExtension(path, newExtension);
    }

    public static String replaceFileExtension(String path, String newExtension) {
        int lastDotPostion = path.lastIndexOf(46);
        String st = lastDotPostion != -1 ? path.substring(0, lastDotPostion) : path;
        return st + "." + newExtension;
    }

    public static String checkFileForExtensions(File file, String ... extensions) {
        return FileUtil.checkFileForExtensions(file.getName(), extensions);
    }

    public static String checkFileForExtensions(String filePath, String ... extensions) {
        if (filePath == null || extensions == null || extensions.length == 0) {
            return null;
        }
        String fileExt = FileUtil.getFileExtension(filePath);
        if (fileExt == null || fileExt.isEmpty()) {
            return null;
        }
        for (String ext : extensions) {
            if (!fileExt.equalsIgnoreCase(ext)) continue;
            return ext;
        }
        return null;
    }

    public static String getFileAsString(File fx) {
        return FileUtil.getFileAsString(fx.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileAsString(String url) {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] ba = null;
        String result = null;
        String actualEncoding = "UTF-8";
        try {
            int len;
            fis = new FileInputStream(url);
            ba = new byte[1024];
            while ((len = fis.read(ba)) > 0) {
                bos.write(ba, 0, len);
            }
            ba = bos.toByteArray();
            String enc = FileUtil.findOutFileEncoding(ba);
            actualEncoding = enc == null ? "UTF-8" : enc;
            try {
                result = new String(ba, actualEncoding);
            }
            catch (UnsupportedEncodingException e1) {
                NeptusLog.pub().debug((Object)(FileUtil.class + "getFileAsString "), (Throwable)e1);
                result = new String(ba, "UTF-8");
            }
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error(FileUtil.class, (Throwable)e);
        }
        catch (IOException e) {
            NeptusLog.pub().error(FileUtil.class, (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    NeptusLog.pub().error(FileUtil.class, (Throwable)e);
                }
            }
        }
        return result;
    }

    private static File[] getFilesFromDiskWorker(File folderToLoad, final String searchPattern, final boolean justFolders) {
        try {
            if (folderToLoad != null && folderToLoad.exists()) {
                File folder = folderToLoad.isDirectory() ? folderToLoad : folderToLoad.getParentFile();
                FilenameFilter fileFilter = new FilenameFilter(){
                    Pattern pat;
                    {
                        this.pat = searchPattern == null || searchPattern.isEmpty() ? null : Pattern.compile(searchPattern);
                    }

                    @Override
                    public boolean accept(File file, String name) {
                        if (this.pat == null) {
                            File fx = new File(file, name);
                            return justFolders ? fx.isDirectory() : fx.isFile();
                        }
                        Matcher m = this.pat.matcher(name);
                        boolean ret = m.find();
                        File fx = new File(file, name);
                        return ret ? (justFolders ? fx.isDirectory() : fx.isFile()) : false;
                    }
                };
                Object[] lst = folder.listFiles(fileFilter);
                Arrays.sort(lst);
                return lst;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static File[] getFilesFromDisk(File folderToLoad, String searchPattern) {
        return FileUtil.getFilesFromDiskWorker(folderToLoad, searchPattern, false);
    }

    public static File[] getFoldersFromDisk(File folderToLoad, String searchPattern) {
        return FileUtil.getFilesFromDiskWorker(folderToLoad, searchPattern, true);
    }

    public static byte[] getFileAsByteArray(String url) {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] ba = null;
        try {
            int len;
            fis = new FileInputStream(url);
            ba = new byte[1024];
            while ((len = fis.read(ba)) > 0) {
                bos.write(ba, 0, len);
            }
            ba = bos.toByteArray();
            fis.close();
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error(FileUtil.class, (Throwable)e);
        }
        catch (IOException e) {
            NeptusLog.pub().error(FileUtil.class, (Throwable)e);
        }
        return ba;
    }

    private static String findOutFileEncoding(byte[] ba) {
        try {
            String str = new String(ba);
            String delim = "=\"";
            boolean isXML = str.startsWith("<?xml");
            if (isXML) {
                int tc = str.indexOf(">");
                if (tc == -1) {
                    return null;
                }
                tc = str.indexOf("encoding");
                if (tc == -1) {
                    return null;
                }
                String s2 = str.substring(tc + "encoding".length());
                StringTokenizer strt = new StringTokenizer(s2, delim);
                String encoding = strt.nextToken();
                NeptusLog.pub().debug((Object)(FileUtil.class + ".findOutFileEncoding - " + encoding));
                return encoding;
            }
            if (ba[0] == BOM_UTF8[0] && ba[1] == BOM_UTF8[1] && ba[2] == BOM_UTF8[2]) {
                NeptusLog.pub().debug((Object)(FileUtil.class + ".findOutFileEncoding - " + "UTF-8"));
                return "UTF-8";
            }
            if (ba[0] == BOM_UTF16LE[0] && ba[1] == BOM_UTF16LE[1]) {
                NeptusLog.pub().debug((Object)(FileUtil.class + ".findOutFileEncoding - " + "UTF-16LE"));
                return "UTF-16LE";
            }
            if (ba[0] == BOM_UTF16BE[0] && ba[1] == BOM_UTF16BE[1]) {
                NeptusLog.pub().debug((Object)(FileUtil.class + ".findOutFileEncoding - " + "UTF-16BE"));
                return "UTF-16BE";
            }
        }
        catch (RuntimeException e) {
            NeptusLog.pub().error((Object)"FIleUtil:findOutFileEncoding", (Throwable)e);
        }
        return null;
    }

    public static String getAsPrettyPrintFormatedXMLString(String xml) {
        return FileUtil.getAsPrettyPrintFormatedXMLString(xml, false);
    }

    public static String getAsPrettyPrintFormatedXMLString(String xml, boolean omitDeclaration) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)"FIleUtil:getAsPrettyPrintFormatedXMLString", (Throwable)e);
            return null;
        }
        return FileUtil.getAsPrettyPrintFormatedXMLString(doc, omitDeclaration);
    }

    public static String getAsCompactFormatedXMLString(String xml) {
        return FileUtil.getAsCompactFormatedXMLString(xml, false);
    }

    public static String getAsCompactFormatedXMLString(String xml, boolean omitDeclaration) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)"FIleUtil:getAsCompactFormatedXMLString", (Throwable)e);
            return null;
        }
        return FileUtil.getAsCompactFormatedXMLString(doc, omitDeclaration);
    }

    public static String getAsPrettyPrintFormatedXMLString(Document doc) {
        return FileUtil.getAsPrettyPrintFormatedXMLString(doc, false);
    }

    public static String getAsPrettyPrintFormatedXMLString(Document doc, boolean omitDeclaration) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setTrimText(false);
        format.setNewLineAfterDeclaration(false);
        format.setSuppressDeclaration(omitDeclaration);
        return FileUtil.getAsFormatedXMLString(doc, format);
    }

    public static String getAsCompactFormatedXMLString(Document doc) {
        return FileUtil.getAsCompactFormatedXMLString(doc, false);
    }

    public static String getAsCompactFormatedXMLString(Document doc, boolean omitDeclaration) {
        OutputFormat format = OutputFormat.createCompactFormat();
        format.setSuppressDeclaration(omitDeclaration);
        return FileUtil.getAsFormatedXMLString(doc, format);
    }

    private static String getAsFormatedXMLString(Document doc, OutputFormat format) {
        String result;
        String enc = doc.getXMLEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            XMLWriter writer = new XMLWriter((OutputStream)ba, format);
            writer.write(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            result = ba.toString(enc);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
            try {
                result = ba.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
                result = ba.toString();
            }
        }
        return result;
    }

    public static void appendToFile(File destination, InputStream source) throws Exception {
        FileOutputStream fos = new FileOutputStream(destination, true);
        byte[] buff = new byte[1024];
        int readBytes = source.read(buff);
        while (readBytes > 0) {
            fos.write(buff, 0, readBytes);
            readBytes = source.read(buff);
        }
        fos.close();
    }

    public static void concatFiles(File destination, File fileToBeAppended) throws Exception {
        FileUtil.appendToFile(destination, fileToBeAppended);
    }

    public static void appendToFile(File destination, File fileToBeAppended) throws Exception {
        FileInputStream fis = new FileInputStream(fileToBeAppended);
        FileUtil.appendToFile(destination, fis);
        fis.close();
    }

    public static boolean appendToFile(String fileName, String dataToSave, String encoding) {
        return FileUtil.saveToFile(fileName, dataToSave, encoding, true);
    }

    public static boolean appendToFile(String fileName, String dataToSave) {
        return FileUtil.appendToFile(fileName, dataToSave, "UTF-8");
    }

    public static boolean saveToFile(String fileName, String dataToSave, String encoding) {
        return FileUtil.saveToFile(fileName, dataToSave, encoding, false);
    }

    public static boolean saveToFile(String fileName, String dataToSave) {
        return FileUtil.saveToFile(fileName, dataToSave, "UTF-8", false);
    }

    public static boolean saveToFile(String fileName, String dataToSave, String encoding, boolean append) {
        String actualEncoding = encoding;
        try {
            OutputStreamWriter out;
            if (!fileName.equals("")) {
                File fx = new File(fileName).getAbsoluteFile();
                if (!fx.exists()) {
                    File fx1 = new File(fx.getParent());
                    if (!fx1.isDirectory() && !fx1.isFile()) {
                        fx1.mkdirs();
                    }
                    fx.createNewFile();
                }
                if (!fileName.equals(fx.toString())) {
                    fileName = fx.toString();
                }
                try {
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), encoding);
                }
                catch (UnsupportedEncodingException UEe) {
                    System.err.println("\n-- UnsupportedEncodingException\n");
                    System.err.flush();
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), "iso8859-1");
                    actualEncoding = "iso8859-1";
                }
            } else {
                out = new OutputStreamWriter((OutputStream)System.out, "iso8859-1");
                actualEncoding = "iso8859-1";
            }
            NeptusLog.waste().debug((Object)(FileUtil.class + " Output to file as (" + actualEncoding + ") \n" + dataToSave));
            out.write(dataToSave.toString());
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error((Object)"saveToFile", (Throwable)e);
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), "File not found", "<html>An error occured while saving the file: <br><strong>" + e.getMessage() + "</strong></html>");
            return false;
        }
        catch (UnsupportedEncodingException e) {
            NeptusLog.pub().error((Object)"saveToFile", (Throwable)e);
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), "Encoding not supported: " + actualEncoding, "<html>An error occured while saving the file: <br><strong>" + e.getMessage() + "</strong></html>");
            return false;
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"saveToFile", (Throwable)e);
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), "Input/Output error", "<html>An error occured while saving the file: <br><strong>" + e.getMessage() + "</strong></html>");
            return false;
        }
        return true;
    }

    public static boolean backupFile(String source) {
        File fx = new File(source);
        NeptusLog.pub().debug((Object)("FileUtil::copyFileAndBackup: " + fx.exists()));
        if (fx.exists()) {
            boolean bl = FileUtil.copyFile(fx.getAbsolutePath(), fx.getAbsolutePath().concat(".bak"));
            NeptusLog.pub().debug((Object)("FileUtil::copyFileAndBackupRes: " + bl));
            return true;
        }
        return false;
    }

    public static boolean copyFileAndBackup(String source, String out) {
        File fx = new File(out);
        NeptusLog.pub().debug((Object)("FileUtil::copyFileAndBackup: " + fx.exists()));
        if (fx.exists()) {
            boolean bl = FileUtil.copyFile(fx.getAbsolutePath(), fx.getAbsolutePath().concat(".bak"));
            NeptusLog.pub().debug((Object)("FileUtil::copyFileAndBackupRes: " + bl));
        }
        return FileUtil.copyFile(source, out);
    }

    public static boolean copyFile(String source, String dest) {
        boolean ret = false;
        try {
            File in = new File(source);
            File out = new File(dest);
            FileInputStream fis = new FileInputStream(in);
            ret = StreamUtil.copyStreamToFile(fis, out);
            try {
                fis.close();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
        return ret;
    }

    public static boolean copyFileToDir(String source, String destDir) {
        try {
            File in = new File(source);
            File out = new File(destDir, in.getName());
            FileInputStream fis = new FileInputStream(in);
            boolean ret = StreamUtil.copyStreamToFile(fis, out);
            try {
                fis.close();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
            return ret;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
    }

    public static String relativizeFilePathAsURI(String parentPath, String filePath) {
        String st = FileUtil.relativizeFilePath(parentPath, filePath);
        st = st.replace('\\', '/').toString();
        NeptusLog.pub().debug((Object)("relativizeFilePathAsURI   > " + st));
        return st;
    }

    public static String relativizeFilePath(String parentPath, String filePath) {
        String fS;
        String pS;
        NeptusLog.pub().debug((Object)("relativizeFilePath:parentPath > " + parentPath));
        NeptusLog.pub().debug((Object)("relativizeFilePath:filePath > " + filePath));
        File fxP = new File(parentPath);
        File fxF = new File(filePath);
        if (!fxP.isDirectory()) {
            fxP = fxP.getParentFile().getAbsoluteFile();
        }
        if (fxF.exists()) {
            fxF = fxF.getAbsoluteFile();
        }
        try {
            pS = fxP.getCanonicalPath();
        }
        catch (IOException e) {
            pS = fxP.getAbsolutePath();
        }
        try {
            fS = fxF.getCanonicalPath();
        }
        catch (IOException e) {
            fS = fxF.getAbsolutePath();
        }
        String res = fS;
        int lev = 0;
        if (fS.regionMatches(0, pS, 0, pS.length())) {
            int len = pS.length() + 1;
            if (pS.endsWith("\\") || pS.endsWith("/")) {
                --len;
            }
            res = fS.substring(len);
        } else {
            int i = 0;
            String tmp = pS;
            String fxSep = System.getProperty("file.separator", "/");
            while (i != -1) {
                i = tmp.lastIndexOf(fxSep);
                if (i == -1) {
                    lev = 0;
                    break;
                }
                int j = tmp.indexOf(fxSep);
                if (j == i) {
                    lev = 0;
                    break;
                }
                ++lev;
                if (!fS.regionMatches(0, tmp = tmp.substring(0, i), 0, tmp.length())) continue;
                res = fS.substring(tmp.length() + 1, fS.length());
                break;
            }
            if (lev > 0) {
                for (int k = 0; k < lev; ++k) {
                    res = ".." + fxSep + res;
                }
            }
        }
        NeptusLog.pub().debug((Object)("relativizeFilePath:parent > " + pS));
        NeptusLog.pub().debug((Object)("relativizeFilePath:file   > " + fS));
        NeptusLog.pub().debug((Object)("relativizeFilePath:result > " + res));
        return res;
    }

    public static void deltree(String dir) {
        String[] files;
        String sep = System.getProperty("file.separator");
        File directory = new File(dir);
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            directory.delete();
        }
        if ((files = directory.list()) == null) {
            return;
        }
        for (String f : files) {
            File tmp = new File(directory.getAbsolutePath() + sep + f);
            if (tmp.isDirectory()) {
                FileUtil.deltree(tmp.getAbsolutePath());
                continue;
            }
            try {
                tmp.delete();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        directory.delete();
    }

    public static URL pathToURL(String path) throws MalformedURLException {
        URL retval = null;
        if (path == null) {
            return null;
        }
        if (!path.startsWith(File.separator) && path.indexOf(58) != 1) {
            path = System.getProperties().getProperty("user.dir") + '/' + path;
        }
        path = path.replace(File.separatorChar, '/');
        retval = new URL("file:" + path);
        return retval;
    }

    private static Class<?> getCallerClass() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String className = stack[3].getClassName();
        if (className.startsWith(FileUtil.class.getName())) {
            className = stack[4].getClassName();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static String getResourceAsFile(String name) {
        InputStream inStream = FileUtil.class.getResourceAsStream(name.replace('\\', '/'));
        if (inStream == null) {
            Class<?> clazz = FileUtil.getCallerClass();
            if (clazz == null) {
                return null;
            }
            inStream = clazz.getResourceAsStream(name.replace('\\', '/'));
            if (inStream == null) {
                return null;
            }
        }
        try {
            return StreamUtil.copyStreamToTempFile(inStream).getPath();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static String getResourceAsFileKeepName(String name) {
        InputStream inStream = FileUtil.class.getResourceAsStream(name.replace('\\', '/'));
        if (inStream == null) {
            Class<?> clazz = FileUtil.getCallerClass();
            if (clazz == null) {
                return null;
            }
            inStream = clazz.getResourceAsStream(name.replace('\\', '/'));
            if (inStream == null) {
                return null;
            }
        }
        try {
            File tmpDir = new File(ConfigFetch.getNeptusTmpDir());
            File nfx = new File(name);
            File fx = new File(tmpDir, nfx.getName());
            fx.getParentFile().mkdirs();
            try {
                fx.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            fx.deleteOnExit();
            boolean ret = StreamUtil.copyStreamToFile(inStream, fx);
            try {
                inStream.close();
            }
            catch (IOException e) {
                NeptusLog.waste().error((Object)"copyStreamToFile", (Throwable)e);
            }
            return ret ? fx.getPath() : null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static boolean loadLibraryFromResource(String libResourcePath) {
        try {
            String path = FileUtil.getResourceAsFileKeepName(libResourcePath);
            System.load(path);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        ConfigFetch.initialize();
        NeptusLog.pub().info((Object)("<###> " + FileUtil.relativizeFilePath("D:\\FEUP\\NeptusProj\\neptus_ini\\testemission.xml", "D:\\FEUP\\NeptusProj\\neptus_ini\\teste\\cl.xml")));
        NeptusLog.pub().info((Object)("<###> " + FileUtil.relativizeFilePath("D:/cl.xml", "D:/FEUP/NeptusProj/neptus_ini/teste/mission.xml")));
        File f = new File("C:/AUTOEXEC.BAT");
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getFileExtension(f)));
        f = new File("C:/AUTOEXEC");
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getFileExtension(f)));
        f = new File("D:\\FEUP\\NeptusProj\\neptus_ini\\missions\\alfena\\MISSIO~1.NMI");
        NeptusLog.pub().info((Object)("<###> " + f.getAbsolutePath()));
        NeptusLog.pub().info((Object)("<###> " + f.getCanonicalPath()));
        NeptusLog.pub().info((Object)("<###> " + f.canRead()));
        NeptusLog.pub().info((Object)("<###> " + FileUtil.relativizeFilePathAsURI("D:\\FEUP\\NeptusProj\\neptus_ini\\testemission.xml", "D:\\FEUP\\NeptusProj\\neptus_ini\\teste\\cl.xml")));
    }
}

