/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;

public class GenerateLaunchers {
    private static String srcBatFile = "./srcShell/neptus.bat";
    private static String srcShFile = "./srcShell/neptus.sh";
    private static String dstBatFile = "./neptus.bat";
    private static String dstShFile = "./neptus.sh";
    private static String replaceString = "@NEPTUS_LIBS@";
    private static String libsDir = "lib";
    private static Vector<String> ignoreDirs = new Vector();

    public static void main(String[] args) throws Exception {
        File f = new File(libsDir);
        String windowsLibs = GenerateLaunchers.listContents(libsDir, f, ';');
        String batContents = GenerateLaunchers.readFile(srcBatFile);
        batContents = batContents.replaceFirst(replaceString, windowsLibs);
        NeptusLog.pub().info((Object)("<###>NEPTUS.BAT CONTENTS:\n" + batContents + "\n\n"));
        GenerateLaunchers.writeFile(dstBatFile, batContents);
        String linuxLibs = GenerateLaunchers.listContents(libsDir, f, ':');
        String shContents = GenerateLaunchers.readFile(srcShFile);
        shContents = shContents.replaceFirst(replaceString, linuxLibs);
        NeptusLog.pub().info((Object)("<###>NEPTUS.SH CONTENTS:\n" + shContents + "\n"));
        GenerateLaunchers.writeFile(dstShFile, shContents);
    }

    private static String readFile(String filename) throws Exception {
        int len;
        String contents = "";
        FileInputStream fis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] ba = null;
        fis = new FileInputStream(filename);
        ba = new byte[1024];
        while ((len = fis.read(ba)) > 0) {
            bos.write(ba, 0, len);
        }
        ba = bos.toByteArray();
        contents = new String(ba);
        fis.close();
        return contents;
    }

    private static void writeFile(String filename, String contents) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.write(contents);
        bw.close();
    }

    private static String listContents(String dirPrefix, File dir, char separator) {
        String sp = System.getProperty("file.separator");
        String contents = "";
        if (dir.canRead() && dir.isDirectory()) {
            for (String subDir : dir.list()) {
                if (ignoreDirs.contains(subDir)) continue;
                File entry = new File(dir.getAbsoluteFile() + sp + subDir);
                contents = entry.canRead() && entry.isDirectory() ? contents + GenerateLaunchers.listContents(dirPrefix + "/" + subDir, entry, separator) : contents + separator + dirPrefix + "/" + subDir;
            }
        }
        return contents;
    }

    static {
        ignoreDirs.add(".svn");
    }
}

