/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBlue;
import com.l2fprod.common.swing.BaseDialog;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.data.Pair;
import pt.lsts.neptus.gui.ErrorMessageBox;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.NameNormalizer;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class GuiUtils {
    public static String CLIP_ERROR = "/sounds/error.wav";
    public static String CLIP_WARNING = "/sounds/warning.wav";
    public static String CLIP_COMPLETE = "/sounds/complete.wav";
    public static String CLIP_SNAPSHOT = "/sounds/snapshot.wav";
    static Hashtable<Integer, NumberFormat> nformats = new Hashtable();
    protected static TrayIcon icon = null;

    public static NumberFormat getNeptusDecimalFormat() {
        NumberFormat df = DecimalFormat.getInstance(Locale.US);
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(15);
        return df;
    }

    public static NumberFormat getNeptusIntegerFormat() {
        NumberFormat df = DecimalFormat.getInstance(Locale.US);
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(0);
        df.setMinimumFractionDigits(0);
        df.setParseIntegerOnly(true);
        return df;
    }

    public static Font getFont(InputStream is, int size) {
        Font font;
        try {
            font = Font.createFont(0, is);
        }
        catch (Exception e) {
            e.printStackTrace();
            font = new Font("serif", 0, size);
        }
        return font.deriveFont((float)size);
    }

    public static NumberFormat getNeptusDecimalFormat(int fractionDigits) {
        if (nformats.containsKey(fractionDigits)) {
            return nformats.get(fractionDigits);
        }
        NumberFormat df = GuiUtils.getNeptusDecimalFormat();
        df.setMaximumFractionDigits(fractionDigits);
        df.setMinimumFractionDigits(fractionDigits);
        nformats.put(fractionDigits, df);
        return df;
    }

    public static Rectangle getScreenBounds(int x, int y) {
        Rectangle[] bounds;
        for (Rectangle b : bounds = GuiUtils.getDisplayBounds()) {
            if (!((double)x >= b.getMinX()) || !((double)x < b.getMaxX()) || !((double)y >= b.getMinY()) || !((double)y < b.getMaxY())) continue;
            return b;
        }
        NeptusLog.pub().error((Object)("Error determinig the screen for the coordidate " + x + "," + y));
        return bounds[0];
    }

    public static Rectangle[] getDisplayBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle[] bounds = new Rectangle[gs.length];
        for (int j = 0; j < gs.length; ++j) {
            bounds[j] = gs[j].getDefaultConfiguration().getBounds();
        }
        Arrays.sort(bounds, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle o1, Rectangle o2) {
                int diff = o1.y - o2.y;
                if (o1.y != o2.y) {
                    return diff;
                }
                return o1.x - o2.x;
            }
        });
        return bounds;
    }

    public static void centerOnScreenOld(Window window) {
        Dimension size = window.getSize();
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (scr.width - size.width) / 2;
        int y = (scr.height - size.height) / 2;
        window.setBounds(x, y, size.width, size.height);
    }

    public static void centerOnScreen(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static void rightTopScreen(Window window) {
        Dimension size = window.getSize();
        Point pt = window.getLocation();
        Rectangle bounds = GuiUtils.getScreenBounds(pt.x, pt.y);
        int x = (int)bounds.getMaxX() - size.width;
        window.setBounds(x, bounds.y, size.width, size.height);
    }

    public static void rightCenterScreen(Window window) {
        Dimension size = window.getSize();
        Point pt = window.getLocation();
        Rectangle bounds = GuiUtils.getScreenBounds(pt.x, pt.y);
        int x = (int)bounds.getMaxX() - size.width;
        int y = bounds.y + (bounds.height - size.height) / 2;
        window.setBounds(x, y, size.width, size.height);
    }

    public static void leftCenterScreen(Window window) {
        Dimension size = window.getSize();
        Point pt = window.getLocation();
        Rectangle bounds = GuiUtils.getScreenBounds(pt.x, pt.y);
        int y = bounds.y + (bounds.height - size.height) / 2;
        window.setBounds(bounds.x, y, size.width, size.height);
    }

    public static void leftBottomScreen(Window window) {
        Dimension size = window.getSize();
        Point pt = window.getLocation();
        Rectangle bounds = GuiUtils.getScreenBounds(pt.x, pt.y);
        int x = bounds.x;
        int y = bounds.y + (bounds.height - size.height);
        window.setBounds(x, y, size.width, size.height);
    }

    public static void leftTopScreen(Window window) {
        Dimension size = window.getSize();
        Point pt = window.getLocation();
        Rectangle bounds = GuiUtils.getScreenBounds(pt.x, pt.y);
        int x = bounds.x;
        int y = bounds.y;
        window.setBounds(x, y, size.width, size.height);
    }

    public static void bottomParent(Window window, Window parent) {
        Rectangle pos = parent.getBounds();
        Dimension size = window.getSize();
        Point pt = parent.getLocationOnScreen();
        Rectangle screenBounds = GuiUtils.getScreenBounds(pt.x, pt.y);
        int x = pos.x;
        int y = pos.y + pos.height;
        if ((double)(y + size.height) > screenBounds.getMaxY()) {
            window.setBounds(x, (int)screenBounds.getMaxY() - size.height, pos.width, size.height);
        } else {
            window.setBounds(x, y, pos.width, size.height);
        }
    }

    public static void centerParent(Window window, Window parent) {
        Rectangle pos = parent.getBounds();
        Rectangle size = window.getBounds();
        int x = pos.width / 2 + pos.x - size.width / 2;
        int y = pos.height / 2 + pos.y - size.height / 2;
        window.setBounds(x, y, size.width, size.height);
    }

    public static void southEastParent(Window window, Window parent, int maxWidth, int maxHeight) {
        Rectangle pos = parent.getBounds();
        Point pt = parent.getLocationOnScreen();
        Rectangle screenBounds = GuiUtils.getScreenBounds(pt.x, pt.y);
        int x = pos.x + pos.width;
        int y = pos.y + pos.height;
        int sizex = (int)screenBounds.getMaxX() - x;
        int sizey = (int)screenBounds.getMaxY() - y;
        if (sizex > maxWidth) {
            sizex = maxWidth;
        }
        if (sizey > maxHeight) {
            sizey = maxHeight;
        }
        if (sizex < 200) {
            sizex += 200;
            x -= 200;
        }
        if (sizey < 100) {
            sizey += 100;
            y -= 100;
        }
        if (x > (int)screenBounds.getMaxX()) {
            x -= 200;
        }
        if (y > (int)screenBounds.getMaxY()) {
            x -= 100;
        }
        window.setBounds(x, y, sizex, sizey);
    }

    @Deprecated
    public static String idSelector(Object[] unavailableIDs, String defaultValue) {
        boolean ok = false;
        String id = null;
        JFrame tmp = new JFrame();
        while (!ok || id == null) {
            id = JOptionPane.showInputDialog(tmp, "Enter an identifier", defaultValue);
            if (id == null) {
                return null;
            }
            ok = true;
            if (!NameNormalizer.isNeptusValidIdentifier(id)) {
                GuiUtils.errorMessage(null, "Not a valid ID", "The entered ID is not valid");
                ok = false;
                continue;
            }
            for (int i = 0; i < unavailableIDs.length; ++i) {
                if (!id.equals(unavailableIDs[i])) continue;
                GuiUtils.errorMessage(null, "Not a valid ID", "The entered ID is already in use");
                ok = false;
            }
        }
        return id;
    }

    private static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        for (int i = 0; i < clr1.length; ++i) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    public static void paintBorderShadow(Graphics2D g2, int shadowWidth, Color background, Shape shape) {
        int sw;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = sw = shadowWidth * 2; i >= 2; i -= 2) {
            float pct = (float)(sw - i) / (float)(sw - 1);
            g2.setColor(GuiUtils.getMixedColor(Color.LIGHT_GRAY, pct, background, 1.0f - pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(shape);
        }
    }

    public static void paintBorderShadow(Graphics2D g2, int shadowWidth, Shape shape) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color background = new Color(0, 0, 0, 0);
        GuiUtils.paintBorderShadow(g2, shadowWidth, background, shape);
    }

    public static JFrame testFrame(JComponent component) {
        return GuiUtils.testFrame(component, "testing " + component.getClass().getSimpleName());
    }

    public static JFrame testFrame(JComponent component, String title, int width, int height) {
        JFrame frame = new JFrame(title);
        frame.setLayout(new BorderLayout());
        frame.getContentPane().add((Component)component, "Center");
        frame.setDefaultCloseOperation(2);
        frame.setSize(width, height);
        GuiUtils.centerOnScreen(frame);
        frame.setVisible(true);
        return frame;
    }

    public static JFrame testFrame(JComponent component, String title) {
        return GuiUtils.testFrame(component, title, 320, 240);
    }

    public static Rectangle getDefaultScreenBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }

    public static void playAudioClip(String clipFilename) {
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(new FileInputStream(clipFilename));
            if (audioInputStream != null) {
                AudioFormat format = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                Clip m_clip = (Clip)AudioSystem.getLine(info);
                m_clip.open(audioInputStream);
                m_clip.start();
            } else {
                NeptusLog.pub().error((Object)("ClipPlayer.<init>(): can't get data from file " + clipFilename));
            }
        }
        catch (LineUnavailableException lineException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public static void infoMessage(Component owner, String title, String message) {
        GuiUtils.infoMessage(owner, title, message, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public static void infoMessage(Component owner, String title, String message, Dialog.ModalityType modalityType) {
        JOptionPane jop = new JOptionPane(message, 1);
        JDialog dialog = jop.createDialog(owner, title);
        dialog.setModalityType(modalityType);
        dialog.setVisible(true);
    }

    public static int confirmDialog(Component owner, String title, String message) {
        return GuiUtils.confirmDialog(owner, title, message, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public static int confirmDialog(Component owner, String title, String message, Dialog.ModalityType modalityType) {
        JOptionPane jop = new JOptionPane(message, 3, 0);
        JDialog dialog = jop.createDialog(owner, title);
        dialog.setModalityType(modalityType);
        dialog.setVisible(true);
        Object selectedValue = jop.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return -1;
    }

    public static void errorMessage(Component owner, String title, String message) {
        GuiUtils.errorMessage(owner, title, message, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public static void errorMessage(Component owner, String title, String message, Dialog.ModalityType modalitytype) {
        JOptionPane jop = new JOptionPane(message, 0);
        JDialog dialog = jop.createDialog(owner, title);
        dialog.setModalityType(modalitytype);
        dialog.setVisible(true);
        NeptusLog.pub().error((Object)("[ErrorMessage] " + message));
    }

    public static void errorMessage(Component owner, Exception e) {
        ErrorMessageBox.showDialog(owner, e);
        NeptusLog.pub().error((Object)"Exception shown to the user", (Throwable)e);
    }

    public static void errorMessage(String title, String message) {
        GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), title, message);
    }

    public static JDialog htmlMessage(Component owner, String title, String subtitle, String htmlMessage) {
        return GuiUtils.htmlMessage(owner, title, subtitle, htmlMessage, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public static JDialog htmlMessage(Component owner, String title, String subtitle, String htmlMessage, Dialog.ModalityType modalityType) {
        BaseDialog myDialog = owner instanceof Frame ? new BaseDialog((Frame)owner) : new BaseDialog((Frame)SwingUtilities.getWindowAncestor(owner));
        JEditorPane editorPane = new JEditorPane("text/html", htmlMessage);
        editorPane.setEditable(false);
        myDialog.getContentPane().setLayout(new BorderLayout());
        myDialog.getContentPane().add(new JScrollPane(editorPane));
        editorPane.setCaretPosition(0);
        ((JButton)myDialog.getButtonPane().getComponent(0)).setMinimumSize(new Dimension(90, 25));
        ((JButton)myDialog.getButtonPane().getComponent(0)).setPreferredSize(new Dimension(90, 25));
        ((JButton)myDialog.getButtonPane().getComponent(0)).setText(I18n.text("OK"));
        myDialog.getButtonPane().remove(1);
        myDialog.setSize(500, 400);
        myDialog.setTitle(title);
        myDialog.getBanner().setTitle(title);
        myDialog.getBanner().setSubtitle(subtitle);
        myDialog.getBanner().setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        GuiUtils.centerOnScreen((Window)myDialog);
        myDialog.setModalityType(modalityType);
        myDialog.setVisible(true);
        return myDialog;
    }

    public static boolean generateCompositeScreenShot(Component parentComp, Component childComp) {
        Rectangle parentBounds = parentComp.getBounds();
        Rectangle childBounds = childComp.getBounds();
        Component rootParent = SwingUtilities.getRoot(parentComp);
        Component rootChild = SwingUtilities.getRoot(childComp);
        while (childComp != rootChild) {
            childComp = childComp.getParent();
            childBounds.x += childComp.getBounds().x;
            childBounds.y += childComp.getBounds().y;
        }
        while (parentComp != rootParent) {
            parentComp = parentComp.getParent();
            parentBounds.x += parentComp.getBounds().x;
            parentBounds.y += parentComp.getBounds().y;
        }
        File fx1 = new File(ConfigFetch.resolvePath("log"));
        File fx = new File(fx1.getAbsoluteFile() + "/images");
        fx.mkdirs();
        String outFileName = fx.getAbsolutePath() + "/" + new Date().getTime() + ".png";
        try {
            Robot robot = new Robot();
            BufferedImage parentImage = robot.createScreenCapture(parentBounds);
            robot = new Robot();
            BufferedImage childImage = robot.createScreenCapture(childBounds);
            Graphics2D g2d = (Graphics2D)parentImage.getGraphics();
            int parentWidth = parentImage.getWidth();
            int childWidth = childImage.getWidth();
            double scale = (double)parentWidth * 0.3 / (double)childWidth;
            int xpos = (int)((double)(parentImage.getWidth() - 10) - (double)childImage.getWidth() * scale);
            int ypos = (int)((double)(parentImage.getHeight() - 10) - (double)childImage.getHeight() * scale);
            AffineTransform trans = AffineTransform.getTranslateInstance(xpos, ypos);
            trans.scale(scale, scale);
            g2d.drawImage(childImage, trans, null);
            g2d.setColor(Color.black);
            g2d.drawRect(xpos, ypos, (int)((double)childImage.getWidth() * 0.3), (int)((double)childImage.getHeight() * 0.3));
            ImageIO.write((RenderedImage)parentImage, "png", new File(outFileName));
            NeptusLog.pub().info((Object)("Saved screen shot (" + parentImage.getWidth() + " x " + parentImage.getHeight() + " pixels) to file \"" + outFileName + "\"."));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"generateCompositeScreenShot()", (Throwable)e);
            return false;
        }
        NeptusLog.pub().info((Object)"Composite screen shot");
        return true;
    }

    public static void takeSnapshot(Component componentToGrab, String prefix) {
        String filename = GuiUtils.getLogFileName(prefix, "png");
        Rectangle rect = componentToGrab.getBounds();
        Component rootComp = SwingUtilities.getRoot(componentToGrab);
        while (componentToGrab != rootComp) {
            componentToGrab = componentToGrab.getParent();
            rect.x += componentToGrab.getBounds().x;
            rect.y += componentToGrab.getBounds().y;
        }
        Robot robot = null;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            NeptusLog.pub().error((Object)"error taking snapshot", (Throwable)e);
        }
        BufferedImage image = robot.createScreenCapture(rect);
        try {
            ImageIO.write((RenderedImage)image, "png", new File(filename));
            NeptusLog.pub().debug((Object)filename);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"error taking snapshot", (Throwable)e);
        }
    }

    public static String getLogFileName(String extension) {
        return GuiUtils.getLogFileName("", extension);
    }

    public static String getLogFileName(String prefix, String extension) {
        if (prefix == null) {
            prefix = "";
        }
        prefix = prefix.toLowerCase();
        File fx1 = new File("log");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        File fx = null;
        if (prefix.equalsIgnoreCase("sent_plans")) {
            fx = new File(fx1.getAbsoluteFile() + ConfigFetch.DS + "sent_rmf");
            fx.mkdirs();
        } else if (prefix.equalsIgnoreCase("mission_state") || prefix.equalsIgnoreCase("mission") || prefix.equalsIgnoreCase("mission_")) {
            fx = new File(fx1.getAbsoluteFile() + ConfigFetch.DS + "mission_state");
            fx.mkdirs();
            prefix = "mission_state";
        } else if (prefix.equalsIgnoreCase("output")) {
            fx = new File(fx1.getAbsoluteFile() + ConfigFetch.DS + "output");
            fx.mkdirs();
        } else {
            fx = new File(fx1.getAbsoluteFile() + ConfigFetch.DS + "images");
            fx.mkdirs();
        }
        return fx.getAbsolutePath() + ConfigFetch.DS + prefix + "-" + sdf.format(new Date()) + "." + extension;
    }

    public static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setLookAndFeel() {
        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new SkyBlue());
        try {
            UIManager.put("ClassLoader", LookUtils.class.getClass().getClassLoader());
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            NeptusLog.pub().info((Object)("<###> " + e.getMessage()));
            NeptusLog.pub().error((Object)("SetLookandFeel " + e.getMessage()));
        }
    }

    public static void setLookAndFeelNimbus() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                NeptusLog.pub().info((Object)("<###> " + info.getName()));
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static FileFilter getCustomFileFilter(String desc, String ... validExtensions) {
        final String d = desc;
        final String[] ext = validExtensions;
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String e : ext) {
                    if (!f.getName().toLowerCase().endsWith("." + e.toLowerCase()) && !e.equals("*")) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return d;
            }
        };
    }

    public static void reactEnterKeyPress(JButton btn) {
        btn.registerKeyboardAction(btn.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 2);
        btn.registerKeyboardAction(btn.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 2);
    }

    public static void reactEscapeKeyPress(JButton btn) {
        btn.registerKeyboardAction(btn.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(27, 0, false), 2);
        btn.registerKeyboardAction(btn.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(27, 0, true), 2);
    }

    public static void printArray(Object[] array) {
        if (array == null) {
            NeptusLog.pub().info((Object)("<###> " + array));
        }
        NeptusLog.pub().info((Object)("<###> " + array.getClass().getSimpleName() + "[" + array.length + "] {"));
        for (int i = 0; i < array.length; ++i) {
            NeptusLog.pub().info((Object)("<###>\t(" + i + ") " + array[i].toString()));
        }
        NeptusLog.pub().info((Object)"<###> }");
    }

    public static void printList(Collection<?> list) {
        if (list == null) {
            NeptusLog.pub().info((Object)("<###> " + list));
        }
        NeptusLog.pub().info((Object)("<###> " + list.getClass().getSimpleName() + "[" + list.size() + "] {"));
        int i = 0;
        for (Object litem : list) {
            NeptusLog.pub().info((Object)("<###>\t(" + i++ + ") [hash: " + Integer.toHexString(litem.hashCode()) + "] " + litem.toString()));
        }
        NeptusLog.pub().info((Object)"<###> }");
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = GuiUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static long callGC() {
        Runtime rt = Runtime.getRuntime();
        long before = rt.freeMemory();
        rt.gc();
        return rt.freeMemory() - before;
    }

    public static Image applyTransparency(Image original, float transparency) {
        BufferedImage img = new BufferedImage(original.getWidth(null), original.getHeight(null), 3);
        Graphics2D g = img.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, transparency));
        g.drawImage(original, 0, 0, null);
        g.dispose();
        return img;
    }

    public static boolean showInfoPopup(String title, String message) {
        if (SystemTray.isSupported()) {
            if (icon == null) {
                try {
                    icon = new TrayIcon(ImageUtils.getImage("images/neptus-icon.png"));
                    SystemTray.getSystemTray().add(icon);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            SystemTray.getSystemTray().remove(icon);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            icon.displayMessage(title, message, TrayIcon.MessageType.INFO);
            return true;
        }
        return false;
    }

    public static boolean showErrorPopup(String title, String message) {
        if (SystemTray.isSupported()) {
            if (icon == null) {
                icon = new TrayIcon(ImageUtils.getImage("images/neptus-icon.png"));
                try {
                    SystemTray.getSystemTray().add(icon);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            SystemTray.getSystemTray().remove(icon);
                        }
                    });
                }
                catch (Exception e) {
                    return false;
                }
            }
            icon.displayMessage(title, message, TrayIcon.MessageType.ERROR);
            return true;
        }
        return false;
    }

    public static ImageIcon getLetterIcon(Character letter, Color fgColor, Color bgColor, int size) {
        BufferedImage bi = new BufferedImage(size, size, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(bgColor);
        g2d.fill(new Ellipse2D.Double(1.0, 1.0, size - 2, size - 2));
        g2d.setStroke(new BasicStroke(0.5f));
        g2d.setColor(Color.black);
        g2d.draw(new Ellipse2D.Double(1.0, 1.0, size - 2, size - 2));
        g2d.setFont(new Font("Helvetica", 1, size));
        int width = g2d.getFontMetrics().charWidth(letter.charValue());
        g2d.setColor(new Color(0, 0, 0, 64));
        g2d.drawString(new String(new char[]{letter.charValue()}), (size - width) / 2 + 3, size - 1);
        g2d.drawString(new String(new char[]{letter.charValue()}), (size - width) / 2 + 2, size - 2);
        g2d.setColor(fgColor);
        g2d.drawString(new String(new char[]{letter.charValue()}), (size - width) / 2 + 1, size - 3);
        return new ImageIcon(bi);
    }

    public static boolean menuBarContainsMenu(JMenuBar bar, JMenu menu) {
        for (Component c : bar.getComponents()) {
            if (!(c instanceof JMenu) || !((JMenu)c).getText().equals(menu.getText())) continue;
            return true;
        }
        return false;
    }

    public static JMenu getJMenuByName(JMenuBar bar, String name) {
        for (Component c : bar.getComponents()) {
            if (!(c instanceof JMenu) || !((JMenu)c).getText().equals(name)) continue;
            return (JMenu)c;
        }
        return null;
    }

    public static Pair<String, String> askCredentials(Component parent, String title, String username, String password) {
        TableLayout tl = new TableLayout(new double[]{0.33, 0.67}, new double[]{0.5, 0.5});
        tl.setHGap(3);
        JPanel p = new JPanel(tl);
        JTextField login = new JTextField(username);
        JPasswordField pass = new JPasswordField(password);
        p.add((Component)new JLabel("login:"), "0,0");
        p.add((Component)login, "1,0");
        p.add((Component)new JLabel("password:"), "0,1");
        p.add((Component)pass, "1,1");
        int op = JOptionPane.showConfirmDialog(parent, p, title, 2, 3, ImageUtils.getIcon("images/key.png"));
        if (op == 2) {
            return null;
        }
        return new Pair<String, String>(login.getText(), new String(pass.getPassword()));
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + GuiUtils.getLogFileName("mission_state", "zip")));
    }
}

