/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import com.jhlabs.image.ContrastFilter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.PixelGrabber;
import java.awt.image.RescaleOp;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import pt.lsts.neptus.NeptusLog;

public class ImageUtils {
    public static Image getFasterScaledInstance(Image img, int targetWidth, int targetHeight) {
        return ImageUtils.getFasterScaledInstance(ImageUtils.toBufferedImage(img), targetWidth, targetHeight);
    }

    public static Image getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        BufferedImage img2;
        int type;
        int iw = img.getWidth();
        int ih = img.getHeight();
        Object hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        int n = type = img.getTransparency() == 1 ? 1 : 2;
        while (iw > targetWidth * 2 || ih > targetHeight * 2) {
            iw = iw > targetWidth * 2 ? iw / 2 : iw;
            ih = ih > targetHeight * 2 ? ih / 2 : ih;
            img = ImageUtils.scaleImage(img, type, hint, iw, ih);
        }
        if (iw > targetWidth) {
            int iw2 = iw / 2;
            img2 = ImageUtils.scaleImage(img, type, hint, iw2, ih);
            if (iw2 < targetWidth) {
                img = ImageUtils.scaleImage(img, type, hint, targetWidth, ih);
                img2 = ImageUtils.scaleImage(img2, type, hint, targetWidth, ih);
                ImageUtils.interp(img2, img, iw - targetWidth, targetWidth - iw2);
            }
            img = img2;
            iw = targetWidth;
        }
        if (ih > targetHeight) {
            int ih2 = ih / 2;
            img2 = ImageUtils.scaleImage(img, type, hint, iw, ih2);
            if (ih2 < targetHeight) {
                img = ImageUtils.scaleImage(img, type, hint, iw, targetHeight);
                img2 = ImageUtils.scaleImage(img2, type, hint, iw, targetHeight);
                ImageUtils.interp(img2, img, ih - targetHeight, targetHeight - ih2);
            }
            img = img2;
            ih = targetHeight;
        }
        if (iw < targetWidth && ih < targetHeight) {
            img = ImageUtils.scaleImage(img, type, hint, targetWidth, targetHeight);
        }
        return img;
    }

    private static BufferedImage scaleImage(BufferedImage orig, int type, Object hint, int w, int h) {
        BufferedImage tmp = new BufferedImage(w, h, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        g2.drawImage(orig, 0, 0, w, h, null);
        g2.dispose();
        return tmp;
    }

    private static void interp(BufferedImage img1, BufferedImage img2, int weight1, int weight2) {
        float alpha = weight1;
        Graphics2D g2 = img1.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(3, alpha /= (float)(weight1 + weight2)));
        g2.drawImage((Image)img2, 0, 0, null);
        g2.dispose();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        boolean hasAlpha = ImageUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            NeptusLog.waste().debug((Object)("[toBufferedImage] HeadlessException " + e.getMessage()));
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(width, height, transparency);
        }
        catch (HeadlessException e) {
            NeptusLog.waste().debug((Object)("[toBufferedImage] HeadlessException " + e.getMessage()));
        }
        if (bimage == null) {
            int type = 1;
            if (transparency != 1) {
                type = 2;
            }
            bimage = new BufferedImage(width, height, type);
        }
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    public static Image getImage(String imageURL) {
        ImageLoader loader = new ImageLoader(imageURL);
        if (loader.getImage() == null) {
            NeptusLog.pub().error((Object)("Image " + imageURL + " was not found!"));
        }
        return loader.getImage();
    }

    public static ImageIcon getIcon(String iconURL) {
        Image img = ImageUtils.getImage(iconURL);
        if (img != null) {
            return new ImageIcon(img);
        }
        return new ImageIcon(ImageUtils.getImage("images/menus/no.png"));
    }

    public static Image getImage(URL url) {
        Image img = Toolkit.getDefaultToolkit().createImage(url);
        return img;
    }

    public static ImageIcon getScaledIcon(Image img, int maxWidth, int maxHeight) {
        img = ImageUtils.getScaledImage(img, maxWidth, maxHeight, false);
        try {
            return new ImageIcon(img);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
            return new ImageIcon(ImageUtils.getImage("images/menus/no.png"));
        }
    }

    public static Image getScaledImage(String imagePath, int maxWidth, int maxHeight) {
        Image img = ImageUtils.getImage(imagePath);
        return ImageUtils.getScaledImage(img, maxWidth, maxHeight, false);
    }

    public static Image getScaledImage(Image originalImage, int maxWidth, int maxHeight, boolean mayDistort) {
        if (originalImage == null) {
            return null;
        }
        if (mayDistort) {
            return originalImage.getScaledInstance(maxWidth, maxHeight, 4);
        }
        if (originalImage.getWidth(null) < 0) {
            return originalImage.getScaledInstance(maxWidth, maxHeight, 4);
        }
        double imgRatio = (double)originalImage.getWidth(null) / (double)originalImage.getHeight(null);
        double desiredRatio = (double)maxWidth / (double)maxHeight;
        int width = maxWidth;
        int height = maxHeight;
        if (desiredRatio > imgRatio) {
            height = maxHeight;
            width = (int)((double)maxHeight * imgRatio);
        } else {
            width = maxWidth;
            height = (int)((double)maxWidth / imgRatio);
        }
        return originalImage.getScaledInstance(width, height, 4);
    }

    public static ImageIcon getScaledIcon(String imagePath, int maxWidth, int maxHeight) {
        Image img = ImageUtils.getImage(imagePath);
        img = ImageUtils.getScaledImage(img, maxWidth, maxHeight, false);
        return ImageUtils.getScaledIcon(img, maxWidth, maxHeight);
    }

    public static ImageIcon getScaledIcon(ImageIcon icon, int maxWidth, int maxHeight) {
        Image img = icon.getImage();
        img = ImageUtils.getScaledImage(img, maxWidth, maxHeight, false);
        return new ImageIcon(img);
    }

    public static Image getFastScaledImage(Image originalImage, int maxWidth, int maxHeight, boolean mayDistort) {
        if (originalImage == null) {
            return null;
        }
        if (mayDistort) {
            return ImageUtils.getFasterScaledInstance(originalImage, maxWidth, maxHeight);
        }
        if (originalImage.getWidth(null) < 0) {
            return ImageUtils.getFasterScaledInstance(originalImage, maxWidth, maxHeight);
        }
        double imgRatio = (double)originalImage.getWidth(null) / (double)originalImage.getHeight(null);
        double desiredRatio = (double)maxWidth / (double)maxHeight;
        int width = maxWidth;
        int height = maxHeight;
        if (desiredRatio > imgRatio) {
            height = maxHeight;
            width = (int)((double)maxHeight * imgRatio);
        } else {
            width = maxWidth;
            height = (int)((double)maxWidth / imgRatio);
        }
        return ImageUtils.getFasterScaledInstance(originalImage, width, height);
    }

    public static RescaleOp whiteBalanceOp(int r, int g, int b) {
        float rm = 255.0f / (float)r;
        float gm = 255.0f / (float)g;
        float bm = 255.0f / (float)b;
        return new RescaleOp(new float[]{rm, gm, bm}, new float[]{0.0f, 0.0f, 0.0f}, null);
    }

    public static RescaleOp colorizeOp(int r, int g, int b, int alpha) {
        return new RescaleOp(new float[]{1.0f, 1.0f, 1.0f}, new float[]{alpha - r, alpha - g, alpha - b}, null);
    }

    public static ConvolveOp sharpenOp() {
        float[] sharpenMatrix = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        return new ConvolveOp(new Kernel(3, 3, sharpenMatrix), 1, null);
    }

    public static ContrastFilter contrastOp() {
        ContrastFilter filter = new ContrastFilter();
        filter.setContrast(2.0f);
        filter.setBrightness(1.0f);
        return filter;
    }

    public static LookupOp invertOp() {
        byte[] invertArray = new byte[256];
        for (int counter = 0; counter < 256; ++counter) {
            invertArray[counter] = (byte)(255 - counter);
        }
        return new LookupOp(new ByteLookupTable(0, invertArray), null);
    }

    public static RescaleOp brightenOp(float mult, int add) {
        return new RescaleOp(mult, add, null);
    }

    public static ColorConvertOp grayscaleOp() {
        return new ColorConvertOp(ColorSpace.getInstance(1003), null);
    }

    public static void copySrcIntoDstAt(BufferedImage src, BufferedImage dst, int dx, int dy) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int width = src.getWidth();
        int height = src.getHeight();
        int dstoffs = dx + dy * dst.getWidth();
        int srcoffs = 0;
        int y = 0;
        while (y < height) {
            System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
            ++y;
            dstoffs += dst.getWidth();
            srcoffs += width;
        }
    }

    public static void copySrcIntoDst(BufferedImage src, BufferedImage dst, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int width = sw;
        int height = sh;
        int dstoffs = dx + dy * dw;
        int srcoffs = sx + sy * sw;
        int y = 0;
        while (y < height) {
            System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
            ++y;
            dstoffs += dst.getWidth();
            srcoffs += width;
        }
    }

    public static ImageIcon createImageIcon(String path) {
        URL location = ImageUtils.class.getClassLoader().getResource(path);
        if (location != null) {
            return new ImageIcon(location);
        }
        if (new File(path).exists()) {
            return new ImageIcon(path);
        }
        NeptusLog.waste().debug((Object)("[ImageLoader] Loading image " + location + " failed"));
        return null;
    }

    public static ImageIcon createScaleImageIcon(String path, int width, int height) {
        ImageIcon icon = ImageUtils.createImageIcon(path);
        if (icon != null) {
            Image img = ImageUtils.getFastScaledImage(icon.getImage(), width, height, false);
            icon.setImage(img);
            return icon;
        }
        return null;
    }

    private static class ImageLoader {
        Image image;

        public ImageLoader(String imageUrl) {
            if (imageUrl == null) {
                this.image = null;
                return;
            }
            try {
                this.image = new ImageIcon(this.getClass().getClassLoader().getResource(imageUrl)).getImage();
            }
            catch (Exception e) {
                this.image = new ImageIcon(imageUrl).getImage();
            }
            if (this.image == null) {
                NeptusLog.waste().debug((Object)("[ImageLoader] Loading image " + imageUrl + " failed"));
            } else {
                NeptusLog.waste().debug((Object)("[ImageLoader] Loading image " + imageUrl + " succeeded"));
            }
        }

        public Image getImage() {
            if (this.image == null) {
                return null;
            }
            if (this.image.getWidth(null) < 0) {
                return null;
            }
            return this.image;
        }
    }
}

