/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JComponent;

public class ListenerManager {
    private Vector<MouseListener> mouselisteners = new Vector();
    private Vector<MouseMotionListener> mousemotionlisteners = new Vector();
    private Vector<KeyListener> keyboardlisteners = new Vector();
    private Vector<ListenerManager> childs = new Vector();
    private JComponent component;

    public ListenerManager(JComponent comp) {
        this.setComponent(comp);
    }

    public void setComponent(JComponent comp) {
        this.component = comp;
        for (MouseListener mouseListener : this.component.getMouseListeners()) {
            this.mouselisteners.add(mouseListener);
        }
        for (EventListener eventListener : this.component.getMouseMotionListeners()) {
            this.mousemotionlisteners.add((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.component.getKeyListeners()) {
            this.keyboardlisteners.add((KeyListener)eventListener);
        }
        for (Component component : this.component.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.childs.add(new ListenerManager((JComponent)component));
        }
    }

    public void turnoff() {
        for (Object ml : this.mouselisteners.toArray()) {
            this.component.removeMouseListener((MouseListener)ml);
        }
        for (Object mml : this.mousemotionlisteners.toArray()) {
            this.component.removeMouseMotionListener((MouseMotionListener)mml);
        }
        for (Object kl : this.keyboardlisteners.toArray()) {
            this.component.removeKeyListener((KeyListener)kl);
        }
        for (Object child : this.childs.toArray()) {
            if (!(child instanceof ListenerManager)) continue;
            ((ListenerManager)child).turnoff();
        }
    }

    public void turnon() {
        for (Object ml : this.mouselisteners.toArray()) {
            this.component.addMouseListener((MouseListener)ml);
        }
        for (Object mml : this.mousemotionlisteners.toArray()) {
            this.component.addMouseMotionListener((MouseMotionListener)mml);
        }
        for (Object kl : this.keyboardlisteners.toArray()) {
            this.component.addKeyListener((KeyListener)kl);
        }
        for (Object child : this.childs.toArray()) {
            if (!(child instanceof ListenerManager)) continue;
            ((ListenerManager)child).turnon();
        }
    }
}

