/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.AngleCalc;

public class MathMiscUtils {
    public static double round(double val, int decimalHouses) {
        double base = Math.pow(10.0, decimalHouses);
        double result = (double)Math.round(val * base) / base;
        return result;
    }

    public static float round(float val, int decimalHouses) {
        float base = (float)Math.pow(10.0, decimalHouses);
        float result = (float)Math.round(val * base) / base;
        return result;
    }

    public static double pointLineDistance(double px, double py, double lx1, double ly1, double lx2, double ly2) {
        double up = Math.abs((lx2 - lx1) * (ly1 - py) - (lx1 - px) * (ly2 - ly1));
        double below = Math.sqrt((lx2 - lx1) * (lx2 - lx1) + (ly2 - ly1) * (ly2 - ly1));
        return up / below;
    }

    public static double pointLineDistance(Point2D point, Line2D line) {
        return MathMiscUtils.pointLineDistance(point.getX(), point.getY(), line.getX1(), line.getY1(), line.getX2(), line.getY2());
    }

    public static double[] calcCentroidPolygonPoint(ArrayList<Point> polyPoints) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Point point : polyPoints) {
            Point2D.Double point2d = new Point2D.Double(point.getX(), point.getY());
            points.add(point2d);
        }
        return MathMiscUtils.calcCentroidPolygon(points);
    }

    public static double[] calcCentroidPolygon(ArrayList<Point2D> polyPoints) {
        double sumX = 0.0;
        double sumY = 0.0;
        for (Point2D dp : polyPoints) {
            sumX += dp.getX();
            sumY += dp.getY();
        }
        double cX = sumX / (double)polyPoints.size();
        double cY = sumY / (double)polyPoints.size();
        return new double[]{cX, cY};
    }

    public static ArrayList<Point> dilatePolygonPoint(ArrayList<Point> polyPoints, double growByValue) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Point point : polyPoints) {
            Point2D.Double point2d = new Point2D.Double(point.getX(), point.getY());
            points.add(point2d);
        }
        ArrayList<Point2D> ret = MathMiscUtils.dilatePolygon(points, growByValue);
        ArrayList<Point> pointsRet = new ArrayList<Point>();
        for (Point2D point2d : ret) {
            Point point = new Point(Double.valueOf(point2d.getX()).intValue(), Double.valueOf(point2d.getY()).intValue());
            pointsRet.add(point);
        }
        return pointsRet;
    }

    public static ArrayList<Point2D> dilatePolygon(ArrayList<Point2D> polyPoints, double growByValue) {
        ArrayList<Point2D> pointsGrow = new ArrayList<Point2D>();
        double[] centroid = MathMiscUtils.calcCentroidPolygon(polyPoints);
        double cX = centroid[0];
        double cY = centroid[1];
        for (Point2D dp : polyPoints) {
            Point2D.Double np = new Point2D.Double();
            double ang = AngleCalc.calcAngle(dp.getX(), dp.getY(), cX, cY);
            double dist = Math.sqrt((dp.getX() - cX) * (dp.getX() - cX) + (dp.getY() - cY) * (dp.getY() - cY));
            double[] rotD = AngleCalc.rotate(ang + 1.5707963267948966, dist + growByValue, 0.0, true);
            ((Point2D)np).setLocation(cX + rotD[0], cY + rotD[1]);
            pointsGrow.add(np);
        }
        return pointsGrow;
    }

    public static String parseToEngineeringNotation(double val, int decimalHouses) {
        DecimalFormat engNot = new DecimalFormat("##0.###E0");
        String pl = engNot.format(val);
        String[] pl2 = pl.split("E");
        double vl = Double.parseDouble(pl2[0].replace(',', '.'));
        vl = MathMiscUtils.round(vl, decimalHouses);
        int mul = Integer.parseInt(pl2[1]);
        String mulStr = "";
        switch (mul) {
            case 24: {
                mulStr = "Y";
                break;
            }
            case 21: {
                mulStr = "Z";
                break;
            }
            case 18: {
                mulStr = "E";
                break;
            }
            case 15: {
                mulStr = "P";
                break;
            }
            case 12: {
                mulStr = "T";
                break;
            }
            case 9: {
                mulStr = "G";
                break;
            }
            case 6: {
                mulStr = "M";
                break;
            }
            case 3: {
                mulStr = "k";
                break;
            }
            case -3: {
                mulStr = "m";
                break;
            }
            case -6: {
                mulStr = "u";
                mulStr = "\u00b5";
                break;
            }
            case -9: {
                mulStr = "n";
                break;
            }
            case -12: {
                mulStr = "p";
                break;
            }
            case -15: {
                mulStr = "f";
                break;
            }
            case -18: {
                mulStr = "a";
                break;
            }
            case -21: {
                mulStr = "z";
                break;
            }
            case -24: {
                mulStr = "y";
                break;
            }
            default: {
                mulStr = "";
            }
        }
        return (decimalHouses == 0 ? (long)vl + "" : Double.valueOf(vl)) + mulStr;
    }

    public static double parseEngineeringModeToDouble(String engValue) {
        double doubleValue = Double.NaN;
        String delim = "YZEPTGMkmu\u00b5npfazy";
        if (engValue == null) {
            return Double.NaN;
        }
        if (engValue.equalsIgnoreCase("")) {
            return Double.NaN;
        }
        StringTokenizer strt = new StringTokenizer(engValue, delim);
        StringTokenizer strtTkn = new StringTokenizer(engValue, delim, true);
        if (strt.countTokens() != 1 || strtTkn.countTokens() > strt.countTokens() + 1) {
            return Double.NaN;
        }
        int i = 1;
        while (strtTkn.hasMoreTokens()) {
            if (i == 1) {
                try {
                    doubleValue = Double.parseDouble(strtTkn.nextToken());
                }
                catch (NumberFormatException e) {
                    return Double.NaN;
                }
            } else {
                String multiplierStr = strtTkn.nextToken();
                double multiplier = MathMiscUtils.getEngMultiplier(multiplierStr);
                doubleValue *= multiplier;
            }
            ++i;
        }
        return doubleValue;
    }

    private static double getEngMultiplier(String multiplierStr) {
        double multiplier = 1.0;
        if (multiplierStr.length() != 1) {
            return 1.0;
        }
        char key = multiplierStr.charAt(0);
        switch (key) {
            case 'Y': {
                multiplier = 1.0E24;
                break;
            }
            case 'Z': {
                multiplier = 1.0E21;
                break;
            }
            case 'E': {
                multiplier = 1.0E18;
                break;
            }
            case 'P': {
                multiplier = 1.0E15;
                break;
            }
            case 'T': {
                multiplier = 1.0E12;
                break;
            }
            case 'G': {
                multiplier = 1.0E9;
                break;
            }
            case 'M': {
                multiplier = 1000000.0;
                break;
            }
            case 'k': {
                multiplier = 1000.0;
                break;
            }
            case 'm': {
                multiplier = 0.001;
                break;
            }
            case 'u': 
            case '\u00b5': {
                multiplier = 1.0E-6;
                break;
            }
            case 'n': {
                multiplier = 1.0E-9;
                break;
            }
            case 'p': {
                multiplier = 1.0E-12;
                break;
            }
            case 'f': {
                multiplier = 1.0E-15;
                break;
            }
            case 'a': {
                multiplier = 1.0E-18;
                break;
            }
            case 'z': {
                multiplier = 1.0E-21;
                break;
            }
            case 'y': {
                multiplier = 1.0E-24;
                break;
            }
            default: {
                multiplier = 1.0;
            }
        }
        return multiplier;
    }

    public static String parseToEngineeringRadix2Notation(double val, int decimalHouses) {
        double valTmp;
        int mulTmp = 0;
        int signal = 1;
        signal = val < 0.0 ? -1 : 1;
        double d = valTmp = val < 0.0 ? val * -1.0 : val;
        if (val >= 1024.0) {
            while ((valTmp /= 1024.0) >= 1024.0 || ++mulTmp == 8) {
            }
        } else if (val != 0.0 && val < 1.0) {
            while ((valTmp *= 1024.0) < 1.0 || --mulTmp == -8) {
            }
        }
        double vl = valTmp;
        vl = MathMiscUtils.round(vl, decimalHouses);
        int mul = mulTmp * 10;
        String mulStr = "";
        switch (mul) {
            case 80: {
                mulStr = "Yi";
                break;
            }
            case 70: {
                mulStr = "Zi";
                break;
            }
            case 60: {
                mulStr = "Ei";
                break;
            }
            case 50: {
                mulStr = "Pi";
                break;
            }
            case 40: {
                mulStr = "Ti";
                break;
            }
            case 30: {
                mulStr = "Gi";
                break;
            }
            case 20: {
                mulStr = "Mi";
                break;
            }
            case 10: {
                mulStr = "Ki";
                break;
            }
            case -10: {
                mulStr = "mi";
                break;
            }
            case -20: {
                mulStr = "ui";
                mulStr = "\u00b5i";
                break;
            }
            case -30: {
                mulStr = "ni";
                break;
            }
            case -40: {
                mulStr = "pi";
                break;
            }
            case -50: {
                mulStr = "fi";
                break;
            }
            case -60: {
                mulStr = "ai";
                break;
            }
            case -70: {
                mulStr = "zi";
                break;
            }
            case -80: {
                mulStr = "yi";
                break;
            }
            default: {
                mulStr = "";
            }
        }
        if ("".equalsIgnoreCase(mulStr) && vl < 1024.0 && vl == (double)((long)vl)) {
            return (signal > 0 ? "" : "-") + (long)vl + mulStr;
        }
        return (signal > 0 ? "" : "-") + vl + mulStr;
    }

    public static double parseEngineeringRadix2ModeToDouble(String engValue) {
        double doubleValue = Double.NaN;
        String delim = "YZEPTGMKkmu\u00b5npfazyi";
        if (engValue == null) {
            return Double.NaN;
        }
        if (engValue.equalsIgnoreCase("")) {
            return Double.NaN;
        }
        StringTokenizer strt = new StringTokenizer(engValue, delim);
        StringTokenizer strtTkn = new StringTokenizer(engValue, delim, true);
        if (strt.countTokens() != 1 || strtTkn.countTokens() > strt.countTokens() + 2) {
            return Double.NaN;
        }
        int i = 1;
        while (strtTkn.hasMoreTokens()) {
            if (i == 1) {
                try {
                    doubleValue = Double.parseDouble(strtTkn.nextToken());
                }
                catch (NumberFormatException e) {
                    return Double.NaN;
                }
            } else {
                String multiplierStr = strtTkn.nextToken();
                if (strtTkn.hasMoreTokens()) {
                    multiplierStr = multiplierStr + strtTkn.nextToken();
                }
                double multiplier = MathMiscUtils.getEngRadix2Multiplier(multiplierStr);
                doubleValue *= multiplier;
            }
            ++i;
        }
        return doubleValue;
    }

    private static double getEngRadix2Multiplier(String multiplierStr) {
        double multiplier = 1.0;
        if (multiplierStr.length() != 2) {
            return 1.0;
        }
        char key = multiplierStr.charAt(0);
        char keyI = multiplierStr.charAt(1);
        if (keyI != 'i') {
            return 1.0;
        }
        switch (key) {
            case 'Y': {
                multiplier = Math.pow(1024.0, 8.0);
                break;
            }
            case 'Z': {
                multiplier = Math.pow(1024.0, 7.0);
                break;
            }
            case 'E': {
                multiplier = Math.pow(1024.0, 6.0);
                break;
            }
            case 'P': {
                multiplier = Math.pow(1024.0, 5.0);
                break;
            }
            case 'T': {
                multiplier = Math.pow(1024.0, 4.0);
                break;
            }
            case 'G': {
                multiplier = Math.pow(1024.0, 3.0);
                break;
            }
            case 'M': {
                multiplier = Math.pow(1024.0, 2.0);
                break;
            }
            case 'K': 
            case 'k': {
                multiplier = 1024.0;
                break;
            }
            case 'm': {
                multiplier = Math.pow(1024.0, -1.0);
                break;
            }
            case 'u': 
            case '\u00b5': {
                multiplier = Math.pow(1024.0, -2.0);
                break;
            }
            case 'n': {
                multiplier = Math.pow(1024.0, -3.0);
                break;
            }
            case 'p': {
                multiplier = Math.pow(1024.0, -4.0);
                break;
            }
            case 'f': {
                multiplier = Math.pow(1024.0, -5.0);
                break;
            }
            case 'a': {
                multiplier = Math.pow(1024.0, -6.0);
                break;
            }
            case 'z': {
                multiplier = Math.pow(1024.0, -7.0);
                break;
            }
            case 'y': {
                multiplier = Math.pow(1024.0, -8.0);
                break;
            }
            default: {
                multiplier = 1.0;
            }
        }
        return multiplier;
    }

    public static double filterDeadZone(double xx, double deadZone, double maxValue) {
        if (deadZone >= maxValue) {
            return Double.NaN;
        }
        double slope = maxValue / (maxValue - deadZone);
        double bb = -(slope * maxValue - maxValue);
        double yy = 0.0;
        yy = xx < deadZone && xx > -deadZone ? 0.0 : (xx > 0.0 ? slope * xx + bb : slope * xx - bb);
        return yy;
    }

    public static double filterDeadZone(double xx, double deadZone) {
        return MathMiscUtils.filterDeadZone(xx, deadZone, 1.0);
    }

    public static float filterDeadZone(float xx, float deadZone, float maxValue) {
        double xxD = Double.parseDouble("" + xx);
        double deadZoneD = Double.parseDouble("" + deadZone);
        double maxValueD = Double.parseDouble("" + maxValue);
        double yyD = MathMiscUtils.filterDeadZone(xxD, deadZoneD, maxValueD);
        float yyF = Double.valueOf(yyD).floatValue();
        return yyF;
    }

    public static float filterDeadZone(float xx, float deadZone) {
        return MathMiscUtils.filterDeadZone(xx, deadZone, 1.0f);
    }

    public static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseEngineeringModeToDouble("10M")));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseToEngineeringNotation(3.0E-6, 2)));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseToEngineeringNotation(3.56, 0) + "=4"));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseToEngineeringNotation(3.56, 1) + "=3.6"));
        if (MathMiscUtils.parseEngineeringModeToDouble("100M") > MathMiscUtils.parseEngineeringModeToDouble("10M")) {
            NeptusLog.pub().info((Object)"<###>Hello");
        } else {
            NeptusLog.pub().info((Object)"<###>Nops");
        }
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseToEngineeringRadix2Notation(1887115.0, 1) + "=1.8Mi"));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseEngineeringRadix2ModeToDouble("1.79969310760498046875Mi") + "=1887115.0"));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseToEngineeringRadix2Notation(876.0, 1) + "=876"));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseToEngineeringRadix2Notation(0.0, 1) + "=0"));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseEngineeringRadix2ModeToDouble("1ki")));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseEngineeringRadix2ModeToDouble("1Ki")));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseEngineeringRadix2ModeToDouble("1Mi")));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseEngineeringRadix2ModeToDouble("1\u00b5i")));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.parseEngineeringRadix2ModeToDouble("1ui")));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.round(Math.PI, 2)));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.round(Math.PI, 1)));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.round(Math.PI, 0)));
        NeptusLog.pub().info((Object)("<###> " + MathMiscUtils.clamp(41.0, 50.0, 100.0)));
    }
}

