/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.util.ArrayList;
import pt.lsts.neptus.NeptusLog;

public class MovingAverage {
    private double accum = 0.0;
    private short windowSize = 0;
    private ArrayList<Double> window = new ArrayList();
    private int oldest = 0;

    public MovingAverage(short windowSize) {
        this.windowSize = windowSize < 1 ? (short)1 : windowSize;
        this.clear();
    }

    public void clear() {
        this.accum = 0.0;
        this.oldest = 0;
        this.window.clear();
    }

    public double update(double value) {
        if (this.window.size() < this.windowSize) {
            this.window.add(value);
            this.accum += value;
            return this.accum / (double)this.window.size();
        }
        this.accum += value - this.window.get(this.oldest);
        this.window.remove(this.oldest);
        this.window.add(this.oldest, value);
        this.oldest = (this.oldest + 1) % this.windowSize;
        return this.accum / (double)this.windowSize;
    }

    public double mean() {
        if (this.window.size() > 0) {
            return this.accum / (double)this.window.size();
        }
        return 0.0;
    }

    public double stdev() {
        int size = this.window.size();
        if (size == 0) {
            return 0.0;
        }
        double sdev = 0.0;
        double u = this.mean();
        for (int i = 0; i < size; ++i) {
            sdev += (this.window.get(i) - u) * (this.window.get(i) - u);
        }
        return Math.sqrt(sdev / (double)size);
    }

    public String toString() {
        return "mean=" + this.mean() + "    \t\t stdev=" + this.stdev() + "         \t" + this.window;
    }

    public static void main(String[] args) {
        MovingAverage ma = new MovingAverage(5);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(2.0);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(2.3);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(5.1);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(1.2);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(4.0);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(3.2);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(10.3);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(30.2);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(2.0);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(4.3);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(2.4);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(32.0);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(12.0);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(3.4);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
        ma.update(2.3);
        NeptusLog.pub().info((Object)("<###>mean=" + ma.mean() + "\t\t    stdev=" + ma.stdev() + "         " + ma.window));
    }
}

