/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import org.dinopolis.gpstool.gpsinput.nmea.NMEA0183Sentence;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCMessageType;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.types.coord.LocationType;

public class NMEAUtils {
    private static LinkedHashMap<String, Integer> gps_uids = new LinkedHashMap();
    private static IMCMessage gpsFix = IMCDefinition.getInstance().create("GpsFix", new Object[0]);
    private static IMCMessage customMessage = null;
    private static boolean isExtGpsFix = true;

    public NMEAUtils() {
        if (gpsFix != null) {
            isExtGpsFix = gpsFix.getMessageType().getFieldType("validity") != null;
        }
    }

    public static IMCMessage getCustomMessage() {
        if (customMessage == null) {
            IMCMessageType type = new IMCMessageType();
            type.addField("id", "plaintext", null, null, null);
            type.addField("home_lat", "fp64_t", "rad", null, null);
            type.addField("home_lon", "fp64_t", "rad", null, null);
            type.addField("x", "fp32_t", "meter", null, null);
            type.addField("y", "fp32_t", "meter", null, null);
            type.addField("z", "fp32_t", "meter", null, null);
            customMessage = new IMCMessage(type);
        }
        return customMessage;
    }

    public static void logGGASentenceAsGpsFix(String source, String ggaSentence) {
        try {
            NMEA0183Sentence nmea = new NMEA0183Sentence(ggaSentence);
            if (!nmea.isValid()) {
                return;
            }
            List data_fields = nmea.getDataFields();
            int time = (int)Float.parseFloat((String)data_fields.get(0));
            String latitude = (String)data_fields.get(1);
            String north_south = (String)data_fields.get(2);
            String longitude = (String)data_fields.get(3);
            String east_west = (String)data_fields.get(4);
            int valid_fix = Integer.parseInt((String)data_fields.get(5));
            int num_satellites = Integer.parseInt((String)data_fields.get(6));
            float hor_dilution = Float.parseFloat((String)data_fields.get(7));
            float altitude = Float.parseFloat((String)data_fields.get(8));
            double wgs84_lat = NMEAUtils.nmeaLatOrLongToWGS84(latitude);
            double wgs84_long = NMEAUtils.nmeaLatOrLongToWGS84(longitude);
            if (north_south.equalsIgnoreCase("S")) {
                wgs84_lat = -wgs84_lat;
            }
            if (east_west.equalsIgnoreCase("W")) {
                wgs84_long = -wgs84_long;
            }
            int uid = 0;
            if (gps_uids.containsKey(source)) {
                uid = gps_uids.get(source);
            } else {
                uid = gps_uids.size();
                gps_uids.put(source, uid);
            }
            gpsFix.setValue("id", (Object)uid);
            gpsFix.setValue("time", (Object)time);
            gpsFix.setValue("lat", (Object)Math.toRadians(new Double(wgs84_lat)));
            gpsFix.setValue("lon", (Object)Math.toRadians(new Double(wgs84_long)));
            if (isExtGpsFix) {
                int valitity = (valid_fix > 0 ? 4 : 0) | 0x80;
                gpsFix.setValue("validity", (Object)valitity);
                gpsFix.setValue("height", (Object)Float.valueOf(altitude));
                gpsFix.setValue("hdop", (Object)Float.valueOf(hor_dilution));
            } else {
                gpsFix.setValue("fix_quality", (Object)(valid_fix > 0 ? 1 : 0));
                gpsFix.setValue("altitude", (Object)Float.valueOf(altitude));
                gpsFix.setValue("hdilution", (Object)Float.valueOf(hor_dilution));
            }
            gpsFix.setValue("satellites", (Object)num_satellites);
            gpsFix.setSrc(ImcId16.NULL_ID.intValue());
            LsfMessageLogger.log((IMCMessage)gpsFix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void convertGGALogToLLF(File source, File dest) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(source));
        String line = reader.readLine();
        while (line != null) {
            NMEAUtils.logGGASentenceAsGpsFix(source.getName(), line);
        }
        reader.close();
    }

    public static String nmeaType(String sentence) {
        return sentence.trim().split(",")[0];
    }

    public static double nmeaLatOrLongToWGS84(String nmea_pos) throws NumberFormatException {
        int comma_pos = nmea_pos.indexOf(46);
        if (comma_pos != 4 && comma_pos != 5) {
            throw new NumberFormatException("unknown NMEA position format: '" + nmea_pos + "'");
        }
        String wgs84_deg = nmea_pos.substring(0, comma_pos - 2);
        String wgs84_min = nmea_pos.substring(comma_pos - 2);
        double wgs84_pos = Double.parseDouble(wgs84_deg) + Double.parseDouble(wgs84_min) / 60.0;
        return wgs84_pos;
    }

    public static LocationType processGGASentence(String sentence) {
        try {
            NMEA0183Sentence nmea = new NMEA0183Sentence(sentence);
            if (!nmea.isValid()) {
                return null;
            }
            List data_fields = nmea.getDataFields();
            String latitude = (String)data_fields.get(1);
            String north_south = (String)data_fields.get(2);
            String longitude = (String)data_fields.get(3);
            String east_west = (String)data_fields.get(4);
            int valid_fix = Integer.parseInt((String)data_fields.get(5));
            if (valid_fix == 0) {
                return null;
            }
            if (latitude.length() == 0) {
                return null;
            }
            double wgs84_lat = NMEAUtils.nmeaLatOrLongToWGS84(latitude);
            double wgs84_long = NMEAUtils.nmeaLatOrLongToWGS84(longitude);
            if (north_south.equalsIgnoreCase("S")) {
                wgs84_lat = -wgs84_lat;
            }
            if (east_west.equalsIgnoreCase("W")) {
                wgs84_long = -wgs84_long;
            }
            LocationType loc = new LocationType();
            loc.setLatitudeDegs(wgs84_lat);
            loc.setLongitudeDegs(wgs84_long);
            loc.setDepth(-new Float((String)data_fields.get(8)).floatValue());
            return loc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static LocationType processRMCSentence(String sentence) {
        try {
            NMEA0183Sentence nmea = new NMEA0183Sentence(sentence);
            if (!nmea.isValid()) {
                return null;
            }
            List data_fields = nmea.getDataFields();
            String latitude = (String)data_fields.get(2);
            String north_south = (String)data_fields.get(3);
            String longitude = (String)data_fields.get(4);
            String east_west = (String)data_fields.get(5);
            if (latitude.length() == 0) {
                return null;
            }
            double wgs84_lat = NMEAUtils.nmeaLatOrLongToWGS84(latitude);
            double wgs84_long = NMEAUtils.nmeaLatOrLongToWGS84(longitude);
            if (north_south.equalsIgnoreCase("S")) {
                wgs84_lat = -wgs84_lat;
            }
            if (east_west.equalsIgnoreCase("W")) {
                wgs84_long = -wgs84_long;
            }
            LocationType loc = new LocationType();
            loc.setLatitudeDegs(wgs84_lat);
            loc.setLongitudeDegs(wgs84_long);
            return loc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String nmea = "$GPGGA,120602.476,4112.4827,N,00832.0861,W,1,03,3.4,-51.3,M,51.3,M,,0000*5C";
        LocationType lt = NMEAUtils.processGGASentence(nmea);
        NeptusLog.pub().info((Object)("<###> " + lt.getDebugString()));
        if (lt != null) {
            IMCMessage msg = IMCDefinition.getInstance().create("RemoteSensorInfo", new Object[0]);
            msg.setValue("id", (Object)"914785889");
            msg.setValue("lat", (Object)lt.getLatitudeDegs());
            msg.setValue("lon", (Object)lt.getLongitudeDegs());
            msg.setValue("alt", (Object)(-lt.getDepth()));
            msg.setValue("heading", (Object)0);
            msg.setValue("data", (Object)"");
            msg.setValue("sensor_class", (Object)"auv");
            msg.dump((OutputStream)System.out);
        }
        NMEAUtils.logGGASentenceAsGpsFix("+351914785889", nmea);
        NMEAUtils.logGGASentenceAsGpsFix("+351914785889", nmea);
        NMEAUtils.logGGASentenceAsGpsFix("+351914785887", nmea);
        NMEAUtils.logGGASentenceAsGpsFix("+351914785889", nmea);
    }
}

