/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.util.GregorianCalendar;
import java.util.Random;

public class NameNormalizer {
    private static Random rnd = new Random(System.currentTimeMillis());

    public static String asIdentifier(String text) {
        if (text == null || text.length() == 0) {
            GregorianCalendar cal = new GregorianCalendar();
            return "id" + String.valueOf(cal.getTimeInMillis());
        }
        char[] letters = text.toCharArray();
        if (!Character.isJavaIdentifierStart(letters[0])) {
            text = "id" + text;
            letters = text.toCharArray();
        }
        for (int i = 1; i < letters.length; ++i) {
            if (Character.isJavaIdentifierPart(letters[i])) continue;
            letters[i] = Character.isSpaceChar(letters[i]) ? 95 : 88;
        }
        return new String(letters);
    }

    public static boolean isNeptusIdentifierStart(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        return c == '_';
    }

    public static boolean isNeptusIdentifierPart(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        switch (c) {
            case '_': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case ':': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNeptusValidIdentifier(String identifier) {
        if (identifier.length() < 1) {
            return false;
        }
        if (!NameNormalizer.isNeptusIdentifierStart(identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (NameNormalizer.isNeptusIdentifierPart(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getRandomID() {
        return NameNormalizer.getRandomID("id");
    }

    public static String getRandomID(String prefix) {
        StringBuilder builder = new StringBuilder(9);
        builder.append(prefix);
        builder.append("_");
        int val = Math.abs(rnd.nextInt());
        builder.append(Integer.toString(val, 36));
        return builder.toString();
    }

    public static void main(String[] args) {
        System.out.println(NameNormalizer.getRandomID());
    }
}

