/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;

public class NetworkInterfacesUtil {
    public static final boolean testForReachability(String host) {
        return NetworkInterfacesUtil.testForReachability(host, 6002);
    }

    public static final boolean testForReachability(String host, int port) {
        InetAddress ii = new InetSocketAddress(host, port).getAddress();
        boolean result = false;
        try {
            result = ii.isReachable(2000);
        }
        catch (IOException e) {
            result = false;
        }
        if (!result) {
            try {
                Socket sock = new Socket(host, port);
                result = sock.isConnected();
                if (result) {
                    sock.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static Vector<NInterface> getNetworkInterfaces() {
        Vector<NInterface> list = new Vector<NInterface>();
        try {
            Enumeration<NetworkInterface> nintf = NetworkInterface.getNetworkInterfaces();
            while (nintf.hasMoreElements()) {
                NetworkInterface ni = nintf.nextElement();
                if (!ni.isUp()) continue;
                list.add(new NInterface(ni));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void main(String[] args) {
        try {
            Enumeration<NetworkInterface> nintf = NetworkInterface.getNetworkInterfaces();
            while (nintf.hasMoreElements()) {
                NetworkInterface ni = nintf.nextElement();
                if (!ni.isUp()) continue;
                NeptusLog.pub().info((Object)("<###>>>>>  " + ni));
                NeptusLog.pub().info((Object)("<###>      isLoopback " + ni.isLoopback()));
                NeptusLog.pub().info((Object)("<###>      isPointToPoint " + ni.isPointToPoint()));
                NeptusLog.pub().info((Object)("<###>      multicast " + ni.supportsMulticast()));
                NeptusLog.pub().info((Object)("<###>      virtual " + ni.isVirtual()));
                NeptusLog.pub().info((Object)("<###>      mtu " + ni.getMTU()));
                NeptusLog.pub().info((Object)("<###>      n addresses " + ni.getInterfaceAddresses().size()));
                Enumeration<InetAddress> iadde = ni.getInetAddresses();
                while (iadde.hasMoreElements()) {
                    InetAddress inetAddress = iadde.nextElement();
                    NeptusLog.pub().info((Object)("<###>:            " + inetAddress.getHostAddress()));
                }
                NeptusLog.pub().info((Object)("<###>      InterfaceAddresses:" + ni.getInterfaceAddresses()));
                for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                    NeptusLog.pub().info((Object)("<###>            Host:" + ia.getAddress().getHostAddress() + " Broadcast:" + (ia.getBroadcast() != null ? ia.getBroadcast().getHostAddress() : "") + " NetworkPrefixLength:" + ia.getNetworkPrefixLength()));
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        InetAddress ii = new InetSocketAddress("192.168.106.30", 6002).getAddress();
        try {
            NeptusLog.pub().info((Object)("<###> " + ii.isReachable(2000)));
            ii = new InetSocketAddress("192.168.56.2", 6002).getAddress();
            NeptusLog.pub().info((Object)("<###> " + ii.isReachable(2000)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class NInterface {
        private String name = "";
        private String displayName = "";
        private boolean loopback = false;
        private boolean pointToPoint = false;
        private boolean supportsMulticast = false;
        private boolean supportsBroadcast = false;
        private boolean virtual = false;
        private int mtu = -1;
        private Vector<Inet4Address> addresses = new Vector();
        private Vector<Inet4Address> broadcastAddresses = new Vector();
        private Vector<Inet6Address> addresses6 = new Vector();
        private String stringDesc;

        public NInterface(NetworkInterface ni) {
            this.name = ni.getName();
            this.displayName = ni.getDisplayName();
            try {
                this.loopback = ni.isLoopback();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            try {
                this.pointToPoint = ni.isPointToPoint();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            try {
                this.supportsMulticast = ni.supportsMulticast();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            this.virtual = this.isVirtual();
            try {
                this.mtu = ni.getMTU();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            this.stringDesc = ni.toString();
            for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                try {
                    Inet4Address address = (Inet4Address)ia.getAddress();
                    Inet4Address broadcastAddress = (Inet4Address)ia.getBroadcast();
                    if (address == null) continue;
                    this.addresses.add(address);
                    this.broadcastAddresses.add(broadcastAddress);
                    this.supportsBroadcast = this.supportsBroadcast || broadcastAddress != null;
                }
                catch (Exception e) {
                    try {
                        Inet6Address address6 = (Inet6Address)ia.getAddress();
                        if (address6 == null) continue;
                        this.addresses6.add(address6);
                    }
                    catch (Exception e2) {}
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isLoopback() {
            return this.loopback;
        }

        public boolean isPointToPoint() {
            return this.pointToPoint;
        }

        public boolean supportsMulticast() {
            return this.supportsMulticast;
        }

        public boolean supportsBroadcast() {
            return this.supportsBroadcast;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public int getMtu() {
            return this.mtu;
        }

        public Inet4Address[] getAddress() {
            return this.addresses.toArray(new Inet4Address[this.addresses.size()]);
        }

        public Inet4Address[] getBroadcastAddress() {
            return this.broadcastAddresses.toArray(new Inet4Address[this.broadcastAddresses.size()]);
        }

        public Inet6Address[] getAddress6() {
            return this.addresses6.toArray(new Inet6Address[this.addresses6.size()]);
        }

        public String toString() {
            return this.stringDesc;
        }

        public boolean hasIpv4Address() {
            return this.addresses.size() > 0;
        }

        public boolean hasIpv6Address() {
            return this.addresses6.size() > 0;
        }
    }
}

