/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.console.plugins.BlinkStatusLed;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class PeriodicSnapshotWorker {
    protected Timer runner = null;
    protected TimerTask ttask = null;
    protected Component componentToSnapshot = null;
    protected String prefix = "";
    protected BlinkStatusLed blinkLed = null;

    public PeriodicSnapshotWorker() {
    }

    public PeriodicSnapshotWorker(Component componentToSnapshot, String prefix, BlinkStatusLed blinkLed) {
        this.setComponentToSnapshot(componentToSnapshot);
        this.setPrefix(prefix);
        this.setBlinkLed(blinkLed);
    }

    public Component getComponentToSnapshot() {
        return this.componentToSnapshot;
    }

    public void setComponentToSnapshot(Component componentToSnapshot) {
        this.componentToSnapshot = componentToSnapshot;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (prefix == null) {
            this.prefix = "";
        } else if (!"".equalsIgnoreCase(prefix)) {
            this.prefix = prefix + "-";
        }
    }

    public BlinkStatusLed getBlinkLed() {
        return this.blinkLed;
    }

    public void setBlinkLed(BlinkStatusLed blinkLed) {
        this.blinkLed = blinkLed;
    }

    public void startWorking() {
        this.stopWorking();
        this.ttask = new TimerTask(){

            @Override
            public void run() {
                if (PeriodicSnapshotWorker.this.componentToSnapshot != null && PeriodicSnapshotWorker.this.componentToSnapshot.isVisible() && PeriodicSnapshotWorker.this.componentToSnapshot.isShowing()) {
                    Window wd = PeriodicSnapshotWorker.this.componentToSnapshot instanceof Window ? (Window)PeriodicSnapshotWorker.this.componentToSnapshot : SwingUtilities.getWindowAncestor(PeriodicSnapshotWorker.this.componentToSnapshot);
                    if (wd != null && wd instanceof Frame && (((Frame)wd).getExtendedState() & 1) == 1) {
                        return;
                    }
                    GuiUtils.takeSnapshot(PeriodicSnapshotWorker.this.componentToSnapshot, PeriodicSnapshotWorker.this.prefix);
                }
            }
        };
        long pr = GeneralPreferences.autoSnapshotPeriodSeconds * 1000;
        if (this.runner == null) {
            this.runner = new Timer("Snapshot Runner: " + this.prefix);
        }
        this.runner.scheduleAtFixedRate(this.ttask, 500L, pr);
    }

    public void stopWorking() {
        if (this.ttask != null) {
            this.ttask.cancel();
        }
        if (this.runner != null) {
            this.runner.cancel();
        }
        this.runner = null;
    }
}

