/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class PropertiesLoader
extends Properties {
    private static final long serialVersionUID = 1L;
    private String workingFile = "";
    public static final short PROPERTIES = 0;
    public static final short XML_PROPERTIES = 1;

    public PropertiesLoader() {
        try {
            this.setFile("Sistema.properties");
            this.workingFile = "Sistema.properties";
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error((Object)("File not found. : " + e.getMessage()));
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)("Can't read file. : " + e.getMessage()));
        }
    }

    public PropertiesLoader(String txfile) {
        this(txfile, 0);
    }

    public PropertiesLoader(String txfile, short type) {
        try {
            this.workingFile = txfile;
            if (type == 1) {
                this.setXmlFile(txfile);
            } else {
                this.setFile(txfile);
            }
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error((Object)e.getMessage());
            try {
                this.setFile("pt.lsts.neptus.properties");
                this.workingFile = "pt.lsts.neptus.properties";
            }
            catch (FileNotFoundException e1) {
                NeptusLog.pub().error((Object)("File not found. " + e1.getMessage()));
            }
            catch (IOException e1) {
                NeptusLog.pub().error((Object)("Can't read file. " + e1.getMessage()));
            }
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)e.getMessage());
            try {
                this.setFile("pt.lsts.neptus.properties");
                this.workingFile = "pt.lsts.neptus.properties";
            }
            catch (FileNotFoundException e1) {
                NeptusLog.pub().error((Object)("File not found. " + e1.getMessage()));
            }
            catch (IOException e1) {
                NeptusLog.pub().error((Object)("Can't read file. " + e1.getMessage()));
            }
        }
    }

    public void setFile(InputStream in) throws IOException {
        this.clear();
        this.load(in);
        in.close();
    }

    public void setFile(String txfile) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(txfile);
        this.setFile(in);
    }

    public void setXmlFile(InputStream in) throws IOException {
        this.clear();
        this.loadFromXML(in);
        in.close();
    }

    public void setXmlFile(String txfile) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(txfile);
        this.setXmlFile(in);
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        try {
            super.store(out, header);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)("Cannot store properties. : " + e.getMessage()));
        }
    }

    public void store(String header) throws FileNotFoundException, IOException {
        try {
            if (this.workingFile.compareTo("") == 0) {
                NeptusLog.pub().error((Object)(this + ": Error. Cannot find file to writo to."));
                throw new IOException("Cannot find file to write to");
            }
            FileOutputStream out = new FileOutputStream(this.workingFile);
            this.store(out, header);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)("Cannot store properties. : " + e.getMessage()));
        }
    }

    @Override
    public void storeToXML(OutputStream out, String header) throws IOException {
        try {
            super.storeToXML(out, header);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)("Cannot store properties. : " + e.getMessage()));
        }
    }

    @Override
    public void storeToXML(OutputStream out, String header, String encoding) throws IOException {
        try {
            super.storeToXML(out, header, encoding);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)("Cannot store properties. : " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeToXML(String header) throws FileNotFoundException, IOException {
        OutputStream out = null;
        try {
            if (this.workingFile.compareTo("") == 0) {
                NeptusLog.pub().error((Object)(this + ": Error. Cannot find file to write to."));
                throw new IOException("Cannot find file to write to");
            }
            out = new FileOutputStream(this.workingFile);
            this.storeToXML(out, header);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)(this + ": Cannot store properties."));
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e.getMessage());
            }
        }
    }

    public void storeToXML(String header, String encoding) throws FileNotFoundException, IOException {
        try {
            if (this.workingFile.compareTo("") == 0) {
                NeptusLog.pub().error((Object)(this + ": Error. Cannot find file to writo to."));
                throw new IOException("Cannot find file to write to");
            }
            FileOutputStream out = new FileOutputStream(this.workingFile);
            this.storeToXML((OutputStream)out, header, encoding);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)("Cannot store properties. : " + e.getMessage()));
        }
    }

    public String getWorkingFile() {
        return this.workingFile;
    }

    public void setWorkingFile(String workingFile) {
        this.workingFile = workingFile;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        Object obj = super.setProperty(key, value);
        GeneralPreferences.warnPreferencesListeneres();
        return obj;
    }
}

