/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import pt.lsts.neptus.NeptusLog;

public class PropertiesUTF8LoaderWriter {
    private PropertiesUTF8LoaderWriter() {
    }

    public static Properties loadProperties(String filePath) throws Exception {
        return PropertiesUTF8LoaderWriter.loadProperties(new FileInputStream(new File(filePath)), "utf-8");
    }

    public static Properties loadProperties(File file) throws Exception {
        return PropertiesUTF8LoaderWriter.loadProperties(new FileInputStream(file), "utf-8");
    }

    public static Properties loadProperties(InputStream is) throws Exception {
        return PropertiesUTF8LoaderWriter.loadProperties(is, "utf-8");
    }

    private static Properties loadProperties(InputStream is, String encoding) throws IOException {
        int temp;
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(is, encoding);
        while ((temp = isr.read()) >= 0) {
            char c = (char)temp;
            sb.append(c);
        }
        String inputString = PropertiesUTF8LoaderWriter.escapifyStr(sb.toString());
        byte[] bs = inputString.getBytes("ISO-8859-1");
        ByteArrayInputStream bais = new ByteArrayInputStream(bs);
        Properties ps = new Properties();
        ps.load(bais);
        return ps;
    }

    private static char hexDigit(char ch, int offset) {
        int val = ch >> offset & 0xF;
        if (val <= 9) {
            return (char)(48 + val);
        }
        return (char)(65 + val - 10);
    }

    private static String escapifyStr(String str) {
        StringBuilder result = new StringBuilder();
        int len = str.length();
        for (int x = 0; x < len; ++x) {
            char ch = str.charAt(x);
            if (ch <= '~') {
                result.append(ch);
                continue;
            }
            result.append('\\');
            result.append('u');
            result.append(PropertiesUTF8LoaderWriter.hexDigit(ch, 12));
            result.append(PropertiesUTF8LoaderWriter.hexDigit(ch, 8));
            result.append(PropertiesUTF8LoaderWriter.hexDigit(ch, 4));
            result.append(PropertiesUTF8LoaderWriter.hexDigit(ch, 0));
        }
        return result.toString();
    }

    public static void storeProperties(Properties properties, String comments, String fileOutputPath) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(new File(fileOutputPath));
        PropertiesUTF8LoaderWriter.storeProperties(properties, comments, fos);
    }

    private static void storeProperties(Properties properties, String comments, OutputStream out) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "utf-8"));
            properties.store(writer, comments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        Properties prop1 = new Properties();
        Properties propUtf8 = new Properties();
        prop1.put("test 1", "test 1");
        prop1.put("test 1", "test 1 \u00e9 \u20ac \u0409");
        propUtf8.put("test 1", "test 1");
        propUtf8.put("test 1", "test 1 \u00e9 \u20ac \u0409");
        prop1.store(new FileOutputStream("prop1.properties"), "8889");
        PropertiesUTF8LoaderWriter.storeProperties(propUtf8, "utf8", "propUtf8.properties");
        prop1.load(new FileInputStream("propUtf8.properties"));
        propUtf8 = PropertiesUTF8LoaderWriter.loadProperties(new FileInputStream("propUtf8.properties"));
        NeptusLog.pub().info((Object)("<###> " + prop1.getProperty("test 1")));
        NeptusLog.pub().info((Object)("<###> " + propUtf8.getProperty("test 1")));
    }
}

