/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.PropertiesLoader;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class RecentlyOpenedFilesUtil {
    public static void constructRecentlyFilesMenuItems(JMenu recentlyOpenFilesMenuItem, LinkedHashMap<?, ?> filesOpenedLHM) {
        recentlyOpenFilesMenuItem.removeAll();
        if (filesOpenedLHM.size() == 0) {
            recentlyOpenFilesMenuItem.setEnabled(false);
        } else {
            recentlyOpenFilesMenuItem.setEnabled(true);
            for (JMenuItem nMenuItem : filesOpenedLHM.keySet()) {
                File fx = (File)filesOpenedLHM.get(nMenuItem);
                nMenuItem.setText(fx.getParentFile().getName() + System.getProperty("file.separator") + fx.getName());
                recentlyOpenFilesMenuItem.add(nMenuItem);
            }
        }
    }

    public static boolean updateFilesOpenedMenuItems(File fx, LinkedHashMap<JMenuItem, File> filesOpened, ActionListener actionListener) {
        if (filesOpened.containsValue(fx)) {
            for (JMenuItem key : filesOpened.keySet()) {
                if (!filesOpened.get(key).equals(fx)) continue;
                filesOpened.remove(key);
                break;
            }
        }
        if (!filesOpened.containsValue(fx)) {
            JMenuItem nMenuItem = new JMenuItem(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getText() {
                    return super.getText();
                }
            };
            nMenuItem.setText(fx.getName());
            nMenuItem.setToolTipText(fx.getAbsolutePath());
            if (actionListener != null) {
                nMenuItem.addActionListener(actionListener);
            }
            LinkedHashMap<JMenuItem, File> oldList = new LinkedHashMap<JMenuItem, File>();
            oldList.putAll(filesOpened);
            filesOpened.clear();
            filesOpened.put(nMenuItem, fx);
            filesOpened.putAll(oldList);
        }
        while (filesOpened.size() > 10) {
            Object[] keys = filesOpened.keySet().toArray();
            filesOpened.remove(keys[filesOpened.size() - 1]);
        }
        return true;
    }

    public static void loadRecentlyOpenedFiles(String filePath, Method updateMethod, Object objectOfUpdateMethod) {
        String recentlyOpenedFiles = ConfigFetch.resolvePath(filePath);
        if (recentlyOpenedFiles == null) {
            return;
        }
        if (!new File(recentlyOpenedFiles).exists()) {
            return;
        }
        PropertiesLoader pLoader = new PropertiesLoader(recentlyOpenedFiles, 1);
        String nFiles = pLoader.getProperty("n-files");
        int nf = 0;
        if (nFiles == null) {
            nf = 0;
        } else {
            try {
                nf = Integer.parseInt(nFiles);
                for (int i = nf - 1; i >= 0; --i) {
                    String file = pLoader.getProperty("file" + i);
                    File fx = new File(file);
                    if (!fx.exists()) continue;
                    Object[] args = new Object[]{fx};
                    try {
                        updateMethod.invoke(objectOfUpdateMethod, args);
                        continue;
                    }
                    catch (Exception e1) {
                        NeptusLog.pub().error((Object)"loadRecentlyOpenedFiles", (Throwable)e1);
                    }
                }
            }
            catch (NumberFormatException e) {
                NeptusLog.pub().debug((Object)e.getMessage());
                nf = 0;
            }
        }
    }

    public static void storeRecentlyOpenedFiles(String filePath, LinkedHashMap<?, ?> hMap, String header) {
        String recentlyOpenedFiles = ConfigFetch.resolvePathBasedOnConfigFile(filePath);
        if (recentlyOpenedFiles == null) {
            JOptionPane.showInternalMessageDialog(null, "Cannot Load");
            return;
        }
        PropertiesLoader pLoader = new PropertiesLoader(recentlyOpenedFiles, 1);
        pLoader.clear();
        int nf = hMap.size();
        pLoader.setProperty("n-files", Integer.toString(nf));
        Iterator<?> it = hMap.values().iterator();
        for (int i = 0; i < nf; ++i) {
            File fx = (File)it.next();
            pLoader.setProperty("file" + i, fx.getAbsolutePath());
        }
        try {
            pLoader.storeToXML(header);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"storeRecentlyOpenedFiles", (Throwable)e);
        }
    }
}

