/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.templates.AbstractPlanTemplate;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.renderer2d.tiles.Tile;

public class ReflectionUtil {
    public static List<Class<?>> getClassesForPackage(String pckgname) throws ClassNotFoundException {
        return ReflectionUtil.getClassesForPackage(pckgname, true);
    }

    public static List<Class<?>> getClassesForPackage(String pckgname, boolean recursive) throws ClassNotFoundException {
        ArrayList<File> directories = new ArrayList<File>();
        ArrayList classes = new ArrayList();
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            String path = pckgname.replace('.', '/');
            Enumeration<URL> resources = cld.getResources(path);
            while (resources.hasMoreElements()) {
                String res = resources.nextElement().getPath();
                if (res.contains(".jar!")) {
                    JarFile zf = new JarFile(URLDecoder.decode(res.substring(5, res.indexOf("!")), "UTF-8"));
                    Enumeration<JarEntry> enumer = zf.entries();
                    while (enumer.hasMoreElements()) {
                        String nextPath = ((Object)enumer.nextElement()).toString();
                        String next = nextPath.replaceAll("/", ".");
                        if (next.startsWith(pckgname) && next.endsWith(".class")) {
                            String clazz = next.substring(0, next.length() - 6);
                            classes.add(Class.forName(clazz));
                            continue;
                        }
                        if (!recursive) continue;
                        classes.addAll(ReflectionUtil.getClassesForPackage(res, true));
                    }
                    zf.close();
                    continue;
                }
                directories.add(new File(URLDecoder.decode(res, "UTF-8")));
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Null pointer exception)");
        }
        catch (UnsupportedEncodingException encex) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Unsupported encoding)");
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        for (File directory : directories) {
            if (directory.exists()) {
                String[] files;
                for (String file : files = directory.list()) {
                    if (file.endsWith(".class")) {
                        classes.add(Class.forName(pckgname + '.' + file.substring(0, file.length() - 6)));
                        continue;
                    }
                    if (!recursive) continue;
                    classes.addAll(ReflectionUtil.getClassesForPackage(pckgname + '.' + file, true));
                }
                continue;
            }
            throw new ClassNotFoundException(pckgname + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return classes;
    }

    public static List<Class<?>> getImplementationsForPackage(String pckgname, Class<?> iface) throws ClassNotFoundException {
        ArrayList allClasses = new ArrayList();
        allClasses.addAll(ReflectionUtil.getClassesForPackage(pckgname));
        for (Class clazz : allClasses) {
            boolean hasInterface = false;
            for (Class<?> itf : clazz.getInterfaces()) {
                if (!itf.equals(iface)) continue;
                hasInterface = true;
                break;
            }
            if (hasInterface) continue;
            allClasses.remove(clazz);
        }
        return allClasses;
    }

    public static String getCallerStamp() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length < 4) {
            return "(?:?)";
        }
        return "(" + stack[3].getFileName() + ":" + stack[3].getLineNumber() + ")";
    }

    public static Class<?>[] listManeuvers() {
        Vector maneuvers = new Vector();
        try {
            List<Class<?>> classes = ReflectionUtil.getClassesForPackage(Maneuver.class.getPackage().getName());
            for (Class<?> c : classes) {
                if (c == null || c.getSimpleName().length() == 0 || !ReflectionUtil.hasAnySuperClass(c, Maneuver.class)) continue;
                maneuvers.add(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maneuvers.toArray(new Class[0]);
    }

    public static Class<?>[] listPlanTemplates() {
        Vector templates = new Vector();
        try {
            List<Class<?>> classes = ReflectionUtil.getClassesForPackage(AbstractPlanTemplate.class.getPackage().getName());
            for (Class<?> c : classes) {
                if (c == null || c.getSimpleName().length() == 0 || !ReflectionUtil.isSubclass(c, AbstractPlanTemplate.class) || c.getAnnotation(PluginDescription.class) == null) continue;
                templates.add(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return templates.toArray(new Class[0]);
    }

    public static Class<?>[] listTileProviders() {
        Vector tileProviders = new Vector();
        try {
            List<Class<?>> classes = ReflectionUtil.getClassesForPackage(Tile.class.getPackage().getName());
            for (Class<?> c : classes) {
                if (c == null || c.getSimpleName().length() == 0 || !ReflectionUtil.hasAnnotation(c, MapTileProvider.class)) continue;
                tileProviders.add(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tileProviders.toArray(new Class[0]);
    }

    public static Collection<Method> getMethodsAnnotatedWith(Class<? extends Annotation> ann, Object o) {
        Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
        HashSet<Method> methods = new HashSet<Method>();
        for (Method m : c.getMethods()) {
            if (m.getAnnotation(ann) == null) continue;
            methods.add(m);
        }
        for (Method m : c.getDeclaredMethods()) {
            if (m.getAnnotation(ann) == null) continue;
            m.setAccessible(true);
            methods.add(m);
        }
        return methods;
    }

    public static Collection<Field> getFieldsAnnotatedWith(Class<? extends Annotation> ann, Object o) {
        Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
        HashSet<Field> fields = new HashSet<Field>();
        for (Field f : c.getFields()) {
            if (f.getAnnotation(ann) == null) continue;
            fields.add(f);
        }
        for (Field f : c.getDeclaredFields()) {
            if (f.getAnnotation(ann) == null) continue;
            f.setAccessible(true);
            fields.add(f);
        }
        return fields;
    }

    public static boolean hasAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return clazz.isAnnotationPresent(annotation);
    }

    public static boolean hasInterface(Class<?> clazz, Class<?> interf) {
        return interf.isAssignableFrom(clazz);
    }

    public static boolean isSubclass(Class<?> clazz, Class<?> superClass) {
        return superClass.isAssignableFrom(clazz);
    }

    public static boolean hasAnySuperClass(Class<?> clazz, Class<?> superClass) {
        return superClass.isAssignableFrom(clazz);
    }

    public static void main(String[] args) throws Exception {
        for (Class<?> c : ReflectionUtil.listPlanTemplates()) {
            NeptusLog.pub().info((Object)("<###> " + c.getName()));
        }
        for (Class<MRAVisualization> c : PluginsRepository.listExtensions(MRAVisualization.class).values()) {
            NeptusLog.pub().info((Object)("<###> " + c.getName()));
        }
    }
}

