/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class StreamUtil {
    private StreamUtil() {
    }

    public static boolean copyStreamToStream(InputStream inStream, OutputStream outStream) {
        try {
            byte[] extra = new byte[50000];
            int ret = 0;
            int pos = 0;
            while (true) {
                ret = inStream.read(extra);
                NeptusLog.waste().debug((Object)("copyStreamToStream> ret: " + ret));
                if (ret == -1) break;
                byte[] extra1 = new byte[ret];
                System.arraycopy(extra, 0, extra1, 0, ret);
                outStream.write(extra1);
                outStream.flush();
                pos = ret;
                NeptusLog.waste().debug((Object)("copyStreamToStream> pos: " + pos));
            }
            NeptusLog.waste().debug((Object)"copyStreamToStream> end <");
            return true;
        }
        catch (IOException e) {
            NeptusLog.waste().error((Object)"copyStreamToStream", (Throwable)e);
            return false;
        }
    }

    public static String copyStreamToString(InputStream inStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.copyStreamToStream(inStream, baos);
        String ret = baos.toString();
        return ret;
    }

    public static boolean copyStreamToFile(InputStream inStream, File outFile) {
        return StreamUtil.copyStreamToFile(inStream, outFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyStreamToFile(InputStream inStream, File outFile, boolean append) {
        FileOutputStream fos = null;
        try {
            boolean ret;
            fos = new FileOutputStream(outFile, append);
            boolean bl = ret = StreamUtil.copyStreamToStream(inStream, fos);
            return bl;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"copyStreamToFile", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)"copyStreamToFile", (Throwable)e);
            }
        }
    }

    public static File copyStreamToTempFile(InputStream inStream) {
        try {
            File tmpDir = new File(ConfigFetch.getNeptusTmpDir());
            File fx = File.createTempFile("neptus_", "tmp", tmpDir);
            fx.deleteOnExit();
            boolean ret = StreamUtil.copyStreamToFile(inStream, fx);
            if (ret) {
                return fx;
            }
            return null;
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"copyStreamToTempFile", (Throwable)e);
            return null;
        }
    }

    public static int ensureRead(InputStream in, byte[] b, int off, int len) throws IOException {
        int actualRead = 0;
        int ret = in.read(b, off, len);
        if (ret == -1) {
            return ret;
        }
        actualRead += ret;
        while (actualRead != len) {
            int left = len - actualRead;
            ret = in.read(b, off + actualRead, left);
            if (ret == -1) {
                return ret;
            }
            actualRead += ret;
        }
        return actualRead;
    }
}

