/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import pt.lsts.neptus.NeptusLog;

public class StringUtils {
    private StringUtils() {
    }

    public static final boolean isTokenInList(String searchString, String token) {
        return StringUtils.isTokenInList(searchString, token, "[ ,]+");
    }

    public static final boolean isTokenInList(String searchString, String token, String splitRedex) {
        String[] lt;
        for (String val : lt = searchString.split(splitRedex)) {
            if (!val.equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    public static final String toImcName(String name) {
        return name.toLowerCase().trim().replaceAll("[ _]", "-");
    }

    public static final String wrapEveryNChars(String txt, short lineLength) {
        return StringUtils.wrapEveryNChars(txt, lineLength, -1, false);
    }

    public static final String wrapEveryNChars(String txt, short lineLength, int maxCharacters) {
        return StringUtils.wrapEveryNChars(txt, lineLength, maxCharacters, false);
    }

    public static final String wrapEveryNChars(String txt, short lineLength, int maxCharacters, boolean placeElipsisIfCuted) {
        boolean hasLimit = true;
        if (maxCharacters <= 0) {
            hasLimit = false;
        }
        if (lineLength <= 1) {
            if (hasLimit && txt.length() >= maxCharacters) {
                return txt.substring(0, maxCharacters) + (placeElipsisIfCuted ? "..." : "");
            }
            return txt;
        }
        String ret = "";
        if (lineLength >= txt.length()) {
            if (hasLimit && txt.length() >= maxCharacters) {
                return txt.substring(0, maxCharacters) + (placeElipsisIfCuted ? "..." : "");
            }
            return txt;
        }
        for (int i = 0; i < txt.length(); i += lineLength) {
            int end = i + lineLength;
            if (end > txt.length()) {
                end = txt.length();
            }
            ret = ret + txt.substring(i, end) + "\n";
            if (!hasLimit || ret.length() < maxCharacters) continue;
            return ret.substring(0, maxCharacters) + (placeElipsisIfCuted ? "..." : "");
        }
        return ret;
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###>" + StringUtils.isTokenInList("UDP, RTPS", "UDP")));
        NeptusLog.pub().info((Object)("<###>" + StringUtils.isTokenInList("UDP,RTPS", "UDP")));
        NeptusLog.pub().info((Object)("<###>" + StringUtils.isTokenInList(" UDP ,  RTPS", "UDP")));
        String txt = "- Retrying connect4097816 [Foxtrot Multi Worker Thread Runner #70] INFO org.apache.http.impl.client.DefaultHttpClient  - Retrying connect- I/O exception (java.net.NoRouteToHostException) caught when connecting to the target host: No route to host: connect4097818 [Foxtrot Multi Worker Thread Runner #70] INFO org.apache.http.impl.client.DefaultHttpClient  - I/O exception (java.net.NoRouteToHostException) caught when connecting to the target host: No route to host: connect- Retrying connect4097818 [Foxtrot Multi Worker Thread Runner #70] INFO org.apache.http.impl.client.DefaultHttpClient  - Retrying connect xxxx";
        NeptusLog.pub().info((Object)("<###> " + StringUtils.wrapEveryNChars(txt, (short)100)));
        NeptusLog.pub().info((Object)"<###>\n\n------------------------------------------------\n\n");
        NeptusLog.pub().info((Object)("<###> " + StringUtils.wrapEveryNChars(txt, (short)100, 100, true)));
        NeptusLog.pub().info((Object)"<###>\n\n------------------------------------------------\n\n");
        NeptusLog.pub().info((Object)("<###> " + StringUtils.wrapEveryNChars(txt, (short)100, 1000, true)));
        NeptusLog.pub().info((Object)"<###>\n\n------------------------------------------------\n\n");
        NeptusLog.pub().info((Object)("<###> " + StringUtils.wrapEveryNChars(txt, (short)100, 100, true)));
        NeptusLog.pub().info((Object)("<###> " + StringUtils.wrapEveryNChars(txt, (short)120, 100, true)));
    }
}

