/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.TimeUnit;
import pt.lsts.neptus.NeptusLog;

public class VideoCreator {
    private int width;
    private int height;
    IMediaWriter writer;
    long firstTimeStamp = -1L;

    public VideoCreator(File output, int width, int height) throws Exception {
        this.width = width;
        this.height = height;
        this.writer = ToolFactory.makeWriter((String)output.getAbsolutePath());
        this.writer.addVideoStream(0, 0, width, height);
    }

    public BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType && sourceImage.getWidth() == this.width && sourceImage.getHeight() == this.height) {
            image = sourceImage;
        } else {
            image = new BufferedImage(this.width, this.height, targetType);
            image.getGraphics().drawImage(sourceImage.getScaledInstance(this.width, this.height, 4), 0, 0, null);
        }
        return image;
    }

    public void addFrame(BufferedImage frame, long time) {
        BufferedImage worksWithXugglerBufferedImage = this.convertToType(frame, 5);
        if (this.firstTimeStamp == -1L) {
            this.firstTimeStamp = time;
        }
        this.writer.encodeVideo(0, worksWithXugglerBufferedImage, time - this.firstTimeStamp, TimeUnit.MILLISECONDS);
    }

    public void closeStreams() {
        try {
            this.writer.close();
        }
        catch (Error | Exception e) {
            NeptusLog.pub().warn((Object)("Error closing " + VideoCreator.class.getSimpleName() + " stream."), e);
        }
    }
}

