/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.swing.ImageIcon;
import javax.vecmath.Color3f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import pt.lsts.neptus.util.XMLValidator;

public class X3dParse {
    public String fileX3d;
    public String fileSchema;

    public String getFileX3d() {
        return this.fileX3d;
    }

    public void setFileX3d(String file) {
        this.fileX3d = file;
    }

    public String getFileSchema() {
        return this.fileSchema;
    }

    public void setFileSchema(String fileschema) {
        this.fileSchema = fileschema;
    }

    public Document initparse(String url) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(url);
        return document;
    }

    public String resolvePathWithParent(String parentPath, String filePath) {
        File fx = new File(filePath);
        File fxParent = new File(parentPath);
        if (fx.isAbsolute()) {
            return fx.getAbsolutePath();
        }
        if (fxParent.exists()) {
            String parent = "";
            parent = fxParent.isDirectory() ? fxParent.getAbsolutePath() : fxParent.getAbsoluteFile().getParent();
            File fx1 = new File(parent + "/" + filePath).getAbsoluteFile();
            if (fx1.isAbsolute()) {
                try {
                    return fx1.getCanonicalPath();
                }
                catch (IOException e) {
                    return fx1.getAbsolutePath();
                }
            }
        }
        return filePath;
    }

    public Point2f[] stringToPoint2f(String strin) {
        String aux = strin.replace("  ", " ");
        String[] str = aux.split(", ");
        Point2f[] ret = new Point2f[str.length];
        for (int i = 0; i < str.length; ++i) {
            String[] result = str[i].split(" ");
            ret[i] = new Point2f();
            ret[i].x = Float.parseFloat(result[0]);
            ret[i].y = Float.parseFloat(result[1]);
        }
        return ret;
    }

    public Point3f[] stringToPoint3f(String strin) {
        String aux = strin.replace("  ", " ");
        String[] str = aux.split(", ");
        Point3f[] ret = new Point3f[str.length];
        for (int i = 0; i < str.length; ++i) {
            String[] result = str[i].split(" ");
            ret[i] = new Point3f();
            ret[i].x = Float.parseFloat(result[0]);
            ret[i].z = -Float.parseFloat(result[1]);
            ret[i].y = Float.parseFloat(result[2]);
        }
        return ret;
    }

    public int[] stringToInt3(String strin) {
        String aux = strin.replace(" -1", "");
        aux = aux.replace("  ", " ");
        int auxiniciospace = 0;
        if (aux.charAt(0) == ' ') {
            ++auxiniciospace;
        }
        String[] str = aux.split(" ");
        int[] ret = new int[str.length - auxiniciospace];
        for (int i = 0; i < str.length - auxiniciospace; ++i) {
            if (str[i].equals("")) {
                ++auxiniciospace;
            }
            ret[i] = Integer.parseInt(str[i + auxiniciospace]);
        }
        return ret;
    }

    public Transform3D parseRotation(String text) {
        Transform3D ret = new Transform3D();
        return ret;
    }

    public Transform3D parseTranslation(String text) {
        Transform3D ret = new Transform3D();
        String[] result = text.split(" ");
        float x = Float.parseFloat(result[0]);
        float z = -Float.parseFloat(result[1]);
        float y = Float.parseFloat(result[2]);
        ret.set(new Vector3d((double)x, (double)y, (double)z));
        return ret;
    }

    public Transform3D parseScale(String text) {
        Transform3D ret = new Transform3D();
        String[] result = text.split(" ");
        float x = Float.parseFloat(result[0]);
        float z = -Float.parseFloat(result[1]);
        float y = Float.parseFloat(result[2]);
        ret.setScale(new Vector3d((double)x, (double)y, (double)z));
        return ret;
    }

    public Transform3D parseTransform(Node node) {
        Transform3D ret = new Transform3D();
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if ("rotation".equals(attribute.getName())) {
                ret.mul(this.parseRotation(attribute.getValue()));
            }
            if ("translation".equals(attribute.getName())) {
                ret.mul(this.parseTranslation(attribute.getValue()));
            }
            if (!"scale".equals(attribute.getName())) continue;
            ret.mul(this.parseScale(attribute.getValue()));
        }
        return ret;
    }

    public TransformGroup parseScene(Node node) {
        TransformGroup ret = new TransformGroup();
        List list = node.selectNodes("*");
        for (Element element : list) {
            if ("StaticGroup".equals(element.getName())) {
                ret.addChild((javax.media.j3d.Node)this.parseScene((Node)element));
            }
            if ("Group".equals(element.getName())) {
                ret.addChild((javax.media.j3d.Node)this.parseScene((Node)element));
            }
            if ("Shape".equals(element.getName())) {
                ret.addChild((javax.media.j3d.Node)this.parseShape((Node)element));
            }
            if (!"Transform".equals(element.getName())) continue;
            TransformGroup trans = new TransformGroup();
            Transform3D tr = this.parseTransform((Node)element);
            trans.setTransform(tr);
            trans.addChild((javax.media.j3d.Node)this.parseScene((Node)element));
            ret.addChild((javax.media.j3d.Node)trans);
        }
        return ret;
    }

    public Color3f parseColor(String strin) {
        Color3f ret = new Color3f();
        String color = strin.replace(",", "");
        String[] result = color.split(" ");
        float r = Float.parseFloat(result[0]);
        float g = Float.parseFloat(result[1]);
        float b = Float.parseFloat(result[2]);
        ret.set(r, g, b);
        return ret;
    }

    public Vector3f parseSize(String size) {
        Vector3f ret = new Vector3f();
        String[] result = size.split("\\s");
        float x = Float.parseFloat(result[0]);
        float y = Float.parseFloat(result[1]);
        float z = Float.parseFloat(result[2]);
        ret.set(x, y, z);
        return ret;
    }

    public Sphere parseSphere(Node node, Appearance app) {
        float radius = 2.0f;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if (!"radius".equals(attribute.getName())) continue;
            radius = Float.parseFloat(attribute.getValue());
        }
        Sphere ret = new Sphere(radius, 3, null);
        ret.setAppearance(app);
        return ret;
    }

    public Cylinder parseCylinder(Node node, Appearance app) {
        float height = 1.0f;
        float radius = 2.0f;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if ("radius".equals(attribute.getName())) {
                radius = Float.parseFloat(attribute.getValue());
            }
            if (!"height".equals(attribute.getName())) continue;
            height = Float.parseFloat(attribute.getValue());
        }
        Cylinder ret = new Cylinder(radius, height, 3, null);
        ret.setAppearance(app);
        return ret;
    }

    public Cone parseCone(Node node, Appearance app) {
        float height = 1.0f;
        float radius = 2.0f;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if ("radius".equals(attribute.getName())) {
                radius = Float.parseFloat(attribute.getValue());
            }
            if (!"height".equals(attribute.getName())) continue;
            height = Float.parseFloat(attribute.getValue());
        }
        Cone ret = new Cone(radius, height, 3, null);
        ret.setAppearance(app);
        return ret;
    }

    public Box parseBox(Node node, Appearance app) {
        float x = 1.0f;
        float y = 1.0f;
        float z = 1.0f;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if (!"size".equals(attribute.getName())) continue;
            Vector3f v = this.parseSize(attribute.getValue());
            x = v.x;
            y = v.y;
            z = v.z;
        }
        Box ret = new Box(x, y, z, 3, null);
        ret.setAppearance(app);
        return ret;
    }

    public Material parseMaterial(Node node) {
        Material mat = new Material();
        Color3f dc = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f sc = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f ec = new Color3f(0.0f, 0.0f, 0.0f);
        float shininess = 0.5f;
        mat.setCapability(1);
        mat.setCapability(0);
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if ("diffuseColor".equals(attribute.getName())) {
                dc = this.parseColor(attribute.getValue());
            }
            if ("specularColor".equals(attribute.getName())) {
                sc = this.parseColor(attribute.getValue());
            }
            if ("emissiveColor".equals(attribute.getName())) {
                ec = this.parseColor(attribute.getValue());
            }
            if (!"shininess".equals(attribute.getName())) continue;
            shininess = Float.parseFloat(attribute.getValue());
        }
        mat.setDiffuseColor(dc);
        mat.setSpecularColor(sc);
        mat.setEmissiveColor(ec);
        mat.setShininess(shininess);
        return mat;
    }

    public TransparencyAttributes parseGetTrnspMat(Node node) {
        float value = 0.0f;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if (!"transparency".equals(attribute.getName())) continue;
            value = Float.parseFloat(attribute.getValue());
        }
        if (value == 0.0f) {
            return null;
        }
        TransparencyAttributes trans = new TransparencyAttributes();
        trans.setCapability(3);
        trans.setCapability(2);
        trans.setTransparency(value);
        trans.setTransparencyMode(1);
        return trans;
    }

    public Appearance parseAppearance(Node node) {
        Appearance app = new Appearance();
        app.setCapability(10);
        app.setCapability(11);
        List list = node.selectNodes("*");
        for (Element element : list) {
            if ("Material".equals(element.getName())) {
                app.setMaterial(this.parseMaterial((Node)element));
                TransparencyAttributes trans = this.parseGetTrnspMat((Node)element);
                if (trans != null) {
                    app.setTransparencyAttributes(trans);
                }
            }
            if (!"ImageTexture".equals(element.getName())) continue;
            app.setTexture(this.parseImageTexture((Node)element));
        }
        PolygonAttributes p = new PolygonAttributes();
        p.setCullFace(0);
        app.setPolygonAttributes(p);
        return app;
    }

    public Texture parseImageTexture(Node node) {
        Texture ret = null;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if (!"url".equals(attribute.getName())) continue;
            String pathtext = this.resolvePathWithParent(this.fileX3d, attribute.getValue());
            Image texture = new ImageIcon(pathtext).getImage();
            ret = new TextureLoader(texture, null).getTexture();
        }
        return ret;
    }

    public Point3f[] parseCoordinate(Node node) {
        Point3f[] ret = null;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if (!"point".equals(attribute.getName())) continue;
            ret = this.stringToPoint3f(attribute.getValue());
        }
        return ret;
    }

    public Point3f[] parseColor(Node node) {
        Point3f[] ret = null;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if (!"color".equals(attribute.getName())) continue;
            ret = this.stringToPoint3f(attribute.getValue());
        }
        return ret;
    }

    public Point2f[] parseTextureCoordinate(Node node) {
        Point2f[] ret = null;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if (!"point".equals(attribute.getName())) continue;
            ret = this.stringToPoint2f(attribute.getValue());
        }
        return ret;
    }

    public Shape3D parseIndexedFaceSet(Node node, Appearance app) {
        Shape3D shape = null;
        int propreties = 0;
        Point3f[] pointsvector = null;
        Point2f[] pointstextvector = null;
        int[] indexpoints = null;
        int[] indextextpoints = null;
        List list = node.selectNodes("@*");
        for (Attribute attribute : list) {
            if ("coordIndex".equals(attribute.getName())) {
                propreties |= 1;
                indexpoints = this.stringToInt3(attribute.getValue());
            }
            if ("texCoordIndex".equals(attribute.getName())) {
                propreties |= 0x20;
                indextextpoints = this.stringToInt3(attribute.getValue());
            }
            if (!"colorIndex".equals(attribute.getName())) continue;
            propreties |= 4;
            this.stringToInt3(attribute.getValue());
        }
        list = node.selectNodes("*");
        for (Element element : list) {
            if ("Coordinate".equals(element.getName())) {
                pointsvector = this.parseCoordinate((Node)element);
            }
            if ("TextureCoordinate".equals(element.getName())) {
                pointstextvector = this.parseTextureCoordinate((Node)element);
            }
            if (!"Color".equals(element.getName())) continue;
            this.parseColor((Node)element);
        }
        int numvertices = indexpoints.length;
        TriangleArray GFront = new TriangleArray(numvertices, propreties);
        for (int i = 0; i < numvertices; ++i) {
            GFront.setCoordinate(i, pointsvector[indexpoints[i]]);
            if (pointstextvector == null) continue;
            GFront.setTextureCoordinate(i, pointstextvector[indextextpoints[i]]);
        }
        GeometryInfo gi = new GeometryInfo((GeometryArray)GFront);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        gi.recomputeIndices();
        gi.unindexify();
        gi.compact();
        GeometryArray geom = gi.getGeometryArray();
        geom.setCapability(4);
        shape = new Shape3D((Geometry)geom, app);
        return shape;
    }

    public TransformGroup parseShape(Node node) {
        TransformGroup ret = new TransformGroup();
        Appearance app = new Appearance();
        List list = node.selectNodes("*");
        for (Element element : list) {
            if (!"Appearance".equals(element.getName())) continue;
            app = this.parseAppearance((Node)element);
        }
        list = node.selectNodes("*");
        for (Element element : list) {
            if ("Cylinder".equals(element.getName())) {
                ret.addChild((javax.media.j3d.Node)this.parseCylinder((Node)element, app));
            }
            if ("Box".equals(element.getName())) {
                ret.addChild((javax.media.j3d.Node)this.parseBox((Node)element, app));
            }
            if ("Sphere".equals(element.getName())) {
                ret.addChild((javax.media.j3d.Node)this.parseSphere((Node)element, app));
            }
            if ("Cone".equals(element.getName())) {
                ret.addChild((javax.media.j3d.Node)this.parseCone((Node)element, app));
            }
            if (!"IndexedFaceSet".equals(element.getName())) continue;
            ret.addChild((javax.media.j3d.Node)this.parseIndexedFaceSet((Node)element, app));
        }
        return ret;
    }

    public TransformGroup parse() throws DocumentException {
        TransformGroup tr = new TransformGroup();
        Document doc = null;
        try {
            doc = this.initparse(this.fileX3d);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
        List list = doc.selectNodes("//X3D/*");
        for (Element element : list) {
            if (!"Scene".equals(element.getName())) continue;
            tr.addChild((javax.media.j3d.Node)this.parseScene((Node)element));
        }
        return tr;
    }

    public boolean validateDtd() {
        boolean flag;
        try {
            XMLValidator xmlVal = new XMLValidator(this.fileX3d.toString(), this.fileSchema);
            xmlVal.validate();
            flag = true;
        }
        catch (Exception e1) {
            flag = false;
        }
        return flag;
    }
}

