/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.ReflectionUtil;

public class XMLUtil {
    public static String[] validate(InputStream isXML, File schemaFile) throws ParserConfigurationException {
        return XMLUtil.validate(isXML, XMLUtil.getAsSchema(schemaFile));
    }

    public static String[] validate(String xmlStr, File schemaFile) throws ParserConfigurationException {
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlStr.getBytes());
        return XMLUtil.validate((InputStream)bais, XMLUtil.getAsSchema(schemaFile));
    }

    public static String[] validate(InputStream isXML, Schema schema) throws ParserConfigurationException {
        String[] vmsgs = XMLUtil.validateXMLWorker(isXML, schema);
        try {
            isXML.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (vmsgs.length != 0) {
            String strMsg = "Invalid XML!\n";
            for (String str : vmsgs) {
                strMsg = strMsg + "\n" + str;
            }
            NeptusLog.pub().error((Object)(ReflectionUtil.getCallerStamp() + "XML Validator: " + strMsg));
            return vmsgs;
        }
        return new String[0];
    }

    public static Schema getAsSchema(File schemaFile) {
        SchemaFactory sm = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = sm.newSchema(schemaFile);
            return schema;
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)(ReflectionUtil.getCallerStamp() + e.getMessage()));
            return null;
        }
    }

    private static String[] validateXMLWorker(InputStream is, Schema schema) {
        final Vector<String> validationMsgs = new Vector<String>();
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                validationMsgs.add("WARNING: " + exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                validationMsgs.add("ERROR: " + exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                validationMsgs.add("FATAL: " + exception.getMessage());
            }
        });
        try {
            validator.validate(new StreamSource(is));
        }
        catch (Exception e) {
            validationMsgs.add("SOURCE: " + e.getMessage());
        }
        return validationMsgs.toArray(new String[validationMsgs.size()]);
    }

    public static String getAsPrettyPrintFormatedXMLString(String xmlStr) {
        String tmp1 = FileUtil.getAsPrettyPrintFormatedXMLString("<AAzZ>" + xmlStr + "</AAzZ>", true);
        return tmp1.replaceAll("^[[\\s]*?]?<AAzZ>", "").replaceAll("[[\\s]]*?]?</AAzZ>$", "").replaceAll("(?m)^  ", "").replaceAll("^\\n", "");
    }

    public static String getAsCompactFormatedXMLString(String tmpStr) {
        String tmp1 = FileUtil.getAsCompactFormatedXMLString("<AAzZ>" + tmpStr + "</AAzZ>", true);
        return tmp1.replaceAll("^<AAzZ>", "").replaceAll("</AAzZ>$", "");
    }

    public static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            NeptusLog.pub().info((Object)"<###>nodeToString Transformer Exception");
        }
        return sw.toString();
    }

    public static String nodeChildsToString(Node node) {
        String nodeName = node.getNodeName();
        String ret = XMLUtil.nodeToString(node);
        return ret.replaceAll("^<" + nodeName + ">", "").replaceAll("</" + nodeName + ">$", "");
    }

    public static Document createDocumentFromXmlString(String xmlStr) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
            docBuilderFactory.setNamespaceAware(false);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlStr.getBytes());
            Document doc = builder.parse(bais);
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String test = "<Profile name=\"P1\">\n<Component id=\"1\"/>\n</Profile>\n<Profile name=\"P2\">\n<Component id=\"2\"/>\n</Profile>";
        NeptusLog.pub().info((Object)("<###>'" + XMLUtil.getAsCompactFormatedXMLString(test) + "'"));
        NeptusLog.pub().info((Object)("<###>'" + XMLUtil.getAsPrettyPrintFormatedXMLString(test) + "'"));
        Document doc = XMLUtil.createDocumentFromXmlString("<root>fd" + test + "</root>");
        NeptusLog.pub().info((Object)("<###> " + XMLUtil.nodeToString(doc.getDocumentElement())));
        NeptusLog.pub().info((Object)("<###> " + XMLUtil.nodeChildsToString(doc.getDocumentElement())));
    }
}

