/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.util.XMLErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import pt.lsts.neptus.NeptusLog;

public class XMLValidator {
    private String schemaURI;
    private Document document = DocumentHelper.createDocument();

    private void logValidation(String log_output) {
        NeptusLog.pub().debug((Object)(this.toString() + log_output));
    }

    public XMLValidator() {
    }

    public XMLValidator(String schemaURI) {
        this.schemaURI = schemaURI;
    }

    public XMLValidator(Document document, String schemaURI) throws DocumentException {
        if (document.equals(null)) {
            throw new DocumentException("validator init: dom4j Document is null");
        }
        this.document = document;
        if (schemaURI.equals(null) || schemaURI.equals("")) {
            throw new DocumentException("validator init: schema is null or empty");
        }
        this.schemaURI = schemaURI;
    }

    public XMLValidator(String xmlString, String schemaURI) throws DocumentException {
        if (xmlString.equals(null)) {
            throw new DocumentException("validator init: xmlString could not be parsed; xmlString is null");
        }
        this.document = DocumentHelper.parseText((String)xmlString);
        if (schemaURI.equals(null) || schemaURI.equals("")) {
            throw new DocumentException("validator init: schema is null or empty");
        }
        this.schemaURI = schemaURI;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setSchemaURI(String string) {
        this.schemaURI = string;
    }

    public boolean validate() throws DocumentException, IOException, SAXException {
        long initTime = System.currentTimeMillis();
        if (this.document == null) {
            throw new DocumentException("validate: dom4j Document is null");
        }
        if (this.schemaURI.equals(null) || this.schemaURI.equals("")) {
            throw new DocumentException("validate: schema is null or empty");
        }
        String xmlDoc = this.document.asXML();
        StringReader xmlDocReader = new StringReader(xmlDoc);
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)this.schemaURI);
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        reader.setErrorHandler((ErrorHandler)errorHandler);
        Document document = reader.read((Reader)xmlDocReader);
        Element errorEle = errorHandler.getErrors();
        StringWriter logOut = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)logOut, OutputFormat.createPrettyPrint());
        writer.write(errorHandler.getErrors());
        if (errorEle.hasContent()) {
            this.logValidation("Validation of Document with root element \"" + document.getRootElement().getName() + "\" against schema @ \"" + this.schemaURI + "\" failed because of:" + logOut.toString());
        }
        long totalTime = System.currentTimeMillis() - initTime;
        this.logValidation("Total validation time: " + totalTime + " ms.");
        return !errorEle.hasContent();
    }

    public boolean validate(File file) throws DocumentException, IOException, SAXException {
        this.document = this.read(file);
        if (this.document == null) {
            throw new DocumentException("validate: dom4j Document is null");
        }
        if (this.schemaURI.equals(null) || this.schemaURI.equals("")) {
            throw new DocumentException("validate: schema is null or empty");
        }
        String xmlDoc = this.document.asXML();
        StringReader xmlDocReader = new StringReader(xmlDoc);
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)this.schemaURI);
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        reader.setErrorHandler((ErrorHandler)errorHandler);
        Document document = reader.read((Reader)xmlDocReader);
        Element errorEle = errorHandler.getErrors();
        StringWriter logOut = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)logOut, OutputFormat.createPrettyPrint());
        writer.write(errorHandler.getErrors());
        if (errorEle.hasContent()) {
            this.logValidation("Validation of the XML File with root element \"" + document.getRootElement().getName() + "\" against schema @ \"" + this.schemaURI + "\" failed because of:" + logOut.toString());
        }
        return !errorEle.hasContent();
    }

    public boolean isXML(File file) {
        return this.read(file) != null;
    }

    private final Document read(File file) {
        Document ret = null;
        if (file.exists()) {
            try {
                SAXReader reader = new SAXReader();
                ret = reader.read(file);
            }
            catch (Exception e) {
                this.logValidation("Validation: File was not XML");
                return null;
            }
        } else {
            System.err.println("Validation: Sorry, object file not found.\n\nPlease check if it is located in: " + file.getAbsolutePath());
        }
        return ret;
    }
}

