/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.taskdefs.ExpandStriped;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.StreamUtil;

public class ZipUtils {
    public static boolean unZip(String zipFile, String destinationPath) {
        try {
            java.util.zip.ZipEntry zipEntry;
            FileInputStream fxInStream = new FileInputStream(zipFile);
            ZipInputStream zInStream = new ZipInputStream(fxInStream);
            File destination = new File(destinationPath).getAbsoluteFile();
            destination.mkdirs();
            while ((zipEntry = zInStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    File dir = new File(destinationPath, zipEntry.getName());
                    boolean bl = dir.mkdirs();
                    NeptusLog.pub().debug((Object)("Created dir (" + bl + "): " + dir.getAbsolutePath()));
                    continue;
                }
                File file = new File(destinationPath, zipEntry.getName());
                file.getParentFile().mkdirs();
                FileOutputStream fxOutStream = new FileOutputStream(file);
                boolean bl = StreamUtil.copyStreamToStream(zInStream, fxOutStream);
                NeptusLog.pub().debug((Object)("Created file(" + bl + "): " + zipEntry.getName()));
            }
            zInStream.close();
            return true;
        }
        catch (IllegalArgumentException e) {
            NeptusLog.pub().debug((Object)"unZip: found Zip with encoding IBM437. Running alternateUnzip!");
            return ZipUtils.alternateUnzip(zipFile, destinationPath, "ibm437");
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error((Object)"unZip", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"unZip", (Throwable)e);
            return false;
        }
    }

    private static boolean alternateUnzip(String zipFile, String destinationPath, String encoding) {
        try {
            File sourceZip = new File(zipFile).getAbsoluteFile();
            File destination = new File(destinationPath).getAbsoluteFile();
            ExpandStriped exp = new ExpandStriped();
            exp.setEncoding(encoding);
            exp.expandFile(sourceZip, destination);
            return true;
        }
        catch (RuntimeException e) {
            NeptusLog.pub().error((Object)"alternateUnzip", (Throwable)e);
            return false;
        }
    }

    public static boolean zipDir(String zipFile, String sourceDir, String encoding) {
        try {
            FileOutputStream fxOutStream = new FileOutputStream(zipFile);
            ZipOutputStream zOutStream = new ZipOutputStream(fxOutStream);
            zOutStream.setEncoding(encoding);
            ZipUtils.zipDirWorker(sourceDir, sourceDir, zOutStream);
            zOutStream.close();
            fxOutStream.flush();
            fxOutStream.close();
            return true;
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error((Object)"zipDir", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"zipDir", (Throwable)e);
            return false;
        }
    }

    public static boolean zipDir(String zipFile, String sourceDir) {
        if (Charset.isSupported("ibm437")) {
            return ZipUtils.zipDir(zipFile, sourceDir, "ibm437");
        }
        return ZipUtils.zipDir(zipFile, sourceDir, null);
    }

    private static void zipDirWorker(String dir2zip, String baseDir, ZipOutputStream zOutStream) {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                ZipUtils.zipDirWorker(filePath, baseDir, zOutStream);
                continue;
            }
            ZipUtils.addZipEntry(FileUtil.relativizeFilePath(baseDir, f.getPath()), f.getPath(), zOutStream);
        }
    }

    private static boolean addZipEntry(String entryName, String filePath, ZipOutputStream zOutStream) {
        try {
            entryName = entryName.replace('\\', '/');
            ZipEntry zEntry = new ZipEntry(entryName);
            FileInputStream fxInStream = new FileInputStream(filePath);
            zOutStream.putNextEntry(zEntry);
            boolean bl = StreamUtil.copyStreamToStream(fxInStream, zOutStream);
            zOutStream.flush();
            zOutStream.closeEntry();
            fxInStream.close();
            return bl;
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error((Object)"addZipEntry", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"addZipEntry", (Throwable)e);
            return false;
        }
    }

    public static InputStream getMissionZipedAsInputSteam(String zipFile) {
        boolean missionFileFound = false;
        try {
            java.util.zip.ZipEntry zipEntry;
            FileInputStream fxInStream = new FileInputStream(zipFile);
            ZipInputStream zInStream = new ZipInputStream(fxInStream);
            while ((zipEntry = zInStream.getNextEntry()) != null) {
                String fileZname;
                if (zipEntry.isDirectory() || !(fileZname = zipEntry.getName()).equalsIgnoreCase("mission.nmis")) continue;
                missionFileFound = true;
                break;
            }
            if (missionFileFound) {
                return zInStream;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            NeptusLog.pub().debug((Object)"unZip: found Zip with encoding IBM437. Running alternateUnzip!");
            return null;
        }
        catch (FileNotFoundException e) {
            NeptusLog.pub().error((Object)"unZip", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"unZip", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
    }
}

