/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.bathymetry;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.bathymetry.TideDataFetcher;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class CachedData
extends TidePredictionFinder {
    private boolean loading = true;
    private SortedSet<TidePeak> cachedData = null;

    public CachedData(File f) {
        try {
            this.loadFile(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loading = false;
    }

    public CachedData() {
        this(GeneralPreferences.tidesFile);
    }

    public void loadFile(File f) throws Exception {
        this.cachedData = new TreeSet<TidePeak>();
        if (f == null || !f.canRead()) {
            NeptusLog.pub().error((Object)new Exception("Tides file is not valid: " + f));
            return;
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        String line = br.readLine();
        while (line != null) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(",");
            long unixTimeSecs = Long.parseLong(parts[2]);
            double height = Double.parseDouble(parts[3]);
            Date d = new Date(unixTimeSecs * 1000L);
            this.cachedData.add(new TidePeak(d, height));
            line = br.readLine();
        }
        br.close();
    }

    public void saveFile(String port, File f) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(f));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (TidePeak tp : this.cachedData) {
            writer.write(port + "," + sdf.format(tp.date) + "," + tp.date.getTime() / 1000L + "," + tp.height + "\n");
        }
        writer.close();
    }

    public void update(Vector<TidePeak> newData) {
        Collections.sort(newData);
        TidePeak removeFirst = new TidePeak(new Date(newData.firstElement().date.getTime() - 18000000L), 0.0);
        TidePeak removeLast = new TidePeak(new Date(newData.firstElement().date.getTime() + 18000000L), 0.0);
        Vector<TidePeak> toRemove = new Vector<TidePeak>();
        toRemove.addAll(this.cachedData.subSet(removeFirst, removeLast));
        this.cachedData.removeAll(toRemove);
        this.cachedData.addAll(newData);
    }

    public boolean contains(Date d) {
        while (this.loading) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TidePeak instant = new TidePeak(d, 0.0);
        SortedSet<TidePeak> after = this.cachedData.tailSet(instant);
        SortedSet<TidePeak> before = this.cachedData.headSet(instant);
        if (after.isEmpty() || before.isEmpty()) {
            return false;
        }
        TidePeak immediatelyBefore = before.last();
        TidePeak immediatelyAfter = after.first();
        if (instant.date.getTime() - immediatelyBefore.date.getTime() > 43200000L) {
            return false;
        }
        return immediatelyAfter.date.getTime() - instant.date.getTime() <= 43200000L;
    }

    public void showSettings() {
        PluginUtils.editPluginProperties(this, true);
        try {
            PluginUtils.saveProperties("conf/conf/cachedData.properties", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Float getTidePrediction(Date date, boolean print) throws Exception {
        if (!this.contains(date)) {
            return null;
        }
        TidePeak instant = new TidePeak(date, 0.0);
        TidePeak after = this.cachedData.tailSet(instant).first();
        TidePeak before = this.cachedData.headSet(instant).last();
        double totalTime = after.date.getTime() - before.date.getTime();
        double ellapsedTime = date.getTime() - before.date.getTime();
        double h1 = (before.height + after.height) / 2.0;
        double h2 = (before.height - after.height) / 2.0;
        double h3 = Math.cos(Math.PI * ellapsedTime / totalTime);
        return Float.valueOf((float)(h1 + h2 * h3));
    }

    public Date fetchData(String portName, Date aroundDate) throws Exception {
        try {
            Vector<TidePeak> newData = TideDataFetcher.fetchData(portName, aroundDate);
            System.out.println("Retrieved " + newData.size() + " new tide points.");
            if (newData.size() == 0) {
                Thread.sleep(3000L);
                return null;
            }
            this.update(newData);
            this.saveFile(portName, new File(GeneralPreferences.tidesFile.getParentFile(), portName + ".txt"));
            return newData.lastElement().date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void fetchData(Component parent) {
        Vector<String> harbors = new Vector<String>();
        for (TideDataFetcher.Harbor h : TideDataFetcher.Harbor.values()) {
            harbors.add(h.toString());
        }
        String harbor = (String)JOptionPane.showInputDialog(parent, I18n.text("Please select harbor"), I18n.text("Fetch data"), 3, null, harbors.toArray(new String[0]), I18n.text((String)harbors.get(0)));
        if (harbor == null) {
            return;
        }
        Date start = null;
        Date end = null;
        while (start == null) {
            String startStr = JOptionPane.showInputDialog(parent, I18n.text("Days to fetch in the past"), 365);
            try {
                if (startStr == null) {
                    return;
                }
                long days = Integer.parseInt(startStr);
                if (days < 0L) continue;
                start = new Date(System.currentTimeMillis() - days * 24L * 3600L * 1000L);
                System.out.println(start);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (end == null) {
            String endStr = JOptionPane.showInputDialog(parent, I18n.text("Days to fetch in the future"), 365);
            try {
                if (endStr == null) {
                    return;
                }
                long days = Integer.parseInt(endStr);
                if (days < 0L) continue;
                end = new Date(System.currentTimeMillis() + days * 24L * 3600L * 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CachedData data = new CachedData(new File("conf/tides/" + harbor + ".txt"));
        Date current = new Date(start.getTime());
        while (current.getTime() < end.getTime()) {
            try {
                Date d = data.fetchData(harbor, current);
                if (d != null) {
                    current = new Date(current.getTime() + 432000000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(current);
        }
        try {
            data.saveFile(harbor, new File("conf/tides/" + harbor + ".txt"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        GuiUtils.setLookAndFeel();
        CachedData.fetchData(null);
    }

    static class TidePeak
    implements Comparable<TidePeak> {
        public double height;
        public Date date;

        public TidePeak(Date date, double height) {
            this.date = date;
            this.height = height;
        }

        public TidePeak(int unixTimeSecs, double height) {
            this.date = new Date(unixTimeSecs * 1000);
            this.height = height;
        }

        @Override
        public int compareTo(TidePeak o) {
            return this.date.compareTo(o.date);
        }

        public String toString() {
            return this.date + ": " + this.height + " m";
        }
    }
}

