/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.bathymetry;

import java.io.File;
import java.util.ArrayList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.importers.deltat.DeltaTParser;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.llf.LsfLogSource;

public class GeoQuadTree<O> {
    static int num = 0;
    GeoQuadTree<O> northWest;
    GeoQuadTree<O> northEast;
    GeoQuadTree<O> southWest;
    GeoQuadTree<O> southEast;
    ArrayList<O> list;
    int capacity;
    double minLat;
    double minLon;
    double maxLat;
    double maxLon;

    public GeoQuadTree(int capacity, double minLat, double minLon, double maxLat, double maxLon) {
        this.capacity = capacity;
        this.minLat = minLat;
        this.minLon = minLon;
        this.maxLat = maxLat;
        this.maxLon = maxLon;
        this.list = new ArrayList(capacity);
        System.out.println(minLat + " " + minLon + " " + maxLat + " " + maxLon);
        ++num;
    }

    public boolean insert(O obj) {
        if (!this.contains(obj)) {
            return false;
        }
        if (this.list.size() < this.capacity) {
            this.list.add(obj);
            return true;
        }
        if (this.northWest == null) {
            this.subdivide();
        }
        if (this.northWest.insert(obj)) {
            return true;
        }
        if (this.northEast.insert(obj)) {
            return true;
        }
        if (this.southWest.insert(obj)) {
            return true;
        }
        if (this.southEast.insert(obj)) {
            return true;
        }
        System.out.println("error");
        return false;
    }

    public void subdivide() {
        double hdeltaLat = (this.maxLat - this.minLat) / 2.0;
        double hdeltaLon = (this.maxLon - this.minLon) / 2.0;
        this.northWest = new GeoQuadTree<O>(this.capacity, this.minLat + hdeltaLat, this.minLon, this.maxLat, this.minLon + hdeltaLon);
        this.northEast = new GeoQuadTree<O>(this.capacity, this.minLat + hdeltaLat, this.minLon + hdeltaLon, this.maxLat, this.maxLon);
        this.southWest = new GeoQuadTree<O>(this.capacity, this.minLat, this.minLon, this.minLat + hdeltaLat, this.minLon + hdeltaLon);
        this.southEast = new GeoQuadTree<O>(this.capacity, this.minLat, this.minLon + hdeltaLon, this.minLat + hdeltaLat, this.maxLon);
        System.out.println();
    }

    boolean contains(O obj) {
        BathymetrySwath s = (BathymetrySwath)obj;
        LocationType loc = s.getPose().getPosition();
        return loc.getLatitudeDegs() < this.maxLat && loc.getLatitudeDegs() > this.minLat && loc.getLongitudeDegs() < this.maxLon && loc.getLongitudeDegs() > this.minLon;
    }

    public static void main(String[] args) {
        GeoQuadTree<BathymetrySwath> tree = new GeoQuadTree<BathymetrySwath>(5000, -90.0, -180.0, 90.0, 180.0);
        try {
            BathymetrySwath s;
            LsfLogSource source = new LsfLogSource(new File("/home/jqcorreia/lsts/logs/lauv-noptilus-1/20130208/124645_bathym_plan/Data.lsf"), null);
            DeltaTParser p = new DeltaTParser(source);
            int c = 0;
            while ((s = p.nextSwath()) != null) {
                ++c;
                tree.insert(s);
            }
            NeptusLog.pub().info((Object)("<###> " + c));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(num);
    }
}

