/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.bathymetry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import pt.lsts.neptus.util.bathymetry.TidePrediction;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;

public class LocalData
extends TidePredictionFinder {
    private final int minChars = 23;
    private final File tides;

    public LocalData(File file) {
        this.tides = file;
        if (file != null) {
            try {
                this.predictions = new ArrayList();
                this.buildKnowledge();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Float getTidePrediction(Date date, boolean print) throws Exception {
        if (this.predictions == null || this.predictions.size() < 2) {
            return Float.valueOf(0.0f);
        }
        int first = -1;
        boolean foundSecond = false;
        for (int iTide = 0; iTide < this.predictions.size() && !foundSecond; ++iTide) {
            TidePrediction tide = (TidePrediction)this.predictions.get(iTide);
            Date tideDate = tide.getTimeAndDate();
            if (tideDate.equals(date)) {
                return Float.valueOf(tide.getHeight());
            }
            if (tideDate.before(date)) {
                first = iTide;
                continue;
            }
            if (!tideDate.after(date)) continue;
            foundSecond = true;
        }
        if (!foundSecond || first == -1) {
            return Float.valueOf(0.0f);
        }
        return this.findPrediction(date, first);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildKnowledge() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.tides.toString()));){
            String line = br.readLine();
            while (line != null && line.length() >= 23) {
                String[] lineTokens = line.split(" ");
                String[] dateTokens = lineTokens[0].split("-");
                GregorianCalendar dayCal = new GregorianCalendar(new Integer(dateTokens[2]), new Integer(dateTokens[1]) - 1, new Integer(dateTokens[0]));
                block8: for (int i = 1; i < lineTokens.length; ++i) {
                    String[] timeTokens = lineTokens[i].split("h");
                    GregorianCalendar timeCal = (GregorianCalendar)dayCal.clone();
                    timeCal.add(11, new Integer(timeTokens[0]));
                    timeCal.add(12, new Integer(timeTokens[1]));
                    timeTokens = lineTokens[++i].split("[:.:]");
                    Float height = new Float(timeTokens[0]);
                    Float decimal = new Float(timeTokens[1]);
                    for (int j = 0; j < timeTokens.length; ++j) {
                        decimal = Float.valueOf(decimal.floatValue() / 10.0f);
                    }
                    height = Float.valueOf(height.floatValue() + decimal.floatValue());
                    char tide = lineTokens[++i].charAt(0);
                    switch (tide) {
                        case 'L': {
                            this.predictions.add(new TidePrediction(height.floatValue(), timeCal.getTime(), TidePrediction.TIDE_TYPE.LOW_TIDE));
                            continue block8;
                        }
                        case 'H': {
                            this.predictions.add(new TidePrediction(height.floatValue(), timeCal.getTime(), TidePrediction.TIDE_TYPE.HIGH_TIDE));
                        }
                    }
                }
                line = br.readLine();
            }
        }
    }
}

