/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.bathymetry;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import pt.lsts.neptus.util.bathymetry.CachedData;

public class TideDataFetcher {
    private static String fetchCookies() throws Exception {
        URL url = new URL("http://www.hidrografico.pt/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        String cookies = "";
        String headerName = null;
        int i = 1;
        while ((headerName = conn.getHeaderFieldKey(i)) != null) {
            if (headerName.equals("Set-Cookie")) {
                String cookie = conn.getHeaderField(i);
                if (cookie.indexOf(";") != -1) {
                    cookie = cookie.substring(0, cookie.indexOf(";"));
                }
                cookies = cookies.isEmpty() ? cookie : cookies + "; " + cookie;
            }
            ++i;
        }
        conn.disconnect();
        return cookies;
    }

    public static Vector<CachedData.TidePeak> fetchData(String port, Date aroundDate) throws Exception {
        String cookies = TideDataFetcher.fetchCookies();
        Harbor harbor = Harbor.valueOf(port);
        if (harbor == null) {
            throw new Exception("Harbor is unknown: " + port);
        }
        URL url = new URL("http://www.hidrografico.pt/components/com_products/scripts/server/data_getportdetail.php");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String post = "codp=" + harbor.id_prim + "&porcodp=" + harbor.id_sec + "&epoch=" + aroundDate.getTime() / 1000L + "&detail=1&display=0";
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Cookie", cookies);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        conn.connect();
        wr.writeBytes(post);
        wr.flush();
        wr.close();
        Document doc = Jsoup.parse((InputStream)conn.getInputStream(), (String)"UTF-8", (String)"");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Vector<CachedData.TidePeak> ret = new Vector<CachedData.TidePeak>();
        Elements elems = doc.getElementsByTag("tr");
        for (int i = 0; i < elems.size(); ++i) {
            Vector<String> cells = new Vector<String>();
            for (Element el : elems.get(i).children()) {
                cells.add(el.text().replaceAll("\\u00A0", ""));
            }
            if (cells.size() < 3) continue;
            String date = ((String)cells.firstElement()).substring(5);
            String height = (String)cells.get(cells.size() - 2);
            try {
                ret.add(new CachedData.TidePeak(sdf.parse(date), Double.parseDouble(height)));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static enum Harbor {
        Leixoes(12, 0),
        DouroCapitania(50, 12),
        DouroCrestuma(42, 12),
        VianaDoCastelo(74, 0),
        PovoaDeVarzim(49, 74),
        Caminha(63, 74),
        Esposende(68, 74),
        VilaDoConde(69, 74),
        Aveiro(13, 0),
        FigueiraDaFoz(73, 0),
        Peniche(29, 0),
        Nazare(65, 29),
        Lisboa(16, 0),
        Seixal(39, 16),
        Alfeite(58, 16),
        Trafaria(35, 16),
        Cascais(15, 0),
        Setubal(20, 0),
        Sesimbra(28, 0),
        Sines(43, 0),
        Lagos(18, 0),
        Faro(19, 0),
        VilaRealSantoAntonio(21, 0);

        protected int id_prim;
        protected int id_sec;

        public long id_prim() {
            return this.id_prim;
        }

        private Harbor(int id_prim, int id_sec) {
            this.id_prim = id_prim;
            this.id_sec = id_sec;
        }
    }
}

