/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.bathymetry;

import java.io.File;
import java.util.Date;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.util.bathymetry.CachedData;
import pt.lsts.neptus.util.bathymetry.LocalData;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;

public class TidePredictionFactory {
    public static TidePredictionFinder create(IMraLogGroup source) {
        CachedData data;
        TidePredictionFinder finder = null;
        File f = source.getFile("mra/tides.txt");
        finder = f.canRead() ? new LocalData(f) : ((data = new CachedData()).contains(new Date((long)source.getLsfIndex().getStartTime() * 1000L)) ? data : null);
        return finder;
    }

    public static TidePredictionFinder create(LsfIndex source) {
        CachedData data;
        TidePredictionFinder finder = null;
        File f = new File(source.getLsfFile().getParentFile(), "mra/tides.txt");
        finder = f.canRead() ? new LocalData(f) : ((data = new CachedData()).contains(new Date((long)source.getStartTime() * 1000L)) ? data : null);
        return finder;
    }
}

