/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.bathymetry;

import java.util.ArrayList;
import java.util.Date;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.bathymetry.TidePrediction;

public abstract class TidePredictionFinder {
    protected ArrayList<TidePrediction> predictions;

    protected void logError(Exception e) {
        NeptusLog.pub().info((Object)"<###>[ERROR] There was a problem finding the tide prediction.", (Throwable)e);
    }

    protected Float ihFuncAfterHighTide(int indexFirstTide, Date wantedDate) {
        TidePrediction firstTide = this.predictions.get(indexFirstTide);
        TidePrediction secondTide = this.predictions.get(indexFirstTide + 1);
        float hHT = firstTide.getHeight();
        float hLT = secondTide.getHeight();
        float hightToLowT = secondTide.getTimeAndDate().getTime() - firstTide.getTimeAndDate().getTime();
        long wantedTime = wantedDate.getTime();
        float timeUntilNow = wantedTime - firstTide.getTimeAndDate().getTime();
        float waterHeight = (hHT + hLT) / 2.0f + (hHT - hLT) / 2.0f * (float)Math.cos((float)Math.PI * timeUntilNow / hightToLowT);
        return Float.valueOf(waterHeight);
    }

    protected Float ihFuncAfterLowTide(int indexFirstTide, Date wantedDate) {
        TidePrediction firstTide = this.predictions.get(indexFirstTide);
        TidePrediction secondTide = this.predictions.get(indexFirstTide + 1);
        float hLT = firstTide.getHeight();
        float hHT = secondTide.getHeight();
        float lowToHighT = secondTide.getTimeAndDate().getTime() - firstTide.getTimeAndDate().getTime();
        long wantedTime = wantedDate.getTime();
        float timeUntilNow = wantedTime - firstTide.getTimeAndDate().getTime();
        float waterHeight = (hHT + hLT) / 2.0f + (hLT - hHT) / 2.0f * (float)Math.cos((float)Math.PI * timeUntilNow / lowToHighT);
        return Float.valueOf(waterHeight);
    }

    public abstract Float getTidePrediction(Date var1, boolean var2) throws Exception;

    protected Float findPrediction(Date date, int iTide) {
        Float prediction = this.predictions.get(iTide).getTideType() == TidePrediction.TIDE_TYPE.HIGH_TIDE ? this.ihFuncAfterHighTide(iTide, date) : this.ihFuncAfterLowTide(iTide, date);
        return prediction;
    }

    public ArrayList<TidePrediction> getPredictionsMarks() {
        return this.predictions;
    }
}

