/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.bathymetry;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;

public class XYZDataUtil {
    public static void main(String[] args) throws IOException {
        FileInputStream fis = new FileInputStream("..\\Batimetria\\batimetria_leixoes.xyz");
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        Vector<Double> xvec = new Vector<Double>();
        Vector<Double> yvec = new Vector<Double>();
        Vector<Double> zvec = new Vector<Double>();
        String line = br.readLine();
        while (line != null) {
            String[] xt;
            if (!line.startsWith("#") && (xt = line.split("[\t ,]")).length == 3) {
                try {
                    double xx = Double.parseDouble(xt[1]);
                    double yy = Double.parseDouble(xt[0]);
                    double zz = Double.parseDouble(xt[2]);
                    xvec.add(xx);
                    yvec.add(yy);
                    zvec.add(zz);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            line = br.readLine();
        }
        br.close();
        NeptusLog.pub().info((Object)("<###>Number of points: " + xvec.size()));
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        Iterator i$ = xvec.iterator();
        while (i$.hasNext()) {
            double xt = (Double)i$.next();
            if (xt < minX) {
                minX = xt;
            }
            if (!(xt > maxX)) continue;
            maxX = xt;
        }
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        Iterator i$2 = yvec.iterator();
        while (i$2.hasNext()) {
            double yt = (Double)i$2.next();
            if (yt < minY) {
                minY = yt;
            }
            if (!(yt > maxY)) continue;
            maxY = yt;
        }
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        Iterator i$3 = zvec.iterator();
        while (i$3.hasNext()) {
            double zt = (Double)i$3.next();
            if (zt < minZ) {
                minZ = zt;
            }
            if (!(zt > maxZ)) continue;
            maxZ = zt;
        }
        NeptusLog.pub().info((Object)("<###>x = [" + minX + "," + maxX + "]" + "  \tdelta x = " + Math.round(maxX - minX)));
        NeptusLog.pub().info((Object)("<###>y = [" + minY + "," + maxY + "]" + "  \tdelta y = " + Math.round(maxY - minY)));
        NeptusLog.pub().info((Object)("<###>z = [" + minZ + "," + maxZ + "]" + "  \t\tdelta z = " + Math.round(maxZ - minZ)));
        double[] dim = new double[]{maxX - minX, maxY - minY};
        double scale = 1.0;
        int defaultWidth = 1024;
        int defaultHeight = 768;
        int width = defaultWidth;
        int height = defaultHeight;
        if (dim[1] < dim[0]) {
            height = defaultWidth;
            width = (int)(dim[1] * (double)height / dim[0]);
            scale = dim[0] / (double)height;
        } else {
            width = defaultHeight;
            height = (int)(dim[0] * (double)width / dim[1]);
            scale = dim[1] / (double)width;
        }
        new BufferedImage(width, height, 2);
        Point2D[] points = new Point2D[xvec.size()];
        NeptusLog.pub().info((Object)("<###>Scale: " + scale));
        LocationType baseLoc = new LocationType();
        baseLoc.setLatitudeStr("41N09'35.293''");
        baseLoc.setLongitudeStr("08W41'35.721''");
        baseLoc.translatePosition(-465778.48, -152987.42, 0.0);
        NeptusLog.pub().info((Object)("<###>Base location = " + baseLoc));
        LocationType topCorner = new LocationType(baseLoc);
        topCorner.translatePosition(maxX, minY, 0.0);
        NeptusLog.pub().info((Object)("<###>Top Left Corner location = " + topCorner));
        LocationType centerLocation = new LocationType(baseLoc);
        centerLocation.translatePosition(maxX - (maxX - minX) / 2.0, minY + (maxY - minY) / 2.0, 0.0);
        NeptusLog.pub().info((Object)("<###>Center location = " + centerLocation));
        LocationType bottomRightCorner = new LocationType(baseLoc);
        bottomRightCorner.translatePosition(maxX - (maxX - minX), minY + (maxY - minY), 0.0);
        NeptusLog.pub().info((Object)("<###>Bottom Right Corner location = " + bottomRightCorner));
        for (int i = 0; i < xvec.size(); ++i) {
            LocationType pLoc = new LocationType(baseLoc);
            baseLoc.translatePosition((Double)xvec.get(i), (Double)yvec.get(i), 0.0);
            double[] offsets = pLoc.getOffsetFrom(topCorner);
            points[i] = new Point2D.Double(offsets[0], offsets[1]);
            points[i] = new Point2D.Double((Double)xvec.get(i) - minX, (Double)yvec.get(i) - minY);
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, maxX - minX, maxY - minY);
        NeptusLog.pub().info((Object)("<###>BoundingBox: " + (maxX - minX) + " x " + (maxY - minY)));
        BufferedImage destination = new BufferedImage(width, height, 2);
        BufferedImage destination1 = new BufferedImage(width, height, 2);
        BufferedImage destination2 = new BufferedImage(width, height, 2);
        int gridSize = 297;
        double[][] kdkd = XYZDataUtil.discretizeQuadMatrix(gridSize, bounds, points, zvec.toArray(new Double[0]));
        double minZ1 = Double.POSITIVE_INFINITY;
        double maxZ1 = Double.NEGATIVE_INFINITY;
        double[][] arr$ = kdkd;
        int len$ = arr$.length;
        for (int i$4 = 0; i$4 < len$; ++i$4) {
            double[] zt1;
            for (double zt : zt1 = arr$[i$4]) {
                if (zt == Double.NaN) continue;
                if (zt < minZ1) {
                    minZ1 = zt;
                }
                if (!(zt > maxZ1)) continue;
                maxZ1 = zt;
            }
        }
        for (int i = 0; i < kdkd.length; ++i) {
            for (int j = 0; j < kdkd.length; ++j) {
                kdkd[i][j] = !Double.isNaN(kdkd[i][j]) ? 1.0 - (kdkd[i][j] - minZ1) / (maxZ1 - minZ1) : Double.NaN;
            }
        }
        double[][] kdkdinv = new double[kdkd.length][kdkd[0].length];
        for (int i = 0; i < kdkd.length; ++i) {
            for (int j = 0; j < kdkd.length; ++j) {
                kdkdinv[i][j] = !Double.isNaN(kdkd[i][j]) ? 1.0 - kdkd[i][j] : Double.NaN;
            }
        }
        XYZDataUtil.getInterpolatedData(kdkd, ColorMapFactory.createJetColorMap(), destination, 255);
        JLabel lblw = new JLabel(new ImageIcon(destination));
        GuiUtils.testFrame(lblw, "", 800, 600);
        XYZDataUtil.getInterpolatedData(kdkd, ColorMapFactory.createGrayScaleColorMap(), destination1, 255);
        JLabel lblw1 = new JLabel(new ImageIcon(destination1));
        GuiUtils.testFrame(lblw1, "", 800, 600);
        XYZDataUtil.getInterpolatedData(kdkdinv, ColorMapFactory.createGrayScaleColorMap(), destination2, 255);
        JLabel lblw2 = new JLabel(new ImageIcon(destination2));
        GuiUtils.testFrame(lblw2, "", 800, 600);
        try {
            ImageIO.write((RenderedImage)destination, "png", new File("bathyLeixoes-jet.png"));
            ImageIO.write((RenderedImage)destination1, "png", new File("bathyLeixoes-gray.png"));
            ImageIO.write((RenderedImage)destination2, "png", new File("bathyLeixoes-inv-gray.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MapType mapT = new MapType();
        mapT.setCenterLocation(centerLocation);
        CoordinateSystem cs = new CoordinateSystem();
        cs.setLocation(centerLocation);
        String imageNameId = "APDL-Bat";
        ImageElement imageElement = new ImageElement(MapGroup.getNewInstance(cs), mapT);
        imageElement.setId(imageNameId);
        imageElement.setCenterLocation(centerLocation);
        imageElement.setImageScale(scale);
        imageElement.setImage(destination);
        imageElement.setImageFileName("./bathyLeixoes-jet.png");
        imageElement.setOriginalFilePath(imageElement.getImageFileName());
        imageElement.setBathymetric(true);
        imageElement.setHeightImage(destination2);
        imageElement.setBathymetricImageFileName("./bathyLeixoes-inv-gray.png");
        imageElement.setMaxHeight(maxZ);
        imageElement.setMaxDepth(minZ);
        imageElement.setTransparency(100);
        mapT.setId("map-" + imageNameId);
        mapT.setName("map-" + imageNameId);
        mapT.setOriginalFilePath("./map-" + imageNameId + ".nmap");
        mapT.setHref("./map-" + imageNameId + ".nmap");
        imageElement.setParentMap(mapT);
        mapT.addObject(imageElement);
        mapT.saveFile("./map-" + imageNameId + ".nmap");
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString(mapT.asXML())));
    }

    private static double[][] discretizeQuadMatrix(int gridSize, Rectangle2D bounds, Point2D[] points, Double[] values) {
        double dx = bounds.getWidth() / (double)gridSize;
        double dy = bounds.getHeight() / (double)gridSize;
        Double[] vals = new Double[gridSize * gridSize];
        int[] numPoints = new int[gridSize * gridSize];
        for (int i = 0; i < points.length; ++i) {
            Point2D pt = points[i];
            int indX = (int)Math.floor((pt.getX() - bounds.getMinX()) / dx);
            int indY = (int)Math.floor((pt.getY() - bounds.getMinY()) / dy);
            int ind = indX * gridSize + indY;
            ind = Math.min(indX * gridSize + indY, gridSize * gridSize - 1);
            vals[ind] = vals[ind] == null ? values[i] : Double.valueOf(((double)numPoints[ind] * vals[ind] + values[i]) / (double)(numPoints[ind] + 1));
            int n = ind;
            numPoints[n] = numPoints[n] + 1;
        }
        int sizeG = (int)Math.floor(Math.sqrt(vals.length));
        double[][] ret = new double[sizeG][sizeG];
        for (int i = 0; i < ret.length; ++i) {
            for (int j = 0; j < ret.length; ++j) {
                ret[i][j] = vals[i * ret.length + j] != null ? vals[i * ret.length + j] : Double.NaN;
            }
        }
        return ret;
    }

    private static void getInterpolatedData(double[][] data, ColorMap colormap, BufferedImage destination, int alpha) {
        BufferedImage tmp = new BufferedImage(data[0].length, data.length, 2);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (Double.isNaN(data[i][j])) continue;
                Color c = colormap.getColor(data[i][j]);
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                tmp.setRGB(j, data.length - 1 - i, c.getRGB());
            }
        }
        Graphics2D bg = destination.createGraphics();
        bg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        bg.scale((double)destination.getWidth() / (double)tmp.getWidth(), (double)destination.getHeight() / (double)tmp.getHeight());
        bg.drawImage((Image)tmp, 0, 0, null);
    }
}

