/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.conf;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.NameNormalizer;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.output.OutputMonitor;

public class ConfigFetch {
    private static boolean onLockedMode = false;
    public static final short OS_ERROR = -1;
    public static final short OS_WINDOWS = 0;
    public static final short OS_LINUX = 1;
    public static final short OS_OTHER = 9;
    public static final String DS = System.getProperty("file.separator", "/");
    public static final long STARTTIME = System.currentTimeMillis();
    public static long mark = System.currentTimeMillis();
    public static Map<String, Long> timings = new HashMap<String, Long>();
    protected static boolean schemasInTempFile = false;
    protected static final Hashtable<String, String> listOfSchemas = new Hashtable();
    protected static final Hashtable<String, String> listOfSchemasPaths = new Hashtable();
    public static ENVIROMENT ENV = ENVIROMENT.DEVELOPMENT;
    private static final String VERSION_FILE_NAME = "/version.txt";
    private static final String VERSION__EXTENDED_FILE_NAME = "/info";
    protected static final String classPackage = "pt/lsts/neptus/util/conf";
    protected static final String className = "ConfigFetch.class";
    private static final String CONFIG_FILE_NAME = "neptus-config.xml";
    protected static Document confDoc;
    protected static String configFile;
    protected static String baseJarFileDir;
    protected static boolean ifLogger;
    private static boolean distributionSetChangedOrGet;
    private static NeptusProperty.DistributionEnum distributionType;
    protected static final String neptusTmpDir;
    protected static String[] parentPaths;
    protected static Component superParentFrame;
    private static Hashtable<String, String> params;
    public BufferedWriter bw;
    public BufferedWriter bwhale;
    private static boolean alreadyInitialized;
    private static long neptusInitializationTime;
    public static ConfigFetch INSTANCE;

    private ConfigFetch() {
        this(configFile, true);
    }

    private ConfigFetch(String configFile, boolean ifLog) {
        if (ConfigFetch.class.getResource(VERSION_FILE_NAME).toString().startsWith("jar:")) {
            ENV = ENVIROMENT.PRODUCTION;
        }
        OutputMonitor.grab();
        NeptusLog.init();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                NeptusLog.pub().error((Object)("Uncaught Exception! " + ReflectionUtil.getCallerStamp()), e);
            }
        });
        ifLogger = ifLog;
        neptusInitializationTime = System.currentTimeMillis();
        this.init();
        ConfigFetch.loadSchemas();
        String fxt = ConfigFetch.resolvePath(configFile);
        NeptusLog.pub().info((Object)("Config. file found in: " + fxt));
        if (fxt != null) {
            ConfigFetch.configFile = fxt;
        }
        GeneralPreferences.initialize();
        this.load();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                FileUtil.deltree(neptusTmpDir);
                OutputMonitor.end();
            }
        }));
    }

    private ConfigFetch(boolean ifLog) {
        this(configFile, ifLog);
    }

    private ConfigFetch(String configFile) {
        this(configFile, true);
    }

    public static boolean initialize() {
        if (INSTANCE != null) {
            return true;
        }
        try {
            INSTANCE = new ConfigFetch();
        }
        catch (RuntimeException e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
            return false;
        }
        return true;
    }

    public static boolean initialize(String configFile, boolean ifLog) {
        if (INSTANCE != null) {
            return true;
        }
        try {
            INSTANCE = new ConfigFetch(configFile, ifLog);
        }
        catch (RuntimeException e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
            return false;
        }
        return true;
    }

    public static boolean initialize(boolean ifLog) {
        if (INSTANCE != null) {
            return true;
        }
        try {
            INSTANCE = new ConfigFetch(ifLog);
        }
        catch (RuntimeException e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
            return false;
        }
        return true;
    }

    public static boolean initialize(String configFile) {
        if (INSTANCE != null) {
            return true;
        }
        try {
            INSTANCE = new ConfigFetch(configFile);
        }
        catch (RuntimeException e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
            return false;
        }
        return true;
    }

    private boolean init() {
        if (alreadyInitialized) {
            return true;
        }
        alreadyInitialized = true;
        File fxTmpDir = new File(ConfigFetch.getNeptusTmpDir());
        fxTmpDir.mkdirs();
        fxTmpDir.deleteOnExit();
        try {
            String inFileName = ConfigFetch.class.getResource("/pt/lsts/neptus/util/conf/ConfigFetch.class").getFile();
            String strNeptusVersion = "Starting Neptus " + ConfigFetch.getVersionSimpleString() + " ...";
            String strJavaVersion = "Using Java from: " + System.getProperty("java.vendor") + " | Version: " + System.getProperty("java.version");
            String strOSVersion = "On OS: " + System.getProperty("os.name") + " | Version: " + System.getProperty("os.version") + " | Arch.: " + System.getProperty("os.arch");
            NeptusLog.pub().info((Object)strNeptusVersion);
            NeptusLog.pub().info((Object)strJavaVersion);
            NeptusLog.pub().info((Object)strOSVersion);
            String strNeptusExtendedVersionInfo = ConfigFetch.getVersionExtendedInfoSimpleString();
            if (strNeptusExtendedVersionInfo != null && strNeptusExtendedVersionInfo.length() > 0) {
                String str = "SCM Extended Info:\n";
                str = str + strNeptusExtendedVersionInfo;
                NeptusLog.pub().info((Object)str);
            }
            NeptusLog.pub().debug((Object)("Path to ConfigFetch class: " + inFileName));
            int lind = inFileName.lastIndexOf(".jar");
            if (lind != -1) {
                inFileName = inFileName.substring(0, lind);
            }
            if ((lind = inFileName.lastIndexOf("pt/lsts/neptus/util/conf/")) != -1) {
                inFileName = inFileName.substring(0, lind);
            }
            if ((lind = inFileName.lastIndexOf("/")) != -1) {
                inFileName = inFileName.substring(0, lind);
            }
            if (inFileName.startsWith("file:")) {
                inFileName = inFileName.replaceFirst("file:", "");
            }
            baseJarFileDir = inFileName = URLDecoder.decode(inFileName, "UTF-8");
            NeptusLog.pub().debug((Object)("Base dir. for the search: " + baseJarFileDir));
        }
        catch (Exception any) {
            NeptusLog.pub().fatal((Object)"Error in finding an initial base dir.", (Throwable)any);
            return false;
        }
        if (baseJarFileDir.equals("")) {
            NeptusLog.pub().fatal((Object)"Error finding an initial base dir.");
            return false;
        }
        return true;
    }

    public boolean setFile(String configFile) {
        String fxt = ConfigFetch.resolvePath(configFile);
        if (fxt == null) {
            return false;
        }
        ConfigFetch.configFile = fxt;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String configFile) {
        String fxt = ConfigFetch.resolvePath(configFile);
        if (fxt == null) {
            fxt = CONFIG_FILE_NAME;
        } else if (!fxt.contains("build") && !fxt.contains("classes")) {
            ConfigFetch.configFile = fxt;
        }
        confDoc = this.readConfigFile(fxt);
        try {
            ImcId16 newCcuId;
            String hostadr;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostadr = addr.getHostAddress();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                hostadr = "127.0.0.1";
            }
            NeptusLog.pub().debug((Object)("Using initial option for IMC ID is '" + hostadr + "'"));
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().indexOf("linux") != -1) {
                try {
                    Enumeration<NetworkInterface> netInt = NetworkInterface.getNetworkInterfaces();
                    block9: while (netInt.hasMoreElements()) {
                        NetworkInterface ni = netInt.nextElement();
                        Enumeration<InetAddress> iAddress = ni.getInetAddresses();
                        while (iAddress.hasMoreElements()) {
                            InetAddress ia = iAddress.nextElement();
                            if (ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                            String msg = "Changing initial option for IMC ID from '" + hostadr + "' to '";
                            hostadr = ia.getHostAddress();
                            msg = msg + hostadr + "'";
                            NeptusLog.pub().debug((Object)msg);
                            continue block9;
                        }
                    }
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e.getStackTrace());
                }
            }
            String[] sl2 = hostadr.split("\\.");
            long idd = (Integer.parseInt(sl2[2]) << 8) + Integer.parseInt(sl2[3]);
            GeneralPreferences.imcCcuId = newCcuId = new ImcId16(idd & 0x1FFFL | 0x4000L);
            GeneralPreferences.imcCcuName = "CCU " + System.getProperty("user.name") + " " + sl2[2] + "_" + sl2[3];
            NeptusLog.pub().debug((Object)("Using IMC ID " + newCcuId.toPrettyString() + " with name '" + GeneralPreferences.imcCcuName + "'"));
            GeneralPreferences.saveProperties();
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().warn((Object)"Setting CCU Local IMC ID error", (Throwable)e);
        }
        finally {
            GeneralPreferences.warnPreferencesListeneres();
        }
        return true;
    }

    public boolean load() {
        return this.load(configFile);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resolvePath(String path) {
        block6: {
            fx = new File(path);
            fx1 = null;
            NeptusLog.pub().debug((Object)"Trying to see if the Path exists...");
            if (fx.exists()) {
                NeptusLog.pub().debug((Object)("The Path exists! [" + path + "]"));
                return path;
            }
            NeptusLog.pub().debug((Object)("Trying to see if the AbsolutePath exists... [" + fx.getAbsoluteFile() + "]"));
            fx1 = fx.getAbsoluteFile();
            if (fx1.exists()) ** GOTO lbl25
            fx1 = ConfigFetch.resolvePathInner(path);
            if (fx1.exists()) break block6;
            return null;
            {
                catch (Exception any) {
                    NeptusLog.pub().debug((Object)any, (Throwable)any);
                    return null;
                }
            }
        }
        try {
            NeptusLog.pub().debug((Object)("The Path exists! [" + fx1.getCanonicalPath() + "]"));
            return fx1.getCanonicalPath();
        }
        catch (Exception any) {
            NeptusLog.pub().debug((Object)("The Path exists! [" + fx1.getAbsolutePath() + "]"));
            return fx1.getAbsolutePath();
lbl25:
            // 1 sources

            NeptusLog.pub().debug((Object)("The file '" + path + "' was not found in this system."));
            return null;
        }
    }

    private static File resolvePathInner(String path) {
        String rootSolver = baseJarFileDir;
        File fx1 = null;
        for (int i = 0; i < parentPaths.length; ++i) {
            fx1 = new File(parentPaths[i]).isAbsolute() ? new File(parentPaths[i] + DS + path).getAbsoluteFile() : new File(rootSolver + DS + parentPaths[i] + DS + path).getAbsoluteFile();
            NeptusLog.pub().debug((Object)("Trying to find Path in " + fx1.getAbsolutePath() + "..."));
            if (!fx1.exists()) continue;
            return fx1;
        }
        return null;
    }

    public static String resolvePathWithParent(String parentPath, String filePath) {
        File fx = new File(filePath);
        File fxParent = new File(parentPath);
        if (fx.isAbsolute()) {
            return fx.getAbsolutePath();
        }
        if (fxParent.exists()) {
            String parent = "";
            parent = fxParent.isDirectory() ? fxParent.getAbsolutePath() : fxParent.getAbsoluteFile().getParent();
            File fx1 = new File(parent + "/" + filePath).getAbsoluteFile();
            if (fx1.isAbsolute()) {
                try {
                    return fx1.getCanonicalPath();
                }
                catch (IOException e) {
                    return fx1.getAbsolutePath();
                }
            }
        }
        return filePath;
    }

    public static String resolvePathBasedOnConfigFile(String filePath) {
        return ConfigFetch.resolvePathWithParent(ConfigFetch.getConfigFile(), filePath);
    }

    public static String getConfigFile() {
        return configFile;
    }

    public static String getElementTextByXPath(String xpath2Element, Document doDocument) {
        String entity = null;
        XPath xpathSelector = DocumentHelper.createXPath((String)xpath2Element);
        List results = xpathSelector.selectNodes((Object)doDocument);
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            entity = ((Element)iter.next()).getTextTrim();
        }
        return entity;
    }

    public static String getAttributeTextByXPath(String xpath2Attribute, Document doDocument) {
        String entity = null;
        XPath xpathSelector = DocumentHelper.createXPath((String)xpath2Attribute);
        List results = xpathSelector.selectNodes((Object)doDocument);
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            entity = ((Attribute)iter.next()).getStringValue();
        }
        return entity;
    }

    protected Document readConfigFile(String configFile) {
        Document ret = DocumentHelper.createDocument();
        File file = new File(configFile);
        if (file.exists()) {
            try {
                SAXReader reader = new SAXReader();
                ret = reader.read(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ConfigFetch.class.getClassLoader().getResourceAsStream(CONFIG_FILE_NAME) != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(ConfigFetch.class.getClassLoader().getResourceAsStream(CONFIG_FILE_NAME)));
                SAXReader reader = new SAXReader();
                ret = reader.read((Reader)br);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Configuration file not found. " + e.getMessage()));
            }
        } else {
            System.err.println("Sorry, configuration file not found.");
        }
        return ret;
    }

    public static String getLoggingPropertiesLocation() {
        String loc = ConfigFetch.getElementTextByXPath("//log-conf-file", confDoc);
        if (loc != null) {
            String loc1 = ConfigFetch.resolvePath(loc);
            if (loc1 != null) {
                return loc1;
            }
            return loc;
        }
        loc = "conf/log4j.xml";
        return loc;
    }

    public static String getLoggingPropertiesType() {
        String type = ConfigFetch.getAttributeTextByXPath("//log-conf-file/@type", confDoc);
        if (type == null) {
            type = "xml";
        }
        return type;
    }

    public static String getCoordinateSystemsConfigLocation() {
        String loc = ConfigFetch.getElementTextByXPath("//coordinate-systems-conf-file", confDoc);
        if (loc != null) {
            String loc1 = ConfigFetch.resolvePath(loc);
            if (loc1 != null) {
                return loc1;
            }
            return loc;
        }
        loc = "conf/neptus-coordinateSystems.xml";
        return loc;
    }

    public static String getMiscSystemsConfigLocation() {
        String loc = ConfigFetch.getElementTextByXPath("//misc-systems-file", confDoc);
        if (loc != null) {
            String loc1 = ConfigFetch.resolvePath(loc);
            if (loc1 != null) {
                return loc1;
            }
            return loc;
        }
        loc = "conf/neptus-misc-systems.xml";
        return loc;
    }

    public static LinkedList<String> getVehiclesList() {
        String baseDir;
        LinkedList<String> result = new LinkedList<String>();
        String xpath2Element = "//vehicles-base-path";
        Document doDocument = confDoc;
        XPath xpathSelector = DocumentHelper.createXPath((String)xpath2Element);
        Node node = xpathSelector.selectSingleNode((Object)doDocument);
        if (node == null) {
            baseDir = "vehicles-defs";
        } else {
            Element elem = (Element)node;
            baseDir = elem.getTextTrim();
        }
        baseDir = ConfigFetch.resolvePath(baseDir);
        File fxDir = new File(baseDir);
        if (!fxDir.isDirectory()) {
            return result;
        }
        Object[] filesVeh = fxDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                String extension = FileUtil.getFileExtension(f);
                if (extension != null) {
                    return extension.equals("xml") || extension.equals("nvcl");
                }
                return false;
            }
        });
        Arrays.sort(filesVeh);
        for (Object fx1 : filesVeh) {
            String path;
            try {
                path = ((File)fx1).getCanonicalPath();
            }
            catch (IOException e) {
                path = ((File)fx1).getAbsolutePath();
            }
            result.add(path);
        }
        return result;
    }

    public static String getMissionSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("mission");
    }

    public static String getVehicleSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("vehicle");
    }

    public static String getMapSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("map");
    }

    public static String getCoordinateSystemSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("coordinateSystems");
    }

    public static String getChecklistSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("checklist");
    }

    public static String getMiscSystemsSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("misc-systems");
    }

    public static String getConsoleSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("console");
    }

    public static String getActionMapSchemaLocation() {
        ConfigFetch.initialize();
        return listOfSchemasPaths.get("neptus-action-map");
    }

    public static Properties getVersionInfoAsProperties() {
        Properties prop = new Properties();
        String versionString = "";
        InputStream ist = ConfigFetch.class.getResourceAsStream(VERSION_FILE_NAME);
        if (ist != null) {
            try {
                prop.load(ist);
                versionString = "\n\nVersion ";
                versionString = versionString + prop.getProperty("VERSION", "");
                versionString = versionString + " (";
                versionString = versionString + prop.getProperty("DATE", "");
                versionString = versionString + ", g";
                versionString = versionString + prop.getProperty("SCM_REV", "?");
                versionString = versionString + ")";
            }
            catch (IOException e) {
                NeptusLog.pub().debug((Object)e);
            }
        }
        return prop;
    }

    public static String getVersionSimpleString() {
        Properties prop = new Properties();
        String versionString = " ";
        InputStream ist = ConfigFetch.class.getResourceAsStream(VERSION_FILE_NAME);
        if (ist != null) {
            try {
                prop.load(ist);
                versionString = versionString + prop.getProperty("VERSION", "");
                versionString = versionString + " (";
                versionString = versionString + prop.getProperty("DATE", "");
                versionString = versionString + ", g";
                versionString = versionString + prop.getProperty("SCM_REV", "?");
                versionString = versionString + ")";
            }
            catch (IOException e) {
                NeptusLog.pub().debug((Object)e);
            }
        }
        return versionString;
    }

    public static String getVersionInfoAsString() {
        Properties prop = new Properties();
        String versionString = "";
        InputStream ist = ConfigFetch.class.getResourceAsStream(VERSION_FILE_NAME);
        if (ist != null) {
            try {
                prop.load(ist);
                versionString = "\n\nVersion ";
                versionString = versionString + prop.getProperty("VERSION", "");
                versionString = versionString + " (";
                versionString = versionString + prop.getProperty("DATE", "");
                versionString = versionString + ", g";
                versionString = versionString + prop.getProperty("SCM_REV", "?");
                versionString = versionString + ")";
            }
            catch (IOException e) {
                NeptusLog.pub().debug((Object)e);
            }
        }
        return versionString;
    }

    public static String getVersionExtendedInfoSimpleString() {
        String versionString = "";
        InputStream ist = ConfigFetch.class.getResourceAsStream(VERSION__EXTENDED_FILE_NAME);
        if (ist != null) {
            try {
                versionString = StreamUtil.copyStreamToString(ist);
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)e);
            }
        }
        return versionString;
    }

    public static String getSaveAsCommentForXML() {
        Properties prop = ConfigFetch.getVersionInfoAsProperties();
        Date trialTime = new Date();
        SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.0Z'");
        String ret = "Data saved on " + dateFormater.format(trialTime) + " with Neptus version " + prop.getProperty("VERSION", "") + " (compiled on " + prop.getProperty("DATE", "") + ", g" + prop.getProperty("SCM_REV", "?") + ").";
        return " " + ret + " ";
    }

    public static Component getSuperParentFrame() {
        return superParentFrame;
    }

    public static Frame getSuperParentAsFrame() {
        Component component = superParentFrame;
        if (component instanceof JFrame) {
            return (Frame)component;
        }
        if (component instanceof JDialog) {
            return (Frame)component;
        }
        return new Frame();
    }

    public static void setSuperParentFrame(Component superParentFrame) {
        if (ConfigFetch.superParentFrame == null) {
            ConfigFetch.superParentFrame = superParentFrame;
        }
    }

    public static void setSuperParentFrameForced(Component superParentFrame) {
        ConfigFetch.superParentFrame = superParentFrame;
    }

    public static short getOS() {
        String osName = System.getProperty("os.name");
        int os = -1;
        os = osName.toLowerCase().indexOf("windows") != -1 ? 0 : (osName.toLowerCase().indexOf("linux") != -1 ? 1 : 9);
        return (short)os;
    }

    public static boolean isOSEqual(short os) {
        return ConfigFetch.getOS() == os;
    }

    private static void parseVersionFile() {
        if (params != null) {
            return;
        }
        params = new Hashtable();
        BufferedReader br = new BufferedReader(new InputStreamReader(ConfigFetch.class.getClassLoader().getResourceAsStream("version.txt")));
        try {
            String line = br.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line, "= ");
                if (st.countTokens() == 2) {
                    params.put(st.nextToken().toLowerCase(), st.nextToken());
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public static String getNeptusVersion() {
        ConfigFetch.parseVersionFile();
        return params.get("version");
    }

    public static String getCompilationDate() {
        ConfigFetch.parseVersionFile();
        return params.get("date");
    }

    public static String getScmRev() {
        ConfigFetch.parseVersionFile();
        return params.get("scm_rev");
    }

    public static long getNeptusInitializationTime() {
        return neptusInitializationTime;
    }

    public static String getNeptusTmpDir() {
        return neptusTmpDir;
    }

    public static boolean isOnLockedMode() {
        return onLockedMode;
    }

    public static void setOnLockedMode(boolean onLockedMode) {
        ConfigFetch.onLockedMode = onLockedMode;
    }

    private static void loadSchemas() {
        for (String key : listOfSchemas.keySet()) {
            String name = listOfSchemas.get(key);
            InputStream inStream = ConfigFetch.class.getResourceAsStream("/" + name);
            if (inStream != null) {
                File dirBase = new File(ConfigFetch.getNeptusTmpDir());
                dirBase.mkdirs();
                File outFile = new File(dirBase, name);
                outFile.getParentFile().mkdirs();
                outFile.deleteOnExit();
                StreamUtil.copyStreamToFile(inStream, outFile);
                listOfSchemasPaths.put(key, outFile.getAbsolutePath());
                continue;
            }
            String loc1 = ConfigFetch.resolvePath(name);
            listOfSchemasPaths.put(key, loc1);
        }
    }

    public static List<Image> getIconImagesForFrames() {
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(Toolkit.getDefaultToolkit().getImage(ConfigFetch.class.getResource("/images/neptus-icon.png")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(ConfigFetch.class.getResource("/images/neptus-icon1.png")));
        imageList.add(Toolkit.getDefaultToolkit().getImage(ConfigFetch.class.getResource("/images/neptus-icon2.png")));
        return imageList;
    }

    public static void mark(String tag) {
    }

    public static void benchmark(String tag) {
    }

    public static NeptusProperty.DistributionEnum getDistributionType() {
        distributionSetChangedOrGet = true;
        return distributionType;
    }

    public static boolean setDistributionType(NeptusProperty.DistributionEnum dist) {
        if (distributionSetChangedOrGet) {
            return false;
        }
        distributionType = dist;
        distributionSetChangedOrGet = true;
        return true;
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)ConfigFetch.getLoggingPropertiesLocation());
        String st = ConfigFetch.getConfigFile();
        String st1 = ConfigFetch.resolvePathWithParent(st, "../fe.txt");
        NeptusLog.pub().info((Object)st.concat("\n").concat(st1));
        st1 = ConfigFetch.resolvePathWithParent(st, "c:/fe.txt");
        NeptusLog.pub().info((Object)st.concat("\n").concat(st1));
    }

    static {
        DateTimeUtil.getUID();
        listOfSchemas.put("mission", "schemas/neptus-mission.xsd");
        listOfSchemas.put("vehicle", "schemas/neptus-vehicle.xsd");
        listOfSchemas.put("map", "schemas/neptus-map.xsd");
        listOfSchemas.put("messages", "schemas/neptus-messages.xsd");
        listOfSchemas.put("misc-systems", "schemas/neptus-misc-systems.xsd");
        listOfSchemas.put("missionWeb", "schemas/mwebschema.xsd");
        listOfSchemas.put("checklist", "schemas/neptus-checklist.xsd");
        listOfSchemas.put("console", "schemas/neptus-console.xsd");
        listOfSchemas.put("coordinateSystems", "schemas/neptus-coordinateSystems.xsd");
        listOfSchemas.put("maneuvers", "schemas/neptus-maneuvers.xsd");
        listOfSchemas.put("textures", "schemas/neptus-textures.xsd");
        listOfSchemas.put("types", "schemas/neptus-types.xsd");
        confDoc = DocumentHelper.createDocument();
        configFile = CONFIG_FILE_NAME;
        baseJarFileDir = ".";
        ifLogger = true;
        distributionSetChangedOrGet = false;
        distributionType = NeptusProperty.DistributionEnum.DEVELOPER;
        neptusTmpDir = System.getProperty("java.io.tmpdir", "tmp") + DS + NameNormalizer.getRandomID("neptus");
        try {
            File ntd = new File(neptusTmpDir);
            ntd.deleteOnExit();
            ntd.mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        parentPaths = new String[]{".", System.getProperty("user.home", ".") + DS + ".neptus", System.getProperty("user.dir", "."), ".." + DS + "classes", ".." + DS + "config", ".." + DS + "conf", ".." + DS + "files", ".." + DS + "images", ".." + DS + "..", "..", System.getProperty("user.home", ".")};
        superParentFrame = null;
        params = null;
        alreadyInitialized = false;
        INSTANCE = null;
    }

    public static enum ENVIROMENT {
        PRODUCTION,
        DEVELOPMENT;

    }
}

