/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.conf;

import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.conf.Validator;

public class DoubleMinMaxValidator
implements Validator {
    private double min = Double.MIN_VALUE;
    private double max = Double.MAX_VALUE;
    private boolean minClosed = true;
    private boolean maxClosed = true;

    public DoubleMinMaxValidator(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public DoubleMinMaxValidator(double min, double max, boolean minClosed, boolean maxClosed) {
        this.min = min;
        this.max = max;
        this.minClosed = minClosed;
        this.maxClosed = maxClosed;
    }

    public DoubleMinMaxValidator(double val, boolean isMax) {
        if (isMax) {
            this.max = val;
        } else {
            this.min = val;
        }
    }

    public DoubleMinMaxValidator(double val, boolean isMax, boolean isClosed) {
        if (isMax) {
            this.max = val;
            this.maxClosed = isClosed;
        } else {
            this.min = val;
            this.minClosed = isClosed;
        }
    }

    @Override
    public String validate(Object newValue) {
        try {
            double val = (Double)newValue;
            if ((this.minClosed ? val >= this.min : val > this.min) && (this.maxClosed ? val <= this.max : val < this.max)) {
                return null;
            }
            return "The value should be between " + this.min + (this.minClosed ? " included" : "") + " and " + this.max + (this.maxClosed ? " included" : "") + ". You typed: " + val + ".";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public String validValuesDesc() {
        String ret = (this.minClosed ? "[" : "]") + this.min + ", " + this.max + (this.maxClosed ? "]" : "[");
        return ret;
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + new DoubleMinMaxValidator(1.0, 10.0).validate(20.0)));
        NeptusLog.pub().info((Object)("<###> " + new DoubleMinMaxValidator(1.0, 10.0, true, false).validate(10.0)));
        NeptusLog.pub().info((Object)("<###> " + new DoubleMinMaxValidator(1.0, 10.0, true, false).validate(1.0)));
        NeptusLog.pub().info((Object)("<###> " + new DoubleMinMaxValidator(1.0, 10.0, true, true).validate(10.0)));
        NeptusLog.pub().info((Object)("<###> " + new DoubleMinMaxValidator(1.0, 10.0, false, true).validate(1.0)));
    }
}

