/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.conf;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.IridiumManager;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.PropertiesLoader;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.IntegerMinMaxValidator;
import pt.lsts.neptus.util.conf.PortRangeValidator;
import pt.lsts.neptus.util.conf.PreferencesListener;
import pt.lsts.neptus.util.conf.StringCommaSeparatedListValidator;
import pt.lsts.neptus.util.conf.StringNonEmptyValidator;
import pt.lsts.neptus.util.conf.StringPatternValidator;

public class GeneralPreferences
implements PropertiesProvider {
    private static PropertiesLoader properties = null;
    public static final String GENERAL_PROPERTIES_FILE = "conf/general-properties.xml";
    public static Vector<PreferencesListener> pListeners = new Vector();
    @NeptusProperty(name="Language", category="Interface", userLevel=NeptusProperty.LEVEL.REGULAR, description="Select the language to use for the interface (needs restart). (Format [a-z]{2}_[A-Z]{2}")
    public static String language = "en";
    @NeptusProperty(name="Speech On", category="Interface", userLevel=NeptusProperty.LEVEL.REGULAR, description="Select this if you want the speech on or off.")
    public static boolean speechOn = true;
    @NeptusProperty(name="Comms Local Port UDP", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static int commsLocalPortUDP = 6001;
    @NeptusProperty(name="Comms Local Port TCP", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static int commsLocalPortTCP = 6001;
    @NeptusProperty(name="IMC transports to use", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Comma separated transports list. Valid values are (UDP, TCP). (The order implies preference of use.)")
    public static String imcTransportsToUse = "UDP, TCP";
    @NeptusProperty(name="IMC CCU ID", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static ImcId16 imcCcuId = new ImcId16("40:00");
    @NeptusProperty(name="IMC CCU Name", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="The CCU Name to be presented to other peers")
    public static String imcCcuName = "CCU " + System.getProperty("user.name");
    @NeptusProperty(name="IMC Multicast Enable", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Multicast enable or disable")
    public static boolean imcMulticastEnable = true;
    @NeptusProperty(name="IMC Multicast Address", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static String imcMulticastAddress = "224.0.75.69";
    @NeptusProperty(name="IMC Multicast/Broadcast Port Range", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Multicast port range to use for the announce channel.\n The form is, e.g. '6969','6967-6970'")
    public static String imcMulticastBroadcastPortRange = "30100-30104";
    @NeptusProperty(name="IMC Broadcast Enable", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static boolean imcBroadcastEnable = true;
    @NeptusProperty(name="IMC Change by Source IP Request", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="If enable allows the announce msg request to use the sender IP to be use in future comms. to the sender system.")
    public static boolean imcChangeBySourceIpRequest = true;
    @NeptusProperty(name="IMC Unicast Annonce Enable", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="To send announce also by Unicast. Enable or disable")
    public static boolean imcUnicastAnnounceEnable = true;
    @NeptusProperty(name="Logs Downloader - Enable Parcial Download", category="IMC Logs Downloader", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Enable the partial logs downloads (resume partial downloads). NOTE: THE DOWNLOAD BOXES ONLY READ THIS OPTION UPON CREATION.")
    public static boolean logsDownloaderEnablePartialDownload = true;
    @NeptusProperty(name="Logs Downloader - Use number of simultaneous downloads control", category="IMC Logs Downloader", userLevel=NeptusProperty.LEVEL.ADVANCED, description="")
    public static boolean logsNumberSimultaneousDownloadsControl = true;
    @NeptusProperty(name="Logs Downloader - Wait for all To Stop", category="IMC Logs Downloader", userLevel=NeptusProperty.LEVEL.ADVANCED, description="")
    public static boolean logsDownloaderWaitForAllToStop = true;
    @NeptusProperty(name="Heartbeat Time Period (ms)", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static int heartbeatTimePeriodMillis = 1000;
    @NeptusProperty(name="Heartbeat Timeout (ms)", category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static int heartbeatTimeoutMillis = 2000;
    @NeptusProperty(name="Number Of Shown Trails Points", category="Map", userLevel=NeptusProperty.LEVEL.REGULAR)
    public static int numberOfShownPoints = 500;
    @NeptusProperty(name="Auto Snapshot Period (s)", category="Interface", userLevel=NeptusProperty.LEVEL.REGULAR)
    public static int autoSnapshotPeriodSeconds = 60;
    @NeptusProperty(name="Renderer Plan Color", category="Map", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static Color rendererPlanColor = new Color(255, 255, 255);
    @NeptusProperty(name="Renderer 3D Priority", category="Map", userLevel=NeptusProperty.LEVEL.ADVANCED, description="1- Minimum Priority <br>10- Maximum Priority<br>5- Normal Priority")
    public static int renderer3DPriority = 1;
    @NeptusProperty(name="Renderer Update Periode For Vehicle State (ms)", category="Map", userLevel=NeptusProperty.LEVEL.ADVANCED, description="This is the update periode to update the vehicle state in the renders (in miliseconds). Use '-1' to disable it. One good good value is 100ms (10Hz) or 50ms (20hz).")
    public static int rendererUpdatePeriodeForVehicleStateMillis = 50;
    @NeptusProperty(name="Console Edit Border Color", category="Console", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static Color consoleEditBorderColor = new Color(150, 0, 0);
    @NeptusProperty(name="SSH Connection Timeout (ms)", category="SSH", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static int sshConnectionTimeoutMillis = 3000;
    @NeptusProperty(name="Comms. Queue Size", category="Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Select the comms. queues size.")
    public static int commsQueueSize = 1024;
    @NeptusProperty(name="Comms. Messsage Separation Time (ms)", category="Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Select the comms. separation time in miliseconds that a message (by type) should be warn. Use \"-1\" for always warn.")
    public static int commsMsgSeparationMillis = -1;
    @NeptusProperty(name="Filter UDP Redirect Also By Port", editable=false, category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static boolean filterUdpAlsoByPort = false;
    @NeptusProperty(name="Redirect Unknown Comms. To First Vehicle In Comm. List", editable=false, category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Any messages comming from unknown vehicle will be redirect to the first on comm. list.")
    public static boolean redirectUnknownIdsToFirstCommVehicle = false;
    @NeptusProperty(name="Use New System Activity Counter", editable=false, category="IMC Communications", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public static boolean commsUseNewSystemActivityCounter = true;
    @NeptusProperty(name="Enable Log Sent Messages", category="Message Logging", userLevel=NeptusProperty.LEVEL.REGULAR)
    public static boolean messageLogSentMessages = true;
    @NeptusProperty(name="Enable Log Received Messages", category="Message Logging", userLevel=NeptusProperty.LEVEL.REGULAR)
    public static boolean messageLogReceivedMessages = true;
    @NeptusProperty(name="Extended Program Output Log", category="Neptus Program Logging", userLevel=NeptusProperty.LEVEL.ADVANCED, description="If true, the program output will be augmented with more info (mainly for problem solving).")
    public static boolean programLogExtendedLog = false;
    @NeptusProperty(name="Tides file", category="Tides", userLevel=NeptusProperty.LEVEL.REGULAR)
    public static File tidesFile = new File("conf/tides/Leixoes.txt");
    @NeptusProperty(name="Iridium Messenger", category="Iridium Communications", userLevel=NeptusProperty.LEVEL.REGULAR, description="Iridium messaging implementation")
    public static IridiumManager.IridiumMessengerEnum iridiumMessenger = IridiumManager.IridiumMessengerEnum.HubIridiumMessenger;
    @NeptusProperty(name="Maximum Size of Plan Name For Acoustics", category="Plan", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Maximum size for a plan name to be started by acoustics. (Reboot required after change.) Minimum 1, maximum 255")
    public static int maximumSizePlanNameForAcoustics = 31;

    public static void initialize() {
        String generalPropertiesFile = ConfigFetch.resolvePathBasedOnConfigFile(GENERAL_PROPERTIES_FILE);
        if (!new File(generalPropertiesFile).exists()) {
            generalPropertiesFile = ConfigFetch.resolvePathBasedOnConfigFile("../conf/general-properties.xml");
        }
        PropertiesLoader generalProperties = new PropertiesLoader(generalPropertiesFile, 1);
        GeneralPreferences.setPropertiesLoader(generalProperties);
    }

    public static String validateLanguage(String value) {
        return new StringPatternValidator("[a-z]{2}_[A-Z]{2}").validate(value);
    }

    public static String validateCommsLocalPortUDP(int value) {
        return new IntegerMinMaxValidator(1, 65535).validate(value);
    }

    public static String validateCommsLocalPortTCP(int value) {
        return new IntegerMinMaxValidator(1, 65535).validate(value);
    }

    public static String validateImcTransportsToUse(String value) {
        return new StringCommaSeparatedListValidator("UDP", "TCP").validate(value);
    }

    public static String validateImcCcuId(ImcId16 value) {
        if (ImcId16.ANNOUNCE.equals(value) || ImcId16.BROADCAST_ID.equals(value) || ImcId16.NULL_ID.equals(value)) {
            return "This is a reserved ID, choose another other than " + ImcId16.ANNOUNCE.toPrettyString() + ", " + ImcId16.BROADCAST_ID.toPrettyString() + ", and " + ImcId16.NULL_ID.toPrettyString() + ".";
        }
        return null;
    }

    public static String validateImcCcuName(String value) {
        return new StringNonEmptyValidator().validate(value);
    }

    public static String validateImcMulticastAddress(String value) {
        return new StringPatternValidator("\\d{2,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}").validate(value);
    }

    public static String validateImcMulticastBroadcastPortRange(String value) {
        return new PortRangeValidator().validate(value);
    }

    public static String validateHeartbeatTimePeriodMillis(int value) {
        return new IntegerMinMaxValidator(100, 65535).validate(value);
    }

    public static String validateHeartbeatTimeoutMillis(int value) {
        return new IntegerMinMaxValidator(1000, 65535).validate(value);
    }

    public static String validateNumberOfShownPoints(int value) {
        return new IntegerMinMaxValidator(-1, 1000).validate(value);
    }

    public static String validateAutoSnapshotPeriodSeconds(int value) {
        return new IntegerMinMaxValidator(20, 1800).validate(value);
    }

    public static String validateRenderer3DPriority(int value) {
        return new IntegerMinMaxValidator(1, 10).validate(value);
    }

    public static String validateRendererUpdatePeriodeForVehicleStateMillis(int value) {
        return new IntegerMinMaxValidator(-1, 1000).validate(value);
    }

    public static String validateSshConnectionTimeoutMillis(int value) {
        return new IntegerMinMaxValidator(0, false).validate(value);
    }

    public static String validateCommsQueueSize(int value) {
        return new IntegerMinMaxValidator(1, Integer.MAX_VALUE).validate(value);
    }

    public static String validateCommsMsgSeparationMillis(int value) {
        return new IntegerMinMaxValidator(-1, 1000).validate(value);
    }

    public static String validateMaximumSizePlanNameForAcoustics(int value) {
        return new IntegerMinMaxValidator(1, 255).validate(value);
    }

    @Override
    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties(this);
    }

    @Override
    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, properties);
        Thread t = new Thread("Properties Change Warner"){

            @Override
            public void run() {
                GeneralPreferences.warnPreferencesListeneres();
            }
        };
        t.setDaemon(true);
        t.start();
        GeneralPreferences.saveProperties();
    }

    @Override
    public String getPropertiesDialogTitle() {
        return I18n.text("General Preferences");
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, properties);
    }

    public static void addPreferencesListener(PreferencesListener listener) {
        if (!pListeners.contains(listener)) {
            pListeners.add(listener);
        }
    }

    public static void removePreferencesListener(PreferencesListener listener) {
        pListeners.remove(listener);
    }

    public static void warnPreferencesListeneres() {
        for (PreferencesListener pl : pListeners) {
            try {
                pl.preferencesUpdated();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Exception warning '" + pl.getClass().getSimpleName() + "[" + Integer.toHexString(pl.hashCode()) + "]" + "' for " + GeneralPreferences.class.getSimpleName() + " propertieschanges"), (Throwable)e);
            }
            catch (Error e) {
                NeptusLog.pub().error((Object)("Error warning '" + pl.getClass().getSimpleName() + "[" + Integer.toHexString(pl.hashCode()) + "]" + "' for " + GeneralPreferences.class.getSimpleName() + " propertieschanges"), (Throwable)e);
            }
        }
    }

    public static String colorToString(Color c) {
        if (c == null) {
            return "0,0,0";
        }
        return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
    }

    public static Color stringToColor(String s) {
        StringTokenizer st = new StringTokenizer(s, ", ");
        if (st.countTokens() != 3) {
            return Color.black;
        }
        try {
            int red = Integer.parseInt(st.nextToken());
            int green = Integer.parseInt(st.nextToken());
            int blue = Integer.parseInt(st.nextToken());
            return new Color(red, green, blue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Color.black;
        }
    }

    public static void setPropertiesLoader(PropertiesLoader properties) {
        GeneralPreferences.properties = properties;
        PluginUtils.loadProperties(GeneralPreferences.properties, GeneralPreferences.class);
    }

    public static void saveProperties() {
        try {
            PluginUtils.savePropertiesToXML(properties.getWorkingFile(), true, GeneralPreferences.class);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"saveProperties", (Throwable)e);
        }
    }

    public static void dumpGeneralPreferences() {
        try {
            PluginUtils.savePropertiesToXML(properties.getWorkingFile(), false, GeneralPreferences.class);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"saveProperties", (Throwable)e);
        }
    }

    public static void generateImcId() {
        try {
            ImcId16 newCcuId;
            String hostadr;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostadr = addr.getHostAddress();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                hostadr = "127.0.0.1";
            }
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().indexOf("linux") != -1) {
                try {
                    Enumeration<NetworkInterface> netInt = NetworkInterface.getNetworkInterfaces();
                    block6: while (netInt.hasMoreElements()) {
                        NetworkInterface ni = netInt.nextElement();
                        Enumeration<InetAddress> iAddress = ni.getInetAddresses();
                        while (iAddress.hasMoreElements()) {
                            InetAddress ia = iAddress.nextElement();
                            if (ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                            hostadr = ia.getHostAddress();
                            continue block6;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String[] sl2 = hostadr.split("\\.");
            long idd = (Integer.parseInt(sl2[2]) << 8) + Integer.parseInt(sl2[3]);
            imcCcuId = newCcuId = new ImcId16(idd & 0x1FFFL | 0x4000L);
            imcCcuName = "CCU " + System.getProperty("user.name") + " " + sl2[2] + "_" + sl2[3];
            GeneralPreferences.saveProperties();
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().error((Object)e.getMessage());
        }
    }

    public static void main(String[] args) {
        final GeneralPreferences gp = new GeneralPreferences();
        GeneralPreferences.addPreferencesListener(new PreferencesListener(){

            @Override
            public void preferencesUpdated() {
                NeptusLog.pub().info((Object)"<###>preferencesUpdated");
            }
        });
        final String filenameProps = "" + GeneralPreferences.class.getSimpleName().toLowerCase() + ".properties";
        final String filenameXML = "" + GeneralPreferences.class.getSimpleName().toLowerCase() + ".xml";
        PropertiesLoader pl = new PropertiesLoader(filenameXML, 1);
        GeneralPreferences.setPropertiesLoader(pl);
        JButton button = new JButton(new AbstractAction(I18n.text("General Preferences")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PluginUtils.loadProperties(filenameXML, GeneralPreferences.class);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                PropertiesEditor.editProperties(gp, true);
                try {
                    PluginUtils.saveProperties(filenameProps, true, GeneralPreferences.class);
                    PluginUtils.savePropertiesToXML(filenameXML, true, GeneralPreferences.class);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JFrame frame = GuiUtils.testFrame(button, I18n.text("General Preferences"));
        frame.setDefaultCloseOperation(3);
    }
}

