/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.conf;

import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.conf.Validator;

public class LongMinMaxValidator
implements Validator {
    private long min = Long.MIN_VALUE;
    private long max = Long.MAX_VALUE;
    private boolean minClosed = true;
    private boolean maxClosed = true;

    public LongMinMaxValidator(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public LongMinMaxValidator(long min, long max, boolean minClosed, boolean maxClosed) {
        this.min = min;
        this.max = max;
        this.minClosed = minClosed;
        this.maxClosed = maxClosed;
    }

    public LongMinMaxValidator(long val, boolean isMax) {
        if (isMax) {
            this.max = val;
        } else {
            this.min = val;
        }
    }

    public LongMinMaxValidator(long val, boolean isMax, boolean isClosed) {
        if (isMax) {
            this.max = val;
            this.maxClosed = isClosed;
        } else {
            this.min = val;
            this.minClosed = isClosed;
        }
    }

    @Override
    public String validate(Object newValue) {
        try {
            long val = (Long)newValue;
            if ((this.minClosed ? val >= this.min : val > this.min) && (this.maxClosed ? val <= this.max : val < this.max)) {
                return null;
            }
            return "The value should be between " + this.min + (this.minClosed ? " included" : "") + " and " + this.max + (this.maxClosed ? " included" : "") + ". You typed: " + val + ".";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public String validValuesDesc() {
        String ret = (this.minClosed ? "[" : "]") + this.min + ", " + this.max + (this.maxClosed ? "]" : "[");
        return ret;
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + new LongMinMaxValidator(1L, 10L).validate(20)));
        NeptusLog.pub().info((Object)("<###> " + new LongMinMaxValidator(1L, 10L, true, false).validate(10)));
        NeptusLog.pub().info((Object)("<###> " + new LongMinMaxValidator(1L, 10L, true, false).validate(1)));
        NeptusLog.pub().info((Object)("<###> " + new LongMinMaxValidator(1L, 10L, true, true).validate(10)));
        NeptusLog.pub().info((Object)("<###> " + new LongMinMaxValidator(1L, 10L, false, true).validate(1)));
    }
}

