/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.conf;

import java.util.HashSet;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.conf.StringListValidator;

public class StringCommaSeparatedListValidator
extends StringListValidator {
    public StringCommaSeparatedListValidator(String ... vals) {
        super(vals);
    }

    @Override
    public String validate(Object newValue) {
        try {
            String comp = (String)newValue;
            String[] lt = comp.split("[ ,]+");
            if (lt.length == 0) {
                return "No valid value found.";
            }
            for (String val : lt) {
                if (super.validate(val) == null) continue;
                return "No valid value found.";
            }
            HashSet<String> ve = new HashSet<String>();
            for (String val : lt) {
                if (ve.contains(val)) {
                    return "No valid value found.";
                }
                ve.add(val);
            }
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + new StringCommaSeparatedListValidator("UDP", "RTPS").validate("")));
        NeptusLog.pub().info((Object)("<###> " + new StringCommaSeparatedListValidator("UDP", "RTPS").validate("UDP")));
        NeptusLog.pub().info((Object)("<###> " + new StringCommaSeparatedListValidator("UDP", "RTPS").validate("UDP,RTPS")));
        NeptusLog.pub().info((Object)("<###> " + new StringCommaSeparatedListValidator("UDP", "RTPS").validate("RTPS , UDP")));
        NeptusLog.pub().info((Object)("<###> " + new StringCommaSeparatedListValidator("UDP", "RTPS").validValuesDesc()));
    }
}

