/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.conf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.conf.Validator;

public class StringPatternValidator
implements Validator {
    protected String redex = "(\\w(((\\s)*)?,((\\s)*)?)?)*";

    public StringPatternValidator() {
    }

    public StringPatternValidator(String redex) {
        this.redex = redex;
    }

    @Override
    public String validate(Object newValue) {
        try {
            String comp = (String)newValue;
            Pattern p = Pattern.compile(this.redex);
            Matcher m = p.matcher(comp);
            boolean b = m.matches();
            return b ? null : "The value '" + comp + "' should be in the form '" + this.redex + "'";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public String validValuesDesc() {
        String ret = "The value should match redex " + this.redex;
        return ret;
    }

    public static void main(String[] args) {
        StringPatternValidator t = new StringPatternValidator();
        NeptusLog.pub().info((Object)("<###>ok: " + t.validate("Main")));
        NeptusLog.pub().info((Object)("<###>ok: " + t.validate("")));
        NeptusLog.pub().info((Object)("<###>ok: " + t.validate("Main,W1")));
        NeptusLog.pub().info((Object)("<###>ok: " + t.validate("Main, W1")));
        NeptusLog.pub().info((Object)("<###>ok: " + t.validate("Main, W1 ,Main , W1")));
        NeptusLog.pub().info((Object)("<###>ok: " + t.validate("Main, W1 ,Main , W1,")));
        NeptusLog.pub().info((Object)("<###>nok: " + t.validate("Main:, W1 ,Main , W1")));
        NeptusLog.pub().info((Object)("<###>nok: " + t.validate(",Main, W1 ,Main , W1")));
    }
}

