/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.util.coord;

import java.awt.geom.Point2D;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.LocationType;

public class MapTileUtil {
    public static final int LEVEL_OFFSET = 22;
    public static final int LEVEL_MIN = 1;
    public static final int LEVEL_MAX = 22;
    public static final double EARTH_RADIUS = 6378137.0;
    public static final double MIN_LATITUDE = -85.05112878;
    public static final double MAX_LATITUDE = 85.05112878;
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MAX_LONGITUDE = 180.0;

    public static double clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    public static int mapSize(int levelOfDetail) {
        return 256 << levelOfDetail;
    }

    public static double groundResolution(double latitude, int levelOfDetail) {
        latitude = MapTileUtil.clip(latitude, -85.05112878, 85.05112878);
        return Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / (double)MapTileUtil.mapSize(levelOfDetail);
    }

    public static double mapScale(double latitude, int levelOfDetail, int screenDpi) {
        return MapTileUtil.groundResolution(latitude, levelOfDetail) * (double)screenDpi / 0.0254;
    }

    public static Point2D degreesToXY(double latitude, double longitude, int levelOfDetail) {
        latitude = MapTileUtil.clip(latitude, -85.05112878, 85.05112878);
        longitude = MapTileUtil.clip(longitude, -180.0, 180.0);
        double x = (longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(latitude * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        int mapSize = MapTileUtil.mapSize(levelOfDetail);
        double pixelX = MapTileUtil.clip(x * (double)mapSize + 0.5, 0.0, mapSize - 1);
        double pixelY = MapTileUtil.clip(y * (double)mapSize + 0.5, 0.0, mapSize - 1);
        return new Point2D.Double(pixelX, pixelY);
    }

    public static double[] XYToDegrees(double pixelX, double pixelY, int levelOfDetail) {
        int mapSize = MapTileUtil.mapSize(levelOfDetail);
        double x = MapTileUtil.clip(pixelX, 0.0, mapSize - 1) / (double)mapSize - 0.5;
        double y = 0.5 - MapTileUtil.clip(pixelY, 0.0, mapSize - 1) / (double)mapSize;
        double latitude = 90.0 - 360.0 * Math.atan(Math.exp(-y * 2.0 * Math.PI)) / Math.PI;
        double longitude = 360.0 * x;
        return new double[]{latitude, longitude};
    }

    public static int[] pixelXYToTileXY(int pixelX, int pixelY) {
        int tileX = pixelX / 256;
        int tileY = pixelY / 256;
        return new int[]{tileX, tileY};
    }

    public static int[] tileXYToPixelXY(int tileX, int tileY) {
        int pixelX = tileX * 256;
        int pixelY = tileY * 256;
        return new int[]{pixelX, pixelY};
    }

    public static String tileXYToQuadKey(int tileX, int tileY, int levelOfDetail) {
        StringBuilder quadKey = new StringBuilder();
        for (int i = levelOfDetail; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tileX & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tileY & mask) != 0) {
                digit = (char)(digit + 1);
                digit = (char)(digit + '\u0001');
            }
            quadKey.append(digit);
        }
        return quadKey.toString();
    }

    public static int[] quadKeyToTileXY(String quadKey) throws Exception {
        int levelOfDetail;
        int tileY = 0;
        int tileX = 0;
        for (int i = levelOfDetail = quadKey.length(); i > 0; --i) {
            int mask = 1 << i - 1;
            String str = quadKey.substring(levelOfDetail - i, levelOfDetail - i + 1);
            if ("0".equalsIgnoreCase(str)) continue;
            if ("1".equalsIgnoreCase(str)) {
                tileX |= mask;
                continue;
            }
            if ("2".equalsIgnoreCase(str)) {
                tileY |= mask;
                continue;
            }
            if ("3".equalsIgnoreCase(str)) {
                tileX |= mask;
                tileY |= mask;
                continue;
            }
            throw new Exception("Invalid QuadKey digit sequence.");
        }
        return new int[]{tileX, tileY, levelOfDetail};
    }

    public static double[] getOffsetFrom(double latitudeRef, double longitudeRef, double latitude, double longitude) {
        return MapTileUtil.getOffsetFrom(latitudeRef, longitudeRef, latitude, longitude, 22);
    }

    public static double[] getOffsetFrom(double latitudeRef, double longitudeRef, double latitude, double longitude, int levelOfDetail) {
        latitude = MapTileUtil.clip(latitude, -85.05112878, 85.05112878);
        longitude = MapTileUtil.clip(longitude, -180.0, 180.0);
        double x = (longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(latitude * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        int mapSize = MapTileUtil.mapSize(levelOfDetail);
        double pixelX = MapTileUtil.clip(x * (double)mapSize + 0.5, 0.0, mapSize - 1);
        double pixelY = MapTileUtil.clip(y * (double)mapSize + 0.5, 0.0, mapSize - 1);
        double gRes = MapTileUtil.groundResolution(latitudeRef, levelOfDetail);
        double[] locD = new double[]{pixelX * gRes, pixelY * gRes};
        latitude = MapTileUtil.clip(latitudeRef, -85.05112878, 85.05112878);
        longitude = MapTileUtil.clip(longitudeRef, -180.0, 180.0);
        x = (longitude + 180.0) / 360.0;
        sinLatitude = Math.sin(latitude * Math.PI / 180.0);
        y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        mapSize = MapTileUtil.mapSize(levelOfDetail);
        pixelX = MapTileUtil.clip(x * (double)mapSize + 0.5, 0.0, mapSize - 1);
        pixelY = MapTileUtil.clip(y * (double)mapSize + 0.5, 0.0, mapSize - 1);
        double[] locDC = new double[]{pixelX * gRes, pixelY * gRes};
        return new double[]{-(locD[1] - locDC[1]), locD[0] - locDC[0]};
    }

    public static double[] getOffsetInPixels(LocationType start, LocationType end, int level) {
        level = (int)MapTileUtil.clip(level, 1.0, 22.0);
        Point2D pointStart = start.getPointInPixel(level);
        Point2D pointEnd = end.getPointInPixel(level);
        return new double[]{pointEnd.getX() - pointStart.getX(), pointEnd.getY() - pointStart.getY()};
    }

    public static double[] getOffsetInPixels(LocationType start, LocationType end) {
        Object startWithOffset = start.getNewAbsoluteLatLonDepth();
        Object endWithOffset = end.getNewAbsoluteLatLonDepth();
        return MapTileUtil.getOffsetInPixels(startWithOffset, endWithOffset, 22);
    }

    double getDistanceHaversine(double lat1, double lng1, double lat2, double lng2) {
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lng2 - lng1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        return 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a)) * 6371.0 * 1000.0;
    }

    public static void main(String[] args) throws Exception {
        NeptusLog.pub().info((Object)("<###> " + MapTileUtil.tileXYToQuadKey(3, 5, 3)));
        int[] tlxy = MapTileUtil.quadKeyToTileXY("213");
        NeptusLog.pub().info((Object)("<###> " + tlxy[0] + "  " + tlxy[1]));
        int[] pxy = MapTileUtil.tileXYToPixelXY(3, 5);
        NeptusLog.pub().info((Object)("<###> " + pxy[0] + "  " + pxy[1]));
        NeptusLog.pub().info((Object)"<###> 768  1280");
        LocationType loc1 = new LocationType();
        loc1.setLatitudeStr("41N10.6938");
        loc1.setLongitudeStr("8W42.5051");
        NeptusLog.pub().info((Object)("<###>{" + loc1.getLatitudeDegs() + "\u00b0, " + loc1.getLongitudeDegs() + "\u00b0, " + loc1.getDepth() + "]"));
        LocationType loc2 = new LocationType();
        loc2.setLatitudeStr("44N40.7312");
        loc2.setLongitudeStr("63W32.2072");
        NeptusLog.pub().info((Object)("<###>{" + loc2.getLatitudeDegs() + "\u00b0, " + loc2.getLongitudeDegs() + "\u00b0, " + loc1.getDepth() + "]"));
        double[] diff1 = MapTileUtil.getOffsetFrom(loc1.getLatitudeDegs(), loc1.getLongitudeDegs(), loc2.getLatitudeDegs(), loc2.getLongitudeDegs());
        NeptusLog.pub().info((Object)("<###>[" + diff1[0] + ", " + diff1[1] + "]"));
        NeptusLog.pub().info((Object)"<###>\n--------------------------------------------------------");
        LocationType locS1 = new LocationType(loc1);
        NeptusLog.pub().info((Object)("<###> " + locS1));
        Point2D ptS1 = locS1.getPointInPixel(22);
        double[] kS1 = MapTileUtil.XYToDegrees(ptS1.getX(), ptS1.getY(), 22);
        LocationType locS2 = new LocationType();
        locS2.setLatitudeDegs(kS1[0]);
        locS2.setLongitudeDegs(kS1[1]);
        NeptusLog.pub().info((Object)("<###> " + locS2));
        kS1 = MapTileUtil.XYToDegrees((int)ptS1.getX(), (int)ptS1.getY(), 22);
        LocationType locS3 = new LocationType();
        locS3.setLatitudeDegs(kS1[0]);
        locS3.setLongitudeDegs(kS1[1]);
        NeptusLog.pub().info((Object)("<###> " + locS3));
    }
}

